/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.AbstractNodeSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;

public final class EmptyNodeSet
extends AbstractNodeSet {
    public static final EmptyNodeSetIterator EMPTY_ITERATOR = new EmptyNodeSetIterator();
    public static final EmptyCollectionIterator EMPTY_COLLECTION_ITERATOR = new EmptyCollectionIterator();

    @Override
    public NodeSetIterator iterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return SequenceIterator.EMPTY_ITERATOR;
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        return SequenceIterator.EMPTY_ITERATOR;
    }

    @Override
    public boolean contains(NodeProxy proxy) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean hasOne() {
        return false;
    }

    @Override
    public void add(NodeProxy proxy) {
    }

    @Override
    public void addAll(NodeSet other) {
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getItemCount() {
        return 0;
    }

    @Override
    public Node item(int pos) {
        return null;
    }

    @Override
    public Item itemAt(int pos) {
        return null;
    }

    @Override
    public NodeProxy get(int pos) {
        return null;
    }

    @Override
    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        return null;
    }

    @Override
    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
        return null;
    }

    @Override
    public NodeProxy get(NodeProxy proxy) {
        return null;
    }

    @Override
    public NodeSet intersection(NodeSet other) {
        return this;
    }

    @Override
    public NodeSet deepIntersection(NodeSet other) {
        return this;
    }

    @Override
    public NodeSet union(NodeSet other) {
        return other;
    }

    private static final class EmptyCollectionIterator
    implements Iterator<Collection> {
        private EmptyCollectionIterator() {
        }

        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final Collection next() {
            throw new NoSuchElementException("There are no collections in the empty set");
        }

        @Override
        public final void remove() {
            throw new IllegalStateException("Cannot remove collection from an empty set");
        }
    }

    private static final class EmptyNodeSetIterator
    implements NodeSetIterator {
        private EmptyNodeSetIterator() {
        }

        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final NodeProxy next() {
            throw new NoSuchElementException("There are no nodes in the empty set");
        }

        @Override
        public final void remove() {
            throw new IllegalStateException("Cannot remove node from an empty set");
        }

        @Override
        public final NodeProxy peekNode() {
            throw new IllegalStateException("Cannot peek into an empty set");
        }

        @Override
        public final void setPosition(NodeProxy proxy) {
            throw new IllegalStateException("Cannot reposition within an empty set");
        }

        public final String toString() {
            return "Empty#" + super.toString();
        }
    }
}

