/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.IOException;
import org.exist.security.UUIDGenerator;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class LockToken {
    private byte type = (byte)4;
    public static final byte LOCK_TYPE_NONE = 0;
    public static final byte LOCK_TYPE_WRITE = 1;
    public static final byte LOCK_TYPE_NOT_SET = 4;
    private byte depth = (byte)4;
    public static final byte LOCK_DEPTH_0 = 0;
    public static final byte LOCK_DEPTH_1 = 1;
    public static final byte LOCK_DEPTH_INFINIY = 2;
    public static final byte LOCK_DEPTH_NOT_SET = 4;
    private byte scope = (byte)4;
    public static final byte LOCK_SCOPE_NONE = 0;
    public static final byte LOCK_SCOPE_EXCLUSIVE = 1;
    public static final byte LOCK_SCOPE_SHARED = 2;
    public static final byte LOCK_SCOPE_NOT_SET = 4;
    public static final long LOCK_TIMEOUT_INFINITE = -1L;
    public static final long NO_LOCK_TIMEOUT = -2L;
    private byte resourceType = 0;
    public static final byte RESOURCE_TYPE_NOT_SPECIFIED = 0;
    public static final byte RESOURCE_TYPE_NULL_RESOURCE = 1;
    private String owner = null;
    private long timeout = -1L;
    private String token = null;

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getDepth() {
        return this.depth;
    }

    public void setDepth(byte depth) {
        this.depth = depth;
    }

    public byte getScope() {
        return this.scope;
    }

    public void setScope(byte scope) {
        this.scope = scope;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public long getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(long timeout) {
        this.timeout = timeout;
    }

    public String getOpaqueLockToken() {
        return this.token;
    }

    public void setOpaqueLockToken(String token) {
        this.token = token;
    }

    public byte getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(byte type) {
        this.resourceType = type;
    }

    public boolean isNullResource() {
        return this.resourceType == 1;
    }

    public void createOpaqueLockToken() {
        this.token = LockToken.generateUUID();
    }

    public static String generateUUID() {
        return UUIDGenerator.getUUID();
    }

    public void write(VariableByteOutputStream ostream) throws IOException {
        ostream.writeByte(this.type);
        ostream.writeByte(this.depth);
        ostream.writeByte(this.scope);
        ostream.writeUTF(this.owner != null ? this.owner : "");
        ostream.writeLong(this.timeout);
        ostream.writeUTF(this.token != null ? this.token : "");
        ostream.writeByte(this.resourceType);
    }

    public void read(VariableByteInput istream) throws IOException {
        this.type = istream.readByte();
        this.depth = istream.readByte();
        this.scope = istream.readByte();
        this.owner = istream.readUTF();
        if (this.owner.length() == 0) {
            this.owner = null;
        }
        this.timeout = istream.readLong();
        this.token = istream.readUTF();
        if (this.token.length() == 0) {
            this.token = null;
        }
        this.resourceType = istream.readByte();
    }
}

