/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.exist.collections.Collection;
import org.exist.dom.persistent.AbstractArrayNodeSet;
import org.exist.dom.persistent.ContextItem;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.FastQSort;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;

public class NewArrayNodeSet
extends AbstractArrayNodeSet
implements ExtNodeSet,
DocumentSet {
    private final Deque<Runnable> lockReleasers = new ArrayDeque<Runnable>();
    private Set<Collection> cachedCollections = null;
    private int[] documentIds = new int[16];
    private int[] documentOffsets = new int[16];
    private int[] documentLengths = new int[16];
    private int documentCount = 0;
    private NodeProxy[] nodes;

    public NewArrayNodeSet() {
        this.nodes = new NodeProxy[64];
    }

    public NewArrayNodeSet(NewArrayNodeSet other) {
        this.size = other.size;
        this.isSorted = other.isSorted;
        this.hasOne = other.hasOne;
        this.itemType = other.itemType;
        this.nodes = new NodeProxy[other.nodes.length];
        System.arraycopy(other.nodes, 0, this.nodes, 0, this.nodes.length);
        this.documentCount = other.documentCount;
        this.documentIds = new int[other.documentIds.length];
        System.arraycopy(other.documentIds, 0, this.documentIds, 0, this.documentIds.length);
        this.documentOffsets = new int[other.documentOffsets.length];
        System.arraycopy(other.documentOffsets, 0, this.documentOffsets, 0, this.documentOffsets.length);
        this.documentLengths = new int[other.documentLengths.length];
        System.arraycopy(other.documentLengths, 0, this.documentLengths, 0, this.documentLengths.length);
    }

    private void ensureCapacity() {
        if (this.size == this.nodes.length) {
            int nsize = this.size << 1;
            NodeProxy[] temp = new NodeProxy[nsize];
            System.arraycopy(this.nodes, 0, temp, 0, this.size);
            this.nodes = temp;
        }
    }

    private int findDoc(DocumentImpl doc) {
        return this.findDoc(doc.getDocId());
    }

    private int findDoc(int docId) {
        int low = 0;
        int high = this.documentCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.documentIds[mid];
            if (midVal < docId) {
                low = mid + 1;
                continue;
            }
            if (midVal > docId) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public NodeSet copy() {
        return new NewArrayNodeSet(this);
    }

    @Override
    public void reset() {
        Arrays.fill(this.nodes, null);
        this.documentCount = 0;
        this.size = 0;
        this.isSorted = false;
        this.state = 0;
    }

    @Override
    protected final void addInternal(NodeProxy proxy, int sizeHint) {
        this.ensureCapacity();
        this.nodes[this.size++] = proxy;
    }

    @Override
    public int getSizeHint(DocumentImpl doc) {
        int idx;
        if (!this.isSorted()) {
            this.sort();
        }
        return (idx = this.findDoc(doc)) < 0 ? -1 : this.documentLengths[idx];
    }

    @Override
    public NodeSetIterator iterator() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new NewArrayIterator();
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        this.sortInDocumentOrder();
        return new NewArrayIterator();
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        if (!this.isSorted()) {
            this.sort();
        }
        return new NewArrayIterator();
    }

    @Override
    public boolean contains(NodeProxy proxy) {
        this.sort();
        int idx = this.findDoc(proxy.getOwnerDocument());
        if (idx < 0) {
            return false;
        }
        return this.get(idx, proxy.getNodeId()) != null;
    }

    @Override
    public NodeProxy get(int pos) {
        if (pos < 0 || pos >= this.size) {
            return null;
        }
        return this.nodes[pos];
    }

    @Override
    public NodeProxy get(NodeProxy proxy) {
        this.sort();
        int idx = this.findDoc(proxy.getOwnerDocument());
        if (idx < 0) {
            return null;
        }
        return this.get(idx, proxy.getNodeId());
    }

    @Override
    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        this.sort();
        int idx = this.findDoc(doc);
        if (idx < 0) {
            return null;
        }
        return this.get(idx, nodeId);
    }

    private NodeProxy get(int docIdx, NodeId nodeId) {
        if (!this.isSorted()) {
            this.sort();
        }
        int low = this.documentOffsets[docIdx];
        int high = low + (this.documentLengths[docIdx] - 1);
        while (low <= high) {
            int mid = (low + high) / 2;
            NodeProxy p = this.nodes[mid];
            int cmp = p.getNodeId().compareTo(nodeId);
            if (cmp == 0) {
                return p;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return null;
    }

    @Override
    protected final NodeSet getDescendantsInSet(NodeSet al, boolean childOnly, boolean includeSelf, int mode, int contextId, boolean copyMatches) {
        this.sort();
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (NodeProxy node : al) {
            int docIdx = this.findDoc(node.getOwnerDocument());
            if (docIdx <= -1) continue;
            this.getDescendantsInSet(docIdx, result, node, childOnly, includeSelf, mode, contextId, copyMatches);
        }
        return result;
    }

    private NodeSet getDescendantsInSet(int docIdx, NodeSet result, NodeProxy parent, boolean childOnly, boolean includeSelf, int mode, int contextId, boolean copyMatches) {
        NodeId parentId = parent.getNodeId();
        if (parentId == NodeId.DOCUMENT_NODE) {
            int end = this.documentOffsets[docIdx] + this.documentLengths[docIdx];
            block8: for (int i = this.documentOffsets[docIdx]; i < end; ++i) {
                boolean add;
                if (childOnly) {
                    add = this.nodes[i].getNodeId().getTreeLevel() == 1;
                } else if (includeSelf) {
                    add = true;
                } else {
                    boolean bl = add = this.nodes[i].getNodeId() != NodeId.DOCUMENT_NODE;
                }
                if (!add) continue;
                switch (mode) {
                    case 1: {
                        if (-1 != contextId) {
                            this.nodes[i].deepCopyContext(parent, contextId);
                        } else {
                            this.nodes[i].copyContext(parent);
                        }
                        if (copyMatches) {
                            this.nodes[i].addMatches(parent);
                        }
                        result.add(this.nodes[i]);
                        continue block8;
                    }
                    case 0: {
                        if (-1 != contextId) {
                            parent.deepCopyContext(this.nodes[i], contextId);
                        } else {
                            parent.copyContext(this.nodes[i]);
                        }
                        if (copyMatches) {
                            parent.addMatches(this.nodes[i]);
                        }
                        result.add(parent, 1);
                    }
                }
            }
        } else {
            int cmp;
            NodeProxy p;
            int low = this.documentOffsets[docIdx];
            int high = low + (this.documentLengths[docIdx] - 1);
            int end = low + this.documentLengths[docIdx];
            int mid = low;
            while (low <= high && !(p = this.nodes[mid = (low + high) / 2]).getNodeId().isDescendantOrSelfOf(parentId)) {
                cmp = p.getNodeId().compareTo(parentId);
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) {
                return result;
            }
            while (mid > this.documentOffsets[docIdx] && this.nodes[mid - 1].getNodeId().compareTo(parentId) > -1) {
                --mid;
            }
            block11: for (int i = mid; i < end && (cmp = this.nodes[i].getNodeId().computeRelation(parentId)) > -1; ++i) {
                boolean add = true;
                if (childOnly) {
                    add = cmp == 1;
                } else if (cmp == 3) {
                    add = includeSelf;
                }
                if (!add) continue;
                switch (mode) {
                    case 1: {
                        if (-1 != contextId) {
                            this.nodes[i].deepCopyContext(parent, contextId);
                        } else {
                            this.nodes[i].copyContext(parent);
                        }
                        if (copyMatches) {
                            this.nodes[i].addMatches(parent);
                        }
                        result.add(this.nodes[i]);
                        continue block11;
                    }
                    case 0: {
                        if (-1 != contextId) {
                            parent.deepCopyContext(this.nodes[i], contextId);
                        } else {
                            parent.copyContext(this.nodes[i]);
                        }
                        if (copyMatches) {
                            parent.addMatches(this.nodes[i]);
                        }
                        result.add(parent, 1);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public NodeProxy hasDescendantsInSet(DocumentImpl doc, NodeId ancestorId, boolean includeSelf, int contextId, boolean copyMatches) {
        this.sort();
        int docIdx = this.findDoc(doc);
        if (docIdx < 0) {
            return null;
        }
        return this.hasDescendantsInSet(docIdx, ancestorId, contextId, includeSelf, copyMatches);
    }

    private NodeProxy hasDescendantsInSet(int docIdx, NodeId ancestorId, int contextId, boolean includeSelf, boolean copyMatches) {
        int cmp;
        NodeId id;
        int low = this.documentOffsets[docIdx];
        int high = low + (this.documentLengths[docIdx] - 1);
        int end = low + this.documentLengths[docIdx];
        int mid = 0;
        while (low <= high && !(id = this.nodes[mid = (low + high) / 2].getNodeId()).isDescendantOrSelfOf(ancestorId)) {
            cmp = id.compareTo(ancestorId);
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (low > high) {
            return null;
        }
        while (mid > this.documentOffsets[docIdx] && this.nodes[mid - 1].getNodeId().compareTo(ancestorId) >= 0) {
            --mid;
        }
        NodeProxy ancestor = new NodeProxy(this.nodes[this.documentOffsets[docIdx]].getOwnerDocument(), ancestorId, 1);
        boolean foundOne = false;
        for (int i = mid; i < end && (cmp = this.nodes[i].getNodeId().computeRelation(ancestorId)) > -1; ++i) {
            boolean add = true;
            if (cmp == 3) {
                add = includeSelf;
            }
            if (!add) continue;
            if (-1 != contextId) {
                ancestor.deepCopyContext(this.nodes[i], contextId);
            } else {
                ancestor.copyContext(this.nodes[i]);
            }
            if (copyMatches) {
                ancestor.addMatches(this.nodes[i]);
            }
            foundOne = true;
        }
        return foundOne ? ancestor : null;
    }

    @Override
    public void sort(boolean mergeContexts) {
        if (this.isSorted) {
            return;
        }
        if (this.hasOne) {
            this.isSorted = true;
            this.removeDuplicates(mergeContexts);
            this.updateDocs();
            return;
        }
        if (this.size > 0) {
            FastQSort.sort((Comparable[])this.nodes, (int)0, (int)(this.size - 1));
            this.removeDuplicates(mergeContexts);
        }
        this.updateDocs();
        this.isSorted = true;
    }

    public void updateNoSort() {
        if (this.needsSort()) {
            this.sort(false);
        } else {
            this.updateDocs();
            this.isSorted = true;
        }
    }

    private boolean needsSort() {
        if (this.hasOne) {
            return false;
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.nodes[i].compareTo(this.nodes[i - 1]) >= 0) continue;
            return true;
        }
        return false;
    }

    private void updateDocs() {
        if (this.size == 1) {
            this.documentIds[0] = this.nodes[0].getOwnerDocument().getDocId();
            this.documentOffsets[0] = 0;
            this.documentLengths[0] = 1;
            this.documentCount = 1;
        } else {
            this.documentCount = 0;
            for (int i = 0; i < this.size; ++i) {
                if (i == 0) {
                    this.documentIds[0] = this.nodes[0].getOwnerDocument().getDocId();
                    this.documentOffsets[0] = 0;
                    this.documentLengths[0] = 1;
                    ++this.documentCount;
                    continue;
                }
                if (this.documentIds[this.documentCount - 1] == this.nodes[i].getOwnerDocument().getDocId()) {
                    int n = this.documentCount - 1;
                    this.documentLengths[n] = this.documentLengths[n] + 1;
                    continue;
                }
                this.ensureDocCapacity();
                this.documentIds[this.documentCount] = this.nodes[i].getOwnerDocument().getDocId();
                this.documentOffsets[this.documentCount] = i;
                this.documentLengths[this.documentCount++] = 1;
            }
        }
    }

    private void ensureDocCapacity() {
        if (this.documentCount == this.documentIds.length) {
            int nlen = this.documentCount << 1;
            int[] temp = new int[nlen];
            System.arraycopy(this.documentIds, 0, temp, 0, this.documentCount);
            this.documentIds = temp;
            temp = new int[nlen];
            System.arraycopy(this.documentOffsets, 0, temp, 0, this.documentCount);
            this.documentOffsets = temp;
            temp = new int[nlen];
            System.arraycopy(this.documentLengths, 0, temp, 0, this.documentCount);
            this.documentLengths = temp;
        }
    }

    private int removeDuplicates(boolean mergeContext) {
        int j = 0;
        for (int i = 1; i < this.size; ++i) {
            if (this.nodes[i].compareTo(this.nodes[j]) != 0) {
                if (i == ++j) continue;
                this.nodes[j] = this.nodes[i];
                continue;
            }
            if (mergeContext) {
                this.nodes[j].addContext(this.nodes[i]);
            }
            this.nodes[j].addMatches(this.nodes[i]);
        }
        this.size = ++j;
        return this.size;
    }

    @Override
    public void setSelfAsContext(int contextId) throws XPathException {
        for (int i = 0; i < this.size; ++i) {
            this.nodes[i].addContextNode(contextId, this.nodes[i]);
        }
    }

    @Override
    public NodeSet selectPrecedingSiblings(NodeSet contextSet, int contextId) {
        this.sort();
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (NodeProxy reference : contextSet) {
            NodeId currentId;
            NodeProxy p;
            NodeId parentId = reference.getNodeId().getParentId();
            int docIdx = this.findDoc(reference.getOwnerDocument());
            if (docIdx < 0) continue;
            int low = this.documentOffsets[docIdx];
            int high = low + (this.documentLengths[docIdx] - 1);
            int end = low + this.documentLengths[docIdx];
            int mid = low;
            while (low <= high && !(p = this.nodes[mid = (low + high) / 2]).getNodeId().isDescendantOf(parentId)) {
                int cmp = p.getNodeId().compareTo(parentId);
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) continue;
            while (mid < end && this.nodes[mid].getNodeId().isDescendantOf(parentId)) {
                ++mid;
            }
            NodeId refId = reference.getNodeId();
            for (int i = --mid; i >= this.documentOffsets[docIdx] && (currentId = this.nodes[i].getNodeId()).isDescendantOf(parentId); --i) {
                if (currentId.getTreeLevel() != refId.getTreeLevel() || currentId.compareTo(refId) >= 0) continue;
                if (-2 != contextId) {
                    if (-1 == contextId) {
                        this.nodes[i].copyContext(reference);
                    } else {
                        this.nodes[i].addContextNode(contextId, reference);
                    }
                }
                result.add(this.nodes[i]);
            }
        }
        return result;
    }

    @Override
    public NodeSet selectFollowingSiblings(NodeSet contextSet, int contextId) {
        this.sort();
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (NodeProxy reference : contextSet) {
            NodeId currentId;
            NodeProxy p;
            NodeId parentId = reference.getNodeId().getParentId();
            int docIdx = this.findDoc(reference.getOwnerDocument());
            if (docIdx < 0) continue;
            int low = this.documentOffsets[docIdx];
            int high = low + (this.documentLengths[docIdx] - 1);
            int end = low + this.documentLengths[docIdx];
            int mid = low;
            while (low <= high && !(p = this.nodes[mid = (low + high) / 2]).getNodeId().isDescendantOf(parentId)) {
                int cmp = p.getNodeId().compareTo(parentId);
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) continue;
            while (mid > this.documentOffsets[docIdx] && this.nodes[mid - 1].getNodeId().compareTo(parentId) > -1) {
                --mid;
            }
            NodeId refId = reference.getNodeId();
            for (int i = mid; i < end && (currentId = this.nodes[i].getNodeId()).isDescendantOf(parentId); ++i) {
                if (currentId.getTreeLevel() != refId.getTreeLevel() || currentId.compareTo(refId) <= 0) continue;
                if (-2 != contextId) {
                    if (-1 == contextId) {
                        this.nodes[i].copyContext(reference);
                    } else {
                        this.nodes[i].addContextNode(contextId, reference);
                    }
                }
                result.add(this.nodes[i]);
            }
        }
        return result;
    }

    @Override
    public NodeSet selectFollowing(NodeSet fl, int contextId) throws XPathException {
        return this.selectFollowing(fl, -1, contextId);
    }

    @Override
    public NodeSet selectFollowing(NodeSet pl, int position, int contextId) throws XPathException, UnsupportedOperationException {
        this.sort();
        NewArrayNodeSet result = new NewArrayNodeSet();
        block0: for (NodeProxy reference : pl) {
            int idx = this.findDoc(reference.getOwnerDocument());
            if (idx < 0) continue;
            for (int i = this.documentOffsets[idx]; i < this.size && this.nodes[i].getOwnerDocument().getDocId() == reference.getOwnerDocument().getDocId() && (this.nodes[i].compareTo(reference) <= 0 || this.nodes[i].getNodeId().isDescendantOf(reference.getNodeId())); ++i) {
            }
            int n = 0;
            for (int j = i; j < this.size && this.nodes[j].getOwnerDocument().getDocId() == reference.getOwnerDocument().getDocId(); ++j) {
                if (reference.getNodeId().isDescendantOf(this.nodes[j].getNodeId())) continue;
                if (position < 0 || ++n == position) {
                    if (-2 != contextId) {
                        if (-1 == contextId) {
                            this.nodes[j].copyContext(reference);
                        } else {
                            this.nodes[j].addContextNode(contextId, reference);
                        }
                    }
                    result.add(this.nodes[j]);
                }
                if (n == position) continue block0;
            }
        }
        return result;
    }

    @Override
    public NodeSet selectPreceding(NodeSet pl, int contextId) throws XPathException {
        return this.selectPreceding(pl, -1, contextId);
    }

    @Override
    public NodeSet selectPreceding(NodeSet pl, int position, int contextId) throws XPathException, UnsupportedOperationException {
        this.sort();
        NewArrayNodeSet result = new NewArrayNodeSet();
        block0: for (NodeProxy reference : pl) {
            int idx = this.findDoc(reference.getOwnerDocument());
            if (idx < 0) continue;
            for (int i = this.documentOffsets[idx]; i < this.size && this.nodes[i].compareTo(reference) < 0; ++i) {
            }
            int n = 0;
            for (int j = --i; j >= this.documentOffsets[idx]; --j) {
                if (reference.getNodeId().isDescendantOf(this.nodes[j].getNodeId())) continue;
                if (position < 0 || ++n == position) {
                    if (-2 != contextId) {
                        if (-1 == contextId) {
                            this.nodes[j].copyContext(reference);
                        } else {
                            this.nodes[j].addContextNode(contextId, reference);
                        }
                    }
                    result.add(this.nodes[j]);
                }
                if (n == position) continue block0;
            }
        }
        return result;
    }

    @Override
    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
        this.sort();
        int docIdx = this.findDoc(doc);
        if (docIdx < 0) {
            return null;
        }
        return this.parentWithChild(docIdx, nodeId, directParent, includeSelf);
    }

    private NodeProxy parentWithChild(int docIdx, NodeId nodeId, boolean directParent, boolean includeSelf) {
        NodeProxy temp;
        if (includeSelf && (temp = this.get(docIdx, nodeId)) != null) {
            return temp;
        }
        for (NodeId parentNodeId = nodeId.getParentId(); parentNodeId != null; parentNodeId = parentNodeId.getParentId()) {
            temp = this.get(docIdx, parentNodeId);
            if (temp != null) {
                return temp;
            }
            if (!directParent) continue;
            return null;
        }
        return null;
    }

    @Override
    public NodeSet except(NodeSet other) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (int i = 0; i < this.size; ++i) {
            if (other.contains(this.nodes[i])) continue;
            result.add(this.nodes[i]);
        }
        return result;
    }

    @Override
    public NodeSet getContextNodes(int contextId) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        DocumentImpl lastDoc = null;
        for (int i = 0; i < this.size; ++i) {
            NodeProxy current = this.nodes[i];
            for (ContextItem contextNode = current.getContext(); contextNode != null; contextNode = contextNode.getNextDirect()) {
                if (contextNode.getContextId() != contextId) continue;
                NodeProxy context = contextNode.getNode();
                context.addMatches(current);
                if (-1 != contextId) {
                    context.addContextNode(contextId, context);
                }
                if (lastDoc != null && lastDoc.getDocId() != context.getOwnerDocument().getDocId()) {
                    lastDoc = context.getOwnerDocument();
                    result.add(context, this.getSizeHint(lastDoc));
                    continue;
                }
                result.add(context);
            }
        }
        return result;
    }

    public String debugParts() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.documentCount; ++i) {
            buf.append(this.documentIds[i]);
            buf.append(' ');
        }
        return buf.toString();
    }

    @Override
    public int getIndexType() {
        if (this.indexType == 12) {
            for (int i = 0; i < this.size; ++i) {
                NodeProxy node = this.nodes[i];
                if (node.getOwnerDocument().getCollection().isTempCollection()) {
                    this.indexType = 11;
                    break;
                }
                int nodeIndexType = node.getIndexType();
                if (this.indexType == 12) {
                    this.indexType = nodeIndexType;
                    continue;
                }
                if (this.indexType == nodeIndexType) continue;
                this.indexType = 11;
            }
        }
        return this.indexType;
    }

    @Override
    public boolean equalDocs(DocumentSet other) {
        if (this == other) {
            return true;
        }
        this.sort();
        if (this.documentCount != other.getDocumentCount()) {
            return false;
        }
        for (int i = 0; i < this.documentCount; ++i) {
            if (other.contains(this.documentIds[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        this.sort();
        if (this.cachedCollections == null) {
            this.cachedCollections = new HashSet<Collection>();
            for (int i = 0; i < this.documentCount; ++i) {
                DocumentImpl doc = this.nodes[this.documentOffsets[i]].getOwnerDocument();
                if (this.cachedCollections.contains(doc.getCollection())) continue;
                this.cachedCollections.add(doc.getCollection());
            }
        }
        return this.cachedCollections.iterator();
    }

    @Override
    public Iterator<DocumentImpl> getDocumentIterator() {
        this.sort();
        return new DocumentIterator();
    }

    @Override
    public int getDocumentCount() {
        this.sort();
        return this.documentCount;
    }

    @Override
    public DocumentImpl getDoc(int docId) {
        this.sort();
        int idx = this.findDoc(docId);
        if (idx < 0) {
            return null;
        }
        return this.nodes[this.documentOffsets[idx]].getOwnerDocument();
    }

    @Override
    public XmldbURI[] getNames() {
        this.sort();
        XmldbURI[] uris = new XmldbURI[this.documentCount];
        for (int i = 0; i < this.documentCount; ++i) {
            uris[i] = this.nodes[this.documentOffsets[i]].getOwnerDocument().getURI();
        }
        return uris;
    }

    @Override
    public DocumentSet intersection(DocumentSet other) {
        DocumentImpl doc;
        this.sort();
        DefaultDocumentSet set = new DefaultDocumentSet();
        for (int i = 0; i < this.documentCount; ++i) {
            doc = this.nodes[this.documentOffsets[i]].getOwnerDocument();
            if (!other.contains(doc.getDocId())) continue;
            set.add(doc);
        }
        Iterator<DocumentImpl> i = other.getDocumentIterator();
        while (i.hasNext()) {
            doc = i.next();
            if (!this.contains(doc.getDocId()) || set.contains(doc.getDocId())) continue;
            set.add(doc);
        }
        return set;
    }

    @Override
    public boolean contains(DocumentSet other) {
        this.sort();
        if (other.getDocumentCount() > this.documentCount) {
            return false;
        }
        Iterator<DocumentImpl> i = other.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl doc = i.next();
            if (this.contains(doc.getDocId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(int docId) {
        this.sort();
        return this.findDoc(docId) > -1;
    }

    @Override
    public NodeSet docsToNodeSet() {
        this.sort();
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (int i = 0; i < this.documentCount; ++i) {
            DocumentImpl doc = this.nodes[this.documentOffsets[i]].getOwnerDocument();
            if (doc.getResourceType() != 0) continue;
            result.add(new NodeProxy(doc, NodeId.DOCUMENT_NODE));
        }
        return result;
    }

    @Override
    public void lock(DBBroker broker, boolean exclusive) throws LockException {
        this.sort();
        for (int idx = 0; idx < this.documentCount; ++idx) {
            DocumentImpl doc = this.nodes[this.documentOffsets[idx]].getOwnerDocument();
            Lock docLock = doc.getUpdateLock();
            docLock.acquire(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK);
            this.lockReleasers.push(() -> docLock.release(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK));
        }
    }

    @Override
    public void unlock() {
        while (!this.lockReleasers.isEmpty()) {
            this.lockReleasers.pop().run();
        }
    }

    @Override
    public void clearContext(int contextId) throws XPathException {
        for (int i = 0; i < this.size; ++i) {
            this.nodes[i].clearContext(contextId);
        }
    }

    private class NewArrayIterator
    implements NodeSetIterator,
    SequenceIterator {
        int pos = 0;

        private NewArrayIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.pos < NewArrayNodeSet.this.size && this.pos > -1;
        }

        @Override
        public final NodeProxy next() {
            if (this.pos == NewArrayNodeSet.this.size || this.pos < 0) {
                this.pos = -1;
                throw new NoSuchElementException();
            }
            return NewArrayNodeSet.this.nodes[this.pos++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final NodeProxy peekNode() {
            if (this.pos == NewArrayNodeSet.this.size || this.pos < 0) {
                this.pos = -1;
                return null;
            }
            return NewArrayNodeSet.this.nodes[this.pos];
        }

        @Override
        public final Item nextItem() {
            if (this.pos == NewArrayNodeSet.this.size || this.pos < 0) {
                this.pos = -1;
                return null;
            }
            return NewArrayNodeSet.this.nodes[this.pos++];
        }

        @Override
        public void setPosition(NodeProxy proxy) {
            int docIdx = NewArrayNodeSet.this.findDoc(proxy.getOwnerDocument());
            if (docIdx > -1) {
                int low = NewArrayNodeSet.this.documentOffsets[docIdx];
                int high = low + (NewArrayNodeSet.this.documentLengths[docIdx] - 1);
                while (low <= high) {
                    int mid = (low + high) / 2;
                    NodeProxy p = NewArrayNodeSet.this.nodes[mid];
                    int cmp = p.getNodeId().compareTo(proxy.getNodeId());
                    if (cmp == 0) {
                        this.pos = mid;
                        return;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    low = mid + 1;
                }
            }
            this.pos = -1;
        }
    }

    private class DocumentIterator
    implements Iterator<DocumentImpl> {
        private int currentDoc = 0;

        private DocumentIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.currentDoc < NewArrayNodeSet.this.documentCount;
        }

        @Override
        public final DocumentImpl next() {
            if (this.currentDoc == NewArrayNodeSet.this.documentCount) {
                throw new NoSuchElementException();
            }
            return NewArrayNodeSet.this.nodes[NewArrayNodeSet.this.documentOffsets[this.currentDoc++]].getOwnerDocument();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

