/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.INode;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NamedNode;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.storage.txn.Txn;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl<T extends NodeImpl>
implements INode<DocumentImpl, T> {
    protected static final Logger LOG = LogManager.getLogger(NodeImpl.class);

    @Override
    public Node cloneNode(boolean deep) {
        throw this.unsupported();
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == 9 && newChild != this.getOwnerDocument() || newChild.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, "Owning document IDs do not match");
        }
        throw this.unsupported();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw this.unsupported();
    }

    public void appendChildren(Txn transaction, NodeList nodes, int child) throws DOMException {
        throw this.unsupported();
    }

    public Node removeChild(Txn transaction, Node oldChild) throws DOMException {
        throw this.unsupported();
    }

    public Node replaceChild(Txn transaction, Node newChild, Node oldChild) throws DOMException {
        throw this.unsupported();
    }

    public IStoredNode updateChild(Txn transaction, Node oldChild, Node newChild) throws DOMException {
        throw this.unsupported();
    }

    public void insertBefore(Txn transaction, NodeList nodes, Node refChild) throws DOMException {
        throw this.unsupported();
    }

    public void insertAfter(Txn transaction, NodeList nodes, Node refChild) throws DOMException {
        throw this.unsupported();
    }

    public int getChildCount() {
        throw this.unsupported();
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeListImpl();
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String value) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public boolean isSupported(String key, String value) {
        throw this.unsupported();
    }

    @Override
    public void normalize() {
        throw this.unsupported();
    }

    @Override
    public String getBaseURI() {
        throw this.unsupported();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public String getTextContent() throws DOMException {
        throw this.unsupported();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw this.unsupported();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw this.unsupported();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw this.unsupported();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw this.unsupported();
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw this.unsupported();
    }

    @Override
    public Object getUserData(String key) {
        throw this.unsupported();
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw this.unsupported();
    }

    @Override
    public String getPrefix() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                String prefix = this.getQName().getPrefix();
                return prefix;
            }
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if (prefix == null || this.getNodeType() == 9) {
            return;
        }
        QName nodeName = this.getQName();
        if (nodeName != null) {
            this.setQName(new QName(nodeName.getLocalPart(), nodeName.getNamespaceURI(), prefix));
        }
    }

    @Override
    public final String getNamespaceURI() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                String nsUri = this.getQName().getNamespaceURI();
                if (nsUri.equals("")) {
                    return null;
                }
                return nsUri;
            }
        }
        return null;
    }

    @Override
    public String getLocalName() {
        if (this instanceof NamedNode) {
            return this.getQName().getLocalPart();
        }
        return null;
    }

    @Override
    public final String getNodeName() {
        switch (this.getNodeType()) {
            case 10: {
                return ((DocumentTypeImpl)this).getName();
            }
            case 9: {
                return "#document";
            }
            case 11: {
                return "#document-fragment";
            }
            case 1: 
            case 2: {
                return this.getQName().getStringValue();
            }
            case 7: {
                return ((ProcessingInstructionImpl)this).getTarget();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 4: {
                return "#cdata-section";
            }
        }
        return "#unknown";
    }

    protected DOMException unsupported() {
        return new DOMException(9, "not implemented on class: " + this.getClass().getName());
    }
}

