/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.persistent.AbstractArrayNodeSet;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.ContextItem;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetHelper;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.StorageAddress;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.UntypedAtomicValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class NodeProxy
implements NodeSet,
NodeValue,
NodeHandle,
DocumentSet,
Comparable<Object> {
    public static final short UNKNOWN_NODE_TYPE = -1;
    public static final int UNKNOWN_NODE_LEVEL = -1;
    private final Deque<Runnable> lockReleasers = new ArrayDeque<Runnable>();
    private DocumentImpl doc = null;
    private NodeId nodeId;
    private long internalAddress = -1L;
    private short nodeType = (short)-1;
    private Match match = null;
    private ContextItem context = null;
    private QName qname = null;

    public NodeProxy(DocumentImpl doc, NodeId nodeId) {
        this(doc, nodeId, -1, -1L);
    }

    public NodeProxy(DocumentImpl doc, NodeId nodeId, long address) {
        this(doc, nodeId, -1, address);
    }

    public NodeProxy(DocumentImpl doc, NodeId nodeId, short nodeType) {
        this(doc, nodeId, nodeType, -1L);
    }

    public NodeProxy(DocumentImpl doc, NodeId nodeId, short nodeType, long address) {
        this.doc = doc;
        this.nodeType = nodeType;
        this.internalAddress = address;
        this.nodeId = nodeId;
    }

    public void update(ElementImpl element) {
        this.doc = element.getOwnerDocument();
        this.nodeType = (short)-1;
        this.internalAddress = -1L;
        this.nodeId = element.getNodeId();
        this.match = null;
        this.context = null;
    }

    public NodeProxy(NodeHandle n) {
        this((DocumentImpl)n.getOwnerDocument(), n.getNodeId(), n.getNodeType(), n.getInternalAddress());
        if (n instanceof NodeProxy) {
            this.match = ((NodeProxy)n).match;
            this.context = ((NodeProxy)n).context;
        }
    }

    public NodeProxy(DocumentImpl doc) {
        this(doc, NodeId.DOCUMENT_NODE, 9, -1L);
    }

    @Override
    public void setNodeId(NodeId id) {
        this.nodeId = id;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public QName getQName() {
        if (this.qname == null) {
            this.getNode();
        }
        return this.qname;
    }

    public void setQName(QName qname) {
        this.qname = qname;
    }

    @Override
    public int getImplementationType() {
        return 1;
    }

    @Override
    public NodeSet copy() {
        return this;
    }

    @Override
    public Sequence tail() throws XPathException {
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public int compareTo(Object other) {
        if (!(other instanceof NodeProxy)) {
            return 1;
        }
        return this.compareTo((NodeProxy)other);
    }

    @Override
    public int compareTo(NodeProxy other) {
        int diff = this.doc.getDocId() - other.doc.getDocId();
        if (diff != 0) {
            return diff;
        }
        return this.nodeId.compareTo(other.nodeId);
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeProxy)) {
            return false;
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (otherNode.doc.getDocId() != this.doc.getDocId()) {
            return false;
        }
        return otherNode.nodeId.equals(this.nodeId);
    }

    @Override
    public boolean equals(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 1) {
            throw new XPathException("Cannot compare persistent node with in-memory node");
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (otherNode.doc.getDocId() != this.doc.getDocId()) {
            return false;
        }
        return otherNode.nodeId.equals(this.nodeId);
    }

    @Override
    public boolean before(NodeValue other, boolean isPreceding) throws XPathException {
        if (other.getImplementationType() != 1) {
            throw new XPathException("Cannot compare persistent node with in-memory node");
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (this.doc.getDocId() != otherNode.doc.getDocId()) {
            return this.doc.getDocId() < otherNode.doc.getDocId();
        }
        return this.nodeId.before(otherNode.nodeId, isPreceding);
    }

    @Override
    public boolean after(NodeValue other, boolean isFollowing) throws XPathException {
        if (other.getImplementationType() != 1) {
            throw new XPathException("Cannot compare persistent node with in-memory node");
        }
        NodeProxy otherNode = (NodeProxy)other;
        if (this.doc.getDocId() != otherNode.doc.getDocId()) {
            return this.doc.getDocId() > otherNode.doc.getDocId();
        }
        return this.nodeId.after(otherNode.nodeId, isFollowing);
    }

    @Override
    public DocumentImpl getOwnerDocument() {
        return this.doc;
    }

    public boolean isDocument() {
        return this.nodeType == 9;
    }

    @Override
    public Node getNode() {
        if (this.isDocument()) {
            return this.doc;
        }
        NodeImpl realNode = (NodeImpl)this.doc.getNode(this);
        if (realNode != null) {
            this.nodeType = realNode.getNodeType();
            this.qname = realNode.getQName();
        }
        return realNode;
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(short nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public long getInternalAddress() {
        return this.internalAddress;
    }

    @Override
    public void setInternalAddress(long internalAddress) {
        this.internalAddress = internalAddress;
    }

    public void setIndexType(int type) {
        this.internalAddress = StorageAddress.setIndexType(this.internalAddress, (short)type);
    }

    @Override
    public int getIndexType() {
        if (this.internalAddress == -1L) {
            return 11;
        }
        return RangeIndexSpec.indexTypeToXPath(StorageAddress.indexTypeFromPointer(this.internalAddress));
    }

    @Override
    public void setTrackMatches(boolean track) {
    }

    @Override
    public boolean getTrackMatches() {
        return true;
    }

    public Match getMatches() {
        return this.match;
    }

    public void setMatches(Match match) {
        this.match = match;
    }

    public void addMatch(Match m) {
        if (this.match == null) {
            this.match = m;
            this.match.nextMatch = null;
            return;
        }
        Match next = this.match;
        while (next != null) {
            if (next.matchEquals(m)) {
                next.mergeOffsets(m);
                return;
            }
            if (next.nextMatch == null) {
                next.nextMatch = m;
                break;
            }
            next = next.nextMatch;
        }
    }

    public void addMatches(NodeProxy p) {
        if (p == this) {
            return;
        }
        Match m = p.getMatches();
        if (Match.matchListEquals(m, this.match)) {
            return;
        }
        while (m != null) {
            this.addMatch(m.newCopy());
            m = m.nextMatch;
        }
    }

    @Override
    public void addContextNode(int contextId, NodeValue node) {
        if (node.getImplementationType() != 1) {
            return;
        }
        NodeProxy contextNode = (NodeProxy)node;
        if (this.context == null) {
            this.context = new ContextItem(contextId, contextNode);
            return;
        }
        for (ContextItem next = this.context; !(next == null || contextId == next.getContextId() && next.getNode().getNodeId().equals(contextNode.getNodeId())); next = next.getNextDirect()) {
            if (next.getNextDirect() != null) continue;
            if (next == this.context) {
                this.context = next = new ContextItem(next.getContextId(), next.getNode());
            }
            next.setNextContextItem(new ContextItem(contextId, contextNode));
            break;
        }
    }

    public void addContext(NodeProxy other) {
        for (ContextItem next = other.context; next != null; next = next.getNextDirect()) {
            this.addContextNode(next.getContextId(), next.getNode());
        }
    }

    public void copyContext(NodeProxy node) {
        this.deepCopyContext(node);
    }

    public void deepCopyContext(NodeProxy node) {
        this.context = null;
        if (node.context == null) {
            return;
        }
        if (node.context.getNextDirect() == null) {
            this.context = node.context;
        } else {
            ContextItem newContext;
            ContextItem next = node.context;
            this.context = newContext = new ContextItem(next.getContextId(), next.getNode());
            for (next = next.getNextDirect(); next != null; next = next.getNextDirect()) {
                newContext.setNextContextItem(new ContextItem(next.getContextId(), next.getNode()));
                newContext = newContext.getNextDirect();
            }
        }
    }

    public void deepCopyContext(NodeProxy node, int addContextId) {
        if (this.context == null) {
            this.deepCopyContext(node);
        }
        this.addContextNode(addContextId, node);
    }

    @Override
    public void clearContext(int contextId) {
        if (contextId == -2) {
            this.context = null;
            return;
        }
        ContextItem newContext = null;
        ContextItem last = null;
        for (ContextItem next = this.context; next != null; next = next.getNextDirect()) {
            if (next.getContextId() == contextId) continue;
            if (newContext == null) {
                newContext = next;
            } else {
                last.setNextContextItem(next);
            }
            last = next;
            last.setNextContextItem(null);
        }
        this.context = newContext;
    }

    public ContextItem getContext() {
        return this.context;
    }

    public String debugContext() {
        StringBuilder buf = new StringBuilder();
        buf.append("Context for ").append(this.nodeId).append(" [ ").append(this.toString()).append("] : ");
        for (ContextItem next = this.context; next != null; next = next.getNextDirect()) {
            buf.append('[');
            buf.append(next.getNode().getNodeId());
            buf.append(':');
            buf.append(next.getContextId());
            buf.append("] ");
        }
        return buf.toString();
    }

    @Override
    public int getType() {
        return NodeProxy.nodeType2XQuery(this.nodeType);
    }

    public static int nodeType2XQuery(short nodeType) {
        switch (nodeType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 6;
            }
        }
        return -1;
    }

    @Override
    public boolean isPersistentSet() {
        return true;
    }

    @Override
    public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
        if (this.nodeId.equals(oldNodeId)) {
            this.nodeId = newNode.getNodeId();
            this.internalAddress = newNode.getInternalAddress();
        }
    }

    @Override
    public Sequence toSequence() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNodeValue() {
        try (DBBroker broker = this.doc.getBrokerPool().getBroker();){
            if (this.isDocument()) {
                Element e = this.doc.getDocumentElement();
                if (e instanceof NodeProxy) {
                    String string = broker.getNodeValue(((StoredNode)((Object)e)).extract(), false);
                    return string;
                }
                if (e != null) {
                    String string = broker.getNodeValue((ElementImpl)e, false);
                    return string;
                }
                String string = "";
                return string;
            }
            String string = broker.getNodeValue(this.asStoredNode(), false);
            return string;
        }
        catch (EXistException eXistException) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNodeValueSeparated() {
        try (DBBroker broker = this.doc.getBrokerPool().getBroker();){
            String string = broker.getNodeValue(this.asStoredNode(), true);
            return string;
        }
        catch (EXistException eXistException) {
            return "";
        }
    }

    public StoredNode asStoredNode() {
        return new StoredNode(this.getNodeType(), this.getNodeId(), this.getOwnerDocument(), this.getInternalAddress()){};
    }

    @Override
    public String getStringValue() {
        return this.getNodeValue();
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        return UntypedAtomicValue.convertTo(this.getNodeValue(), requiredType);
    }

    @Override
    public AtomicValue atomize() throws XPathException {
        return new UntypedAtomicValue(this.getNodeValue());
    }

    @Override
    public void toSAX(DBBroker broker, ContentHandler handler, Properties properties) throws SAXException {
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperty("sax-document-events", "false");
        if (properties != null) {
            serializer.setProperties(properties);
        }
        if (handler instanceof LexicalHandler) {
            serializer.setSAXHandlers(handler, (LexicalHandler)((Object)handler));
        } else {
            serializer.setSAXHandlers(handler, null);
        }
        serializer.toSAX(this);
    }

    @Override
    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        NodeImpl node = null;
        if (this.nodeType < 0) {
            node = (NodeImpl)this.getNode();
        }
        if (this.nodeType == 2) {
            AttrImpl attr = node == null ? (AttrImpl)this.getNode() : (AttrImpl)node;
            receiver.attribute(attr.getQName(), attr.getValue());
        } else {
            receiver.addReferenceNode(this);
        }
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(NodeProxy.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(Node.class)) {
            return 1;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 2;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(NodeProxy.class)) {
            return (T)this;
        }
        if (target.isAssignableFrom(Node.class) || target == Object.class) {
            return (T)this.getNode();
        }
        StringValue v = new StringValue(this.getStringValue());
        return v.toJavaObject(target);
    }

    @Override
    public int getItemType() {
        return this.getType();
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public void setIsCached(boolean cached) {
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        return this;
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        return null;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return true;
    }

    @Override
    public void removeDuplicates() {
    }

    @Override
    public void setSelfAsContext(int contextId) {
        this.addContextNode(contextId, this);
    }

    @Override
    public NodeSetIterator iterator() {
        return new SingleNodeIterator(this);
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return new SingleNodeIterator(this);
    }

    @Override
    public SequenceIterator unorderedIterator() {
        return new SingleNodeIterator(this);
    }

    @Override
    public boolean contains(NodeProxy proxy) {
        if (this.doc.getDocId() != proxy.doc.getDocId()) {
            return false;
        }
        return this.nodeId.equals(proxy.getNodeId());
    }

    @Override
    public void addAll(NodeSet other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean hasOne() {
        return true;
    }

    @Override
    public boolean hasMany() {
        return false;
    }

    @Override
    public void add(NodeProxy proxy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Item item) throws XPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(NodeProxy proxy, int sizeHint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public int getItemCount() {
        return 1;
    }

    @Override
    public Node item(int pos) {
        return pos > 0 ? null : this.getNode();
    }

    @Override
    public Item itemAt(int pos) {
        return pos > 0 ? null : this;
    }

    @Override
    public NodeProxy get(int pos) {
        return pos > 0 ? null : this;
    }

    @Override
    public NodeProxy get(NodeProxy p) {
        return this.contains(p) ? this : null;
    }

    @Override
    public NodeProxy get(DocumentImpl document, NodeId nodeId) {
        if (!this.nodeId.equals(nodeId)) {
            return null;
        }
        if (this.doc.getDocId() != document.getDocId()) {
            return null;
        }
        return this;
    }

    @Override
    public NodeProxy parentWithChild(NodeProxy proxy, boolean directParent, boolean includeSelf, int level) {
        return this.parentWithChild(proxy.getOwnerDocument(), proxy.getNodeId(), directParent, includeSelf);
    }

    @Override
    public NodeProxy parentWithChild(DocumentImpl otherDoc, NodeId otherId, boolean directParent, boolean includeSelf) {
        if (otherDoc.getDocId() != this.doc.getDocId()) {
            return null;
        }
        if (includeSelf && otherId.compareTo(this.nodeId) == 0) {
            return this;
        }
        for (NodeId parentId = otherId.getParentId(); parentId != null; parentId = parentId.getParentId()) {
            if (parentId.compareTo(this.nodeId) == 0) {
                return this;
            }
            if (!directParent) continue;
            return null;
        }
        return null;
    }

    @Override
    public NodeSet getContextNodes(int contextId) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (ContextItem contextNode = this.getContext(); contextNode != null; contextNode = contextNode.getNextDirect()) {
            NodeProxy p = contextNode.getNode();
            p.addMatches(this);
            if (result.contains(p)) continue;
            if (contextId != -1) {
                p.addContextNode(contextId, p);
            }
            result.add(p);
        }
        return result;
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return false;
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public int getSizeHint(DocumentImpl document) {
        if (document.getDocId() == this.doc.getDocId()) {
            return 1;
        }
        return -1;
    }

    @Override
    public DocumentSet getDocumentSet() {
        return this;
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return new Iterator<Collection>(){
            boolean hasNext = true;

            @Override
            public final boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public final Collection next() {
                this.hasNext = false;
                return NodeProxy.this.getOwnerDocument().getCollection();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException("Remove is not implemented for NodeProxt#getCollectionIterator");
            }
        };
    }

    @Override
    public NodeSet intersection(NodeSet other) {
        if (other.contains(this)) {
            return this;
        }
        return NodeSet.EMPTY_SET;
    }

    @Override
    public NodeSet deepIntersection(NodeSet other) {
        NodeProxy p = other.parentWithChild(this, false, true, -1);
        if (p == null) {
            return NodeSet.EMPTY_SET;
        }
        if (!this.nodeId.equals(p.nodeId)) {
            p.addMatches(this);
        }
        return p;
    }

    @Override
    public NodeSet union(NodeSet other) {
        if (other.isEmpty()) {
            return this;
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        result.addAll(other);
        result.add(this);
        return result;
    }

    @Override
    public NodeSet except(NodeSet other) {
        return other.contains(this) ? NodeSet.EMPTY_SET : this;
    }

    @Override
    public NodeSet filterDocuments(NodeSet otherSet) {
        DocumentSet docs = otherSet.getDocumentSet();
        if (docs.contains(this.doc.getDocId())) {
            return this;
        }
        return NodeSet.EMPTY_SET;
    }

    @Override
    public void setProcessInReverseOrder(boolean inReverseOrder) {
    }

    @Override
    public boolean getProcessInReverseOrder() {
        return false;
    }

    @Override
    public NodeSet getParents(int contextId) {
        NodeId pid = this.nodeId.getParentId();
        if (pid == null || pid == NodeId.DOCUMENT_NODE) {
            return NodeSet.EMPTY_SET;
        }
        NodeProxy parent = new NodeProxy(this.doc, pid, 1);
        if (contextId != -1) {
            parent.addContextNode(contextId, this);
        } else {
            parent.copyContext(this);
        }
        parent.addMatches(this);
        return parent;
    }

    @Override
    public NodeSet getAncestors(int contextId, boolean includeSelf) {
        NewArrayNodeSet ancestors = new NewArrayNodeSet();
        if (includeSelf) {
            ancestors.add(this);
        }
        for (NodeId parentID = this.nodeId.getParentId(); parentID != null; parentID = parentID.getParentId()) {
            NodeProxy parent = new NodeProxy(this.getOwnerDocument(), parentID, 1);
            if (contextId != -1) {
                parent.addContextNode(contextId, this);
            } else {
                parent.copyContext(this);
            }
            parent.addMatches(this);
            ancestors.add(parent);
        }
        return ancestors;
    }

    @Override
    public NodeSet selectParentChild(NodeSet al, int mode) {
        return this.selectParentChild(al, mode, -1);
    }

    @Override
    public NodeSet selectParentChild(NodeSet al, int mode, int contextId) {
        return NodeSetHelper.selectParentChild(this, al, mode, contextId);
    }

    @Override
    public boolean matchParentChild(NodeSet al, int mode, int contextId) {
        return NodeSetHelper.matchParentChild(this, al, mode, contextId);
    }

    @Override
    public NodeSet selectAncestors(NodeSet al, boolean includeSelf, int contextId) {
        return NodeSetHelper.selectAncestors(this, al, includeSelf, contextId);
    }

    public boolean matchAncestors(NodeSet al, boolean includeSelf, int contextId) {
        return NodeSetHelper.matchAncestors(this, al, includeSelf, contextId);
    }

    @Override
    public NodeSet selectPrecedingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectPrecedingSiblings(this, siblings, contextId);
    }

    @Override
    public NodeSet selectFollowingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectFollowingSiblings(this, siblings, contextId);
    }

    @Override
    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId, boolean copyMatches) {
        return NodeSetHelper.selectAncestorDescendant(this, al, mode, includeSelf, contextId);
    }

    @Override
    public boolean matchAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId, boolean copyMatches) {
        return NodeSetHelper.matchAncestorDescendant(this, al, mode, includeSelf, contextId);
    }

    @Override
    public NodeSet selectPreceding(NodeSet preceding, int contextId) throws XPathException {
        return NodeSetHelper.selectPreceding(this, preceding);
    }

    @Override
    public NodeSet selectPreceding(NodeSet preceding, int position, int contextId) throws XPathException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeSet selectFollowing(NodeSet following, int contextId) throws XPathException {
        return NodeSetHelper.selectFollowing(this, following);
    }

    @Override
    public NodeSet selectFollowing(NodeSet following, int position, int contextId) throws XPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeSet directSelectAttribute(DBBroker broker, NodeTest test, int contextId) {
        if (this.nodeType != -1 && this.nodeType != 1) {
            return NodeSet.EMPTY_SET;
        }
        try {
            AbstractArrayNodeSet result = null;
            IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(this, true);
            int status = reader.next();
            if (status != 1) {
                return NodeSet.EMPTY_SET;
            }
            int attrs = reader.getAttributeCount();
            for (int i = 0; i < attrs && (status = reader.next()) == 10; ++i) {
                AttrImpl attr = (AttrImpl)reader.getNode();
                if (!test.matches(attr)) continue;
                NodeProxy child = new NodeProxy(attr);
                if (-1 != contextId) {
                    child.addContextNode(contextId, this);
                } else {
                    child.copyContext(this);
                }
                if (!test.isWildcardTest()) {
                    return child;
                }
                if (result == null) {
                    result = new NewArrayNodeSet();
                }
                result.add(child);
            }
            return result == null ? NodeSet.EMPTY_SET : result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public NodeSet directSelectChild(QName qname, int contextId) {
        if (this.nodeType != -1 && this.nodeType != 1) {
            return NodeSet.EMPTY_SET;
        }
        NodeImpl node = (NodeImpl)this.getNode();
        if (node.getNodeType() != 1) {
            return NodeSet.EMPTY_SET;
        }
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return NodeSet.EMPTY_SET;
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (int i = 0; i < children.getLength(); ++i) {
            IStoredNode child = (IStoredNode)children.item(i);
            if (!child.getQName().equals(qname)) continue;
            NodeProxy p = new NodeProxy(this.doc, child.getNodeId(), 1, child.getInternalAddress());
            if (-1 != contextId) {
                p.addContextNode(contextId, this);
            } else {
                p.copyContext(this);
            }
            p.addMatches(this);
            result.add(p);
        }
        return result;
    }

    public String toString() {
        if (this.nodeId == NodeId.DOCUMENT_NODE) {
            return "Document node for " + this.doc.getDocId();
        }
        return this.doc.getNode(this.nodeId).getNodeName();
    }

    @Override
    public Iterator<DocumentImpl> getDocumentIterator() {
        return new Iterator<DocumentImpl>(){
            private boolean hasMore = true;

            @Override
            public final boolean hasNext() {
                return this.hasMore;
            }

            @Override
            public final DocumentImpl next() {
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                this.hasMore = false;
                return NodeProxy.this.doc;
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException("remove is not implemented for NodeProxy#getDocumentIterator");
            }
        };
    }

    @Override
    public int getDocumentCount() {
        return 1;
    }

    public DocumentImpl getDoc() {
        return this.doc;
    }

    @Override
    public DocumentImpl getDoc(int docId) {
        if (docId == this.doc.getDocId()) {
            return this.doc;
        }
        return null;
    }

    @Override
    public XmldbURI[] getNames() {
        return new XmldbURI[]{this.doc.getURI()};
    }

    @Override
    public DocumentSet intersection(DocumentSet other) {
        if (other.contains(this.doc.getDocId())) {
            DefaultDocumentSet r = new DefaultDocumentSet();
            r.add(this.doc);
            return r;
        }
        return DefaultDocumentSet.EMPTY_DOCUMENT_SET;
    }

    @Override
    public boolean contains(DocumentSet other) {
        if (other.getDocumentCount() > 1) {
            return false;
        }
        if (other.getDocumentCount() == 0) {
            return true;
        }
        return other.contains(this.doc.getDocId());
    }

    @Override
    public boolean contains(int docId) {
        return this.doc.getDocId() == docId;
    }

    @Override
    public NodeSet docsToNodeSet() {
        return new NodeProxy(this.doc, NodeId.DOCUMENT_NODE);
    }

    @Override
    public void lock(DBBroker broker, boolean exclusive) throws LockException {
        Lock docLock = this.doc.getUpdateLock();
        docLock.acquire(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK);
        this.lockReleasers.push(() -> docLock.release(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK));
    }

    @Override
    public void unlock() {
        while (!this.lockReleasers.isEmpty()) {
            this.lockReleasers.pop().run();
        }
    }

    @Override
    public boolean equalDocs(DocumentSet other) {
        if (this == other) {
            return true;
        }
        if (other.getDocumentCount() != 1) {
            return false;
        }
        return other.contains(this.doc.getDocId());
    }

    @Override
    public boolean directMatchAttribute(DBBroker broker, NodeTest test, int contextId) {
        if (this.nodeType != -1 && this.nodeType != 1) {
            return false;
        }
        try {
            IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(this, true);
            int status = reader.next();
            if (status != 1) {
                return false;
            }
            int attrs = reader.getAttributeCount();
            for (int i = 0; i < attrs && (status = reader.next()) == 10; ++i) {
                AttrImpl attr = (AttrImpl)reader.getNode();
                if (!test.matches(attr)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean directMatchChild(QName qname, int contextId) {
        if (this.nodeType != -1 && this.nodeType != 1) {
            return false;
        }
        NodeImpl node = (NodeImpl)this.getNode();
        if (node.getNodeType() != 1) {
            return false;
        }
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            IStoredNode child = (IStoredNode)children.item(i);
            if (!child.getQName().equals(qname)) continue;
            return true;
        }
        return false;
    }

    private static final class SingleNodeIterator
    implements NodeSetIterator,
    SequenceIterator {
        private boolean hasNext = true;
        private NodeProxy node;

        public SingleNodeIterator(NodeProxy node) {
            this.node = node;
        }

        @Override
        public final boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public final NodeProxy next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.node;
        }

        @Override
        public final NodeProxy peekNode() {
            return this.node;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove is not implemented for SingleNodeIterator");
        }

        @Override
        public final Item nextItem() {
            if (!this.hasNext) {
                return null;
            }
            this.hasNext = false;
            return this.node;
        }

        @Override
        public final void setPosition(NodeProxy proxy) {
            this.node = proxy;
            this.hasNext = true;
        }
    }
}

