/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class NodeSetHelper {
    private NodeSetHelper() {
    }

    public static NodeSet selectParentChild(NodeSet dl, NodeSet al, int mode, int contextId) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentImpl lastDoc = null;
        switch (mode) {
            case 1: {
                for (NodeProxy child : dl) {
                    NodeProxy parent;
                    int sizeHint = -1;
                    if (lastDoc == null || child.getOwnerDocument() != lastDoc) {
                        lastDoc = child.getOwnerDocument();
                        sizeHint = dl.getSizeHint(lastDoc);
                    }
                    if ((parent = al.parentWithChild(child, true, false, -1)) == null) continue;
                    if (-1 != contextId) {
                        child.deepCopyContext(parent, contextId);
                    } else {
                        child.copyContext(parent);
                    }
                    result.add(child, sizeHint);
                }
                break;
            }
            case 0: {
                for (NodeProxy child : dl) {
                    NodeProxy parent;
                    int sizeHint = -1;
                    if (lastDoc == null || child.getOwnerDocument() != lastDoc) {
                        lastDoc = child.getOwnerDocument();
                        sizeHint = al.getSizeHint(lastDoc);
                    }
                    if ((parent = al.parentWithChild(child, true, false, -1)) == null) continue;
                    if (-1 != contextId) {
                        parent.deepCopyContext(child, contextId);
                    } else {
                        parent.copyContext(child);
                    }
                    parent.addMatches(child);
                    result.add(parent, sizeHint);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad 'mode' argument");
            }
        }
        result.sort();
        return result;
    }

    public static boolean matchParentChild(NodeSet dl, NodeSet al, int mode, int contextId) {
        DocumentImpl lastDoc = null;
        switch (mode) {
            case 1: {
                for (NodeProxy child : dl) {
                    NodeProxy parent;
                    if (lastDoc == null || child.getOwnerDocument() != lastDoc) {
                        lastDoc = child.getOwnerDocument();
                    }
                    if ((parent = al.parentWithChild(child, true, false, -1)) == null) continue;
                    return true;
                }
                break;
            }
            case 0: {
                for (NodeProxy child : dl) {
                    NodeProxy parent;
                    if (lastDoc == null || child.getOwnerDocument() != lastDoc) {
                        lastDoc = child.getOwnerDocument();
                    }
                    if ((parent = al.parentWithChild(child, true, false, -1)) == null) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad 'mode' argument");
            }
        }
        return false;
    }

    public static NodeSet selectAncestorDescendant(NodeSet dl, NodeSet al, int mode, boolean includeSelf, int contextId) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentImpl lastDoc = null;
        switch (mode) {
            case 1: {
                for (NodeProxy descendant : dl) {
                    NodeProxy ancestor;
                    int sizeHint = -1;
                    if (lastDoc == null || descendant.getOwnerDocument() != lastDoc) {
                        lastDoc = descendant.getOwnerDocument();
                        sizeHint = dl.getSizeHint(lastDoc);
                    }
                    if ((ancestor = al.parentWithChild(descendant.getOwnerDocument(), descendant.getNodeId(), false, includeSelf)) == null) continue;
                    if (-1 != contextId) {
                        descendant.addContextNode(contextId, ancestor);
                    } else {
                        descendant.copyContext(ancestor);
                    }
                    result.add(descendant, sizeHint);
                }
                break;
            }
            case 0: {
                for (NodeProxy descendant : dl) {
                    NodeProxy ancestor;
                    int sizeHint = -1;
                    if (lastDoc == null || descendant.getOwnerDocument() != lastDoc) {
                        lastDoc = descendant.getOwnerDocument();
                        sizeHint = al.getSizeHint(lastDoc);
                    }
                    if ((ancestor = al.parentWithChild(descendant.getOwnerDocument(), descendant.getNodeId(), false, includeSelf)) == null) continue;
                    if (-1 != contextId) {
                        ancestor.addContextNode(contextId, descendant);
                    } else {
                        ancestor.copyContext(descendant);
                    }
                    result.add(ancestor, sizeHint);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad 'mode' argument");
            }
        }
        return result;
    }

    public static boolean matchAncestorDescendant(NodeSet dl, NodeSet al, int mode, boolean includeSelf, int contextId) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentImpl lastDoc = null;
        switch (mode) {
            case 1: {
                for (NodeProxy descendant : dl) {
                    NodeProxy ancestor;
                    int sizeHint = -1;
                    if (lastDoc == null || descendant.getOwnerDocument() != lastDoc) {
                        lastDoc = descendant.getOwnerDocument();
                        sizeHint = dl.getSizeHint(lastDoc);
                    }
                    if ((ancestor = al.parentWithChild(descendant.getOwnerDocument(), descendant.getNodeId(), false, includeSelf)) == null) continue;
                    if (-1 != contextId) {
                        descendant.addContextNode(contextId, ancestor);
                    } else {
                        descendant.copyContext(ancestor);
                    }
                    result.add(descendant, sizeHint);
                    return true;
                }
                break;
            }
            case 0: {
                for (NodeProxy descendant : dl) {
                    NodeProxy ancestor;
                    int sizeHint = -1;
                    if (lastDoc == null || descendant.getOwnerDocument() != lastDoc) {
                        lastDoc = descendant.getOwnerDocument();
                        sizeHint = al.getSizeHint(lastDoc);
                    }
                    if ((ancestor = al.parentWithChild(descendant.getOwnerDocument(), descendant.getNodeId(), false, includeSelf)) == null) continue;
                    if (-1 != contextId) {
                        ancestor.addContextNode(contextId, descendant);
                    } else {
                        ancestor.copyContext(descendant);
                    }
                    result.add(ancestor, sizeHint);
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad 'mode' argument");
            }
        }
        return false;
    }

    public static NodeSet selectAncestors(NodeSet al, NodeSet dl, boolean includeSelf, int contextId) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (NodeProxy descendant : dl) {
            NodeSet ancestors = NodeSetHelper.ancestorsForChild(al, descendant, false, includeSelf);
            for (NodeProxy ancestor : ancestors) {
                if (ancestor == null) continue;
                NodeProxy temp = result.get(ancestor);
                if (temp == null) {
                    if (-2 != contextId) {
                        if (-1 != contextId) {
                            ancestor.addContextNode(contextId, descendant);
                        } else {
                            ancestor.copyContext(descendant);
                        }
                    }
                    ancestor.addMatches(descendant);
                    result.add(ancestor);
                    continue;
                }
                if (-1 == contextId) continue;
                temp.addContextNode(contextId, descendant);
            }
        }
        return result;
    }

    public static boolean matchAncestors(NodeSet al, NodeSet dl, boolean includeSelf, int contextId) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (NodeProxy descendant : dl) {
            NodeSet ancestors = NodeSetHelper.ancestorsForChild(al, descendant, false, includeSelf);
            for (NodeProxy ancestor : ancestors) {
                if (ancestor == null) continue;
                NodeProxy temp = result.get(ancestor);
                if (temp == null) {
                    if (-2 != contextId) {
                        if (-1 != contextId) {
                            ancestor.addContextNode(contextId, descendant);
                        } else {
                            ancestor.copyContext(descendant);
                        }
                    }
                    ancestor.addMatches(descendant);
                    result.add(ancestor);
                    return true;
                }
                if (-1 == contextId) continue;
                temp.addContextNode(contextId, descendant);
            }
        }
        return false;
    }

    private static NodeSet ancestorsForChild(NodeSet ancestors, NodeProxy child, boolean directParent, boolean includeSelf) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        NodeId nodeId = child.getNodeId();
        NodeProxy temp = ancestors.get(child.getOwnerDocument(), nodeId);
        if (includeSelf && temp != null) {
            result.add(temp);
        }
        while (nodeId != null && nodeId != NodeId.DOCUMENT_NODE) {
            nodeId = nodeId.getParentId();
            temp = ancestors.get(child.getOwnerDocument(), nodeId);
            if (temp != null) {
                result.add(temp);
                continue;
            }
            if (!directParent) continue;
            return result;
        }
        return result;
    }

    public static NodeSet selectPrecedingSiblings(NodeSet candidates, NodeSet references, int contextId) {
        if (references.isEmpty() || candidates.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iReferences = references.iterator();
        NodeSetIterator iCandidates = candidates.iterator();
        NodeProxy reference = (NodeProxy)iReferences.next();
        NodeProxy candidate = (NodeProxy)iCandidates.next();
        NodeProxy firstCandidate = null;
        while (true) {
            if (reference.getOwnerDocument().getDocId() < candidate.getOwnerDocument().getDocId()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (reference.getOwnerDocument().getDocId() > candidate.getOwnerDocument().getDocId()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            int cmp = candidate.getNodeId().getParentId().compareTo(reference.getNodeId().getParentId());
            if (cmp > 0 && candidate.getNodeId().getTreeLevel() <= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (cmp < 0 || cmp > 0 && candidate.getNodeId().getTreeLevel() >= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (firstCandidate == null) {
                firstCandidate = candidate;
            }
            if ((cmp = candidate.getNodeId().compareTo(reference.getNodeId())) < 0) {
                NodeProxy t = result.get(candidate);
                if (t == null) {
                    if (-2 != contextId) {
                        if (-1 == contextId) {
                            candidate.copyContext(reference);
                        } else {
                            candidate.addContextNode(contextId, reference);
                        }
                    }
                    result.add(candidate);
                } else if (contextId > -1) {
                    t.addContextNode(contextId, reference);
                }
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (cmp > 0) {
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (!iReferences.hasNext()) break;
            reference = (NodeProxy)iReferences.next();
            iCandidates.setPosition(firstCandidate);
            candidate = (NodeProxy)iCandidates.next();
        }
        return result;
    }

    public static NodeSet selectFollowingSiblings(NodeSet candidates, NodeSet references, int contextId) {
        if (references.isEmpty() || candidates.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iReferences = references.iterator();
        NodeSetIterator iCandidates = candidates.iterator();
        NodeProxy reference = (NodeProxy)iReferences.next();
        NodeProxy candidate = (NodeProxy)iCandidates.next();
        NodeProxy firstCandidate = null;
        while (true) {
            if (reference.getOwnerDocument().getDocId() < candidate.getOwnerDocument().getDocId()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (reference.getOwnerDocument().getDocId() > candidate.getOwnerDocument().getDocId()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            int cmp = candidate.getNodeId().getParentId().compareTo(reference.getNodeId().getParentId());
            if (cmp > 0 && candidate.getNodeId().getTreeLevel() <= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (cmp < 0 || cmp > 0 && candidate.getNodeId().getTreeLevel() >= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (firstCandidate == null) {
                firstCandidate = candidate;
            }
            if ((cmp = candidate.getNodeId().compareTo(reference.getNodeId())) < 0) {
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (cmp > 0) {
                NodeProxy t = result.get(candidate);
                if (t == null) {
                    if (-2 != contextId) {
                        if (-1 == contextId) {
                            candidate.copyContext(reference);
                        } else {
                            candidate.addContextNode(contextId, reference);
                        }
                    }
                    result.add(candidate);
                } else {
                    t.addContextNode(contextId, reference);
                }
                result.add(candidate);
                if (iCandidates.hasNext()) {
                    candidate = (NodeProxy)iCandidates.next();
                    continue;
                }
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                iCandidates.setPosition(firstCandidate);
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (!iCandidates.hasNext()) break;
            candidate = (NodeProxy)iCandidates.next();
        }
        return result;
    }

    public static NodeSet selectPreceding(NodeSet references, NodeSet candidates) throws XPathException {
        if (candidates.isEmpty() || references.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (NodeProxy reference : references) {
            for (NodeProxy candidate : candidates) {
                if (!candidate.before(reference, true)) continue;
                candidate.addContextNode(-1, reference);
                result.add(candidate);
            }
        }
        return result;
    }

    public static NodeSet selectFollowing(NodeSet references, NodeSet candidates) throws XPathException {
        if (candidates.isEmpty() || references.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        for (NodeProxy reference : references) {
            for (NodeProxy candidate : candidates) {
                if (!candidate.after(reference, true)) continue;
                candidate.addContextNode(-1, reference);
                result.add(candidate);
            }
        }
        return result;
    }

    public static NodeSet directSelectAttributes(DBBroker broker, NodeSet candidates, NodeTest test, int contextId) {
        if (candidates.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        for (NodeProxy candidate : candidates) {
            result.addAll(candidate.directSelectAttribute(broker, test, contextId));
        }
        return result;
    }

    public static boolean directMatchAttributes(DBBroker broker, NodeSet candidates, NodeTest test, int contextId) {
        if (candidates.isEmpty()) {
            return false;
        }
        for (NodeProxy candidate : candidates) {
            if (!candidate.directMatchAttribute(broker, test, contextId)) continue;
            return true;
        }
        return false;
    }

    public static final void copyChildren(Document newDoc, Node node, Node newNode) {
        NodeList children = node.getChildNodes();
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null) continue;
            switch (child.getNodeType()) {
                case 1: {
                    Node newChild = NodeSetHelper.copyNode(newDoc, child);
                    newNode.appendChild(newChild);
                    continue block4;
                }
                case 3: {
                    Node newChild = NodeSetHelper.copyNode(newDoc, child);
                    newNode.appendChild(newChild);
                }
            }
        }
    }

    public static final Node copyNode(Document newDoc, Node node) {
        Node newNode;
        switch (node.getNodeType()) {
            case 1: {
                newNode = newDoc.createElementNS(node.getNamespaceURI(), node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    Attr newAttr = newDoc.createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                    newAttr.setValue(((Attr)node).getValue());
                    ((Element)newNode).setAttributeNode(newAttr);
                }
                NodeSetHelper.copyChildren(newDoc, node, newNode);
                break;
            }
            case 3: {
                newNode = newDoc.createTextNode(((Text)node).getData());
                break;
            }
            default: {
                newNode = null;
            }
        }
        return newNode;
    }
}

