/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.util.Iterator;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;
import org.exist.dom.QName;
import org.exist.util.hashtable.AbstractHashSet;

@NotThreadSafe
public class QNamePool
extends AbstractHashSet<QName> {
    private static final int DEFAULT_POOL_SIZE = 512;
    private QName[] values;

    public QNamePool() {
        super(512);
        this.values = new QName[this.tabSize];
    }

    public QNamePool(int size) {
        super(size);
        this.values = new QName[this.tabSize];
    }

    public final QName get(byte type, String namespaceURI, String localName, String prefix) {
        int idx = QNamePool.hashCode(localName, namespaceURI, prefix, type) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (QNamePool.equals(this.values[idx], localName, namespaceURI, prefix, type)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (!QNamePool.equals(this.values[idx], localName, namespaceURI, prefix, type)) continue;
            return this.values[idx];
        }
        return null;
    }

    public final QName add(byte type, String namespaceURI, String localName, String prefix) {
        QName qn = new QName(localName, namespaceURI, prefix, type);
        try {
            return this.insert(qn);
        }
        catch (AbstractHashSet.HashSetOverflowException e) {
            this.clear();
            try {
                return this.insert(qn);
            }
            catch (AbstractHashSet.HashSetOverflowException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private void clear() {
        this.values = new QName[this.tabSize];
        this.items = 0;
    }

    private QName insert(QName value) throws AbstractHashSet.HashSetOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = QNamePool.hashCode(value.getLocalPart(), value.getNamespaceURI(), value.getPrefix(), value.getNameType()) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.values[idx] = value;
            ++this.items;
            return this.values[idx];
        }
        if (this.values[idx] == REMOVED) {
            bucket = idx;
        } else if (this.values[idx].equals(value)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
                continue;
            }
            if (this.values[idx] == null) {
                if (bucket > -1) {
                    idx = bucket;
                }
                this.values[idx] = value;
                ++this.items;
                return this.values[idx];
            }
            if (!this.values[idx].equals(value)) continue;
            return this.values[idx];
        }
        if (bucket > -1) {
            this.values[bucket] = value;
            ++this.items;
            return this.values[bucket];
        }
        throw new AbstractHashSet.HashSetOverflowException();
    }

    private int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    private static int hashCode(String localPart, String namespaceURI, String prefix, byte nameType) {
        int h = nameType + 31 + localPart.hashCode();
        h += 31 * h + namespaceURI.hashCode();
        h += 31 * h + (prefix == null ? 1 : prefix.hashCode());
        return h;
    }

    private static boolean equals(QName qname, String otherLocalPart, String otherNamespaceURI, String otherPrefix, byte otherNameType) {
        return qname.getNameType() == otherNameType && qname.getNamespaceURI().equals(otherNamespaceURI) && qname.getLocalPart().equals(otherLocalPart) && Objects.equals(qname.getPrefix(), otherPrefix);
    }

    @Override
    public Iterator<QName> iterator() {
        throw new UnsupportedOperationException();
    }
}

