/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.exist.EXistException;
import org.exist.dom.persistent.AbstractNodeSet;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.OrderedLinkedList;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SortedNodeSet
extends AbstractNodeSet {
    private final OrderedLinkedList list = new OrderedLinkedList();
    private final String sortExpr;
    private final BrokerPool pool;
    private final Subject user;

    public SortedNodeSet(BrokerPool pool, Subject user, String sortExpr) {
        this.sortExpr = sortExpr;
        this.pool = pool;
        this.user = user;
    }

    @Override
    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    @Override
    public boolean hasOne() {
        return this.list.size() == 1;
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        this.addAll(other.toNodeSet());
    }

    @Override
    public void addAll(NodeSet other) {
        long start = System.currentTimeMillis();
        DefaultDocumentSet docs = new DefaultDocumentSet();
        for (NodeProxy p : other) {
            docs.add(p.getOwnerDocument());
        }
        try (DBBroker broker = this.pool.get(Optional.ofNullable(this.user));){
            XQueryContext context = new XQueryContext(this.pool);
            XQueryLexer lexer = new XQueryLexer(context, new StringReader(this.sortExpr));
            XQueryParser parser = new XQueryParser(lexer);
            XQueryTreeParser treeParser = new XQueryTreeParser(context);
            parser.xpath();
            if (parser.foundErrors()) {
                LOG.debug(parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            LOG.debug("generated AST: " + ast.toStringTree());
            PathExpr expr = new PathExpr(context);
            treeParser.xpath(ast, expr);
            if (treeParser.foundErrors()) {
                LOG.debug(treeParser.getErrorMessage());
            }
            expr.analyze(new AnalyzeContextInfo());
            SequenceIterator i = other.iterate();
            while (i.hasNext()) {
                NodeProxy p = (NodeProxy)i.nextItem();
                IteratorItem item = new IteratorItem(p, expr);
                this.list.add(item);
            }
        }
        catch (RecognitionException re) {
            LOG.debug((Object)re);
        }
        catch (TokenStreamException tse) {
            LOG.debug((Object)tse);
        }
        catch (EXistException e) {
            LOG.debug("Exception during sort", (Throwable)e);
        }
        catch (XPathException e) {
            LOG.debug("Exception during sort", (Throwable)e);
        }
        LOG.debug("sort-expression found " + this.list.size() + " in " + (System.currentTimeMillis() - start) + "ms.");
    }

    public void addAll(NodeList other) {
        if (!(other instanceof NodeSet)) {
            throw new RuntimeException("not implemented!");
        }
        this.addAll((NodeSet)other);
    }

    @Override
    public boolean contains(NodeProxy proxy) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            NodeProxy p = ((IteratorItem)i.next()).proxy;
            if (p.compareTo(proxy) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public NodeProxy get(int pos) {
        IteratorItem item = (IteratorItem)this.list.get(pos);
        return item == null ? null : item.proxy;
    }

    @Override
    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        NodeProxy proxy = new NodeProxy(doc, nodeId);
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            NodeProxy p = ((IteratorItem)i.next()).proxy;
            if (p.compareTo(proxy) != 0) continue;
            return p;
        }
        return null;
    }

    @Override
    public NodeProxy get(NodeProxy proxy) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            NodeProxy p = ((IteratorItem)i.next()).proxy;
            if (p.compareTo(proxy) != 0) continue;
            return p;
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.list.size();
    }

    @Override
    public int getItemCount() {
        return this.list.size();
    }

    @Override
    public Node item(int pos) {
        NodeProxy p = ((IteratorItem)this.list.get(pos)).proxy;
        return p == null ? null : p.getOwnerDocument().getNode(p);
    }

    @Override
    public Item itemAt(int pos) {
        NodeProxy p = ((IteratorItem)this.list.get(pos)).proxy;
        return p == null ? null : p;
    }

    @Override
    public NodeSetIterator iterator() {
        return new SortedNodeSetIterator(this.list.iterator());
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return new SortedNodeSetIterator(this.list.iterator());
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        return new SortedNodeSetIterator(this.list.iterator());
    }

    @Override
    public void add(NodeProxy proxy) {
        LOG.info("Called SortedNodeSet.add()");
    }

    private static final class IteratorItem
    extends OrderedLinkedList.Node {
        private final NodeProxy proxy;
        private String value = null;

        public IteratorItem(NodeProxy proxy, PathExpr expr) {
            this.proxy = proxy;
            try {
                Sequence seq = expr.eval(proxy);
                StringBuilder buf = new StringBuilder();
                OrderedLinkedList strings = new OrderedLinkedList();
                SequenceIterator i = seq.iterate();
                while (i.hasNext()) {
                    Item item = i.nextItem();
                    strings.add(new OrderedLinkedList.SimpleNode((Comparable)((Object)item.getStringValue().toUpperCase())));
                }
                Iterator j = strings.iterator();
                while (j.hasNext()) {
                    buf.append(((OrderedLinkedList.SimpleNode)j.next()).getData());
                }
                this.value = buf.toString();
            }
            catch (XPathException e) {
                AbstractNodeSet.LOG.warn(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public int compareTo(OrderedLinkedList.Node other) {
            IteratorItem o = (IteratorItem)other;
            if (this.value == null) {
                return o.value == null ? 0 : 1;
            }
            if (o.value == null) {
                return -1;
            }
            return this.value.compareTo(o.value);
        }

        @Override
        public boolean equals(OrderedLinkedList.Node other) {
            IteratorItem o = (IteratorItem)other;
            return this.value.equals(o.value);
        }
    }

    private static final class SortedNodeSetIterator
    implements NodeSetIterator,
    SequenceIterator {
        private final Iterator<IteratorItem> ii;

        public SortedNodeSetIterator(Iterator<IteratorItem> i) {
            this.ii = i;
        }

        @Override
        public final boolean hasNext() {
            return this.ii.hasNext();
        }

        @Override
        public final NodeProxy next() {
            if (!this.ii.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.ii.next().proxy;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final NodeProxy peekNode() {
            return null;
        }

        @Override
        public final Item nextItem() {
            if (!this.ii.hasNext()) {
                return null;
            }
            return this.ii.next().proxy;
        }

        @Override
        public final void setPosition(NodeProxy proxy) {
            throw new UnsupportedOperationException("NodeSetIterator.setPosition() is not supported by SortedNodeSetIterator");
        }
    }
}

