/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.CDATASectionImpl;
import org.exist.dom.persistent.CommentImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.NodeVisitor;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.TextImpl;
import org.exist.dom.persistent.Visitable;
import org.exist.numbering.NodeId;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.Signatures;
import org.exist.storage.dom.INodeIterator;
import org.exist.util.pool.NodePool;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class StoredNode<T extends StoredNode>
extends NodeImpl<T>
implements Visitable,
NodeHandle,
IStoredNode<T> {
    public static final int LENGTH_SIGNATURE_LENGTH = 1;
    public static final long UNKNOWN_NODE_IMPL_ADDRESS = -1L;
    protected NodeId nodeId = null;
    protected DocumentImpl ownerDocument = null;
    private long internalAddress = -1L;
    protected final short nodeType;

    protected StoredNode(short nodeType) {
        this.nodeType = nodeType;
    }

    protected StoredNode(short nodeType, NodeId nodeId) {
        this.nodeType = nodeType;
        this.nodeId = nodeId;
    }

    protected StoredNode(short nodeType, NodeId nodeId, DocumentImpl ownerDocument, long internalAddress) {
        this(nodeType, nodeId);
        this.ownerDocument = ownerDocument;
        this.internalAddress = internalAddress;
    }

    protected StoredNode(StoredNode other) {
        this.nodeType = other.nodeType;
        this.nodeId = other.nodeId;
        this.internalAddress = other.internalAddress;
        this.ownerDocument = other.ownerDocument;
    }

    public StoredNode extract() {
        return new StoredNode(this){};
    }

    public void clear() {
        this.nodeId = null;
        this.internalAddress = -1L;
    }

    @Override
    public byte[] serialize() {
        throw new DOMException(15, "Can't serialize " + this.getClass().getName());
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc) {
        return StoredNode.deserialize(data, start, len, doc, false);
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        short type = Signatures.getType(data[start]);
        switch (type) {
            case 3: {
                return TextImpl.deserialize(data, start, len, doc, pooled);
            }
            case 1: {
                return ElementImpl.deserialize(data, start, len, doc, pooled);
            }
            case 2: {
                return AttrImpl.deserialize(data, start, len, doc, pooled);
            }
            case 7: {
                return ProcessingInstructionImpl.deserialize(data, start, len, doc, pooled);
            }
            case 8: {
                return CommentImpl.deserialize(data, start, len, doc, pooled);
            }
            case 4: {
                return CDATASectionImpl.deserialize(data, start, len, doc, pooled);
            }
        }
        LOG.error("Unknown node type: " + type);
        Thread.dumpStack();
        return null;
    }

    @Override
    public QName getQName() {
        switch (this.getNodeType()) {
            case 9: {
                return QName.DOCUMENT_QNAME;
            }
            case 3: {
                return QName.TEXT_QNAME;
            }
            case 8: {
                return QName.COMMENT_QNAME;
            }
            case 10: {
                return QName.DOCTYPE_QNAME;
            }
        }
        LOG.error("Unknown node type: " + this.getNodeType());
        return null;
    }

    @Override
    public void setQName(QName qname) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoredNode)) {
            return false;
        }
        return ((StoredNode)obj).nodeId.equals(this.nodeId);
    }

    @Override
    public void setNodeId(NodeId dln) {
        this.nodeId = dln;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public long getInternalAddress() {
        return this.internalAddress;
    }

    @Override
    public void setInternalAddress(long internalAddress) {
        this.internalAddress = internalAddress;
    }

    public boolean isDirty() {
        return true;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    @Override
    public DocumentImpl getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public void setOwnerDocument(DocumentImpl ownerDocument) {
        this.ownerDocument = ownerDocument;
    }

    @Override
    public Node getParentNode() {
        NodeId parentId = this.nodeId.getParentId();
        if (parentId == NodeId.DOCUMENT_NODE) {
            return this.ownerDocument;
        }
        if (parentId.getTreeLevel() == 1 && this.getOwnerDocument().getCollection().isTempCollection()) {
            return this.ownerDocument;
        }
        return this.ownerDocument.getNode(parentId);
    }

    @Override
    public StoredNode getParentStoredNode() {
        Node parent = this.getParentNode();
        return parent instanceof StoredNode ? (StoredNode)parent : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node getPreviousSibling() {
        StoredNode parent;
        if (this.nodeId.equals(NodeId.ROOT_NODE)) {
            return null;
        }
        if (this.nodeId.getTreeLevel() == 1) {
            NodeId siblingId = this.nodeId.precedingSibling();
            try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
                IStoredNode iStoredNode = broker.objectWith(this.ownerDocument, siblingId);
                return iStoredNode;
            }
            catch (EXistException e) {
                LOG.error("Internal error while reading previous sibling node: " + e.getMessage(), (Throwable)e);
            }
        }
        if ((parent = this.getParentStoredNode()) != null && parent.isDirty()) {
            try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
                IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(parent, true);
                int level = this.nodeId.getTreeLevel();
                IStoredNode last = null;
                while (reader.hasNext()) {
                    int status = reader.next();
                    NodeId currentId = (NodeId)reader.getProperty("node-id");
                    if (status == 2 || currentId.getTreeLevel() != level) continue;
                    if (currentId.equals(this.nodeId)) {
                        IStoredNode iStoredNode = last;
                        return iStoredNode;
                    }
                    last = reader.getNode();
                }
                return null;
            }
            catch (IOException | XMLStreamException | EXistException e) {
                LOG.error("Internal error while reading child nodes: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
        NodeId firstChild = parent.getNodeId().newChild();
        if (this.nodeId.equals(firstChild)) {
            return null;
        }
        NodeId siblingId = this.nodeId.precedingSibling();
        return this.ownerDocument.getNode(siblingId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node getNextSibling() {
        StoredNode parent;
        if (this.nodeId.getTreeLevel() == 2 && this.getOwnerDocument().getCollection().isTempCollection()) {
            return null;
        }
        if (this.nodeId.getTreeLevel() == 1) {
            NodeId siblingId = this.nodeId.nextSibling();
            try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
                IStoredNode iStoredNode = broker.objectWith(this.ownerDocument, siblingId);
                return iStoredNode;
            }
            catch (EXistException e) {
                LOG.error("Internal error while reading next sibling node: " + e.getMessage(), (Throwable)e);
            }
        }
        if ((parent = this.getParentStoredNode()) != null && parent.isDirty()) {
            try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
                NodeId currentId;
                int status;
                IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(parent, true);
                int level = this.nodeId.getTreeLevel();
                do {
                    if (!reader.hasNext()) return null;
                    status = reader.next();
                    currentId = (NodeId)reader.getProperty("node-id");
                } while (status == 2 || currentId.getTreeLevel() != level || currentId.compareTo(this.nodeId) <= 0);
                IStoredNode iStoredNode = reader.getNode();
                return iStoredNode;
            }
            catch (IOException | XMLStreamException | EXistException e) {
                LOG.error("Internal error while reading child nodes: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
        NodeId siblingId = this.nodeId.nextSibling();
        return this.ownerDocument.getNode(siblingId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStoredNode getLastNode(IStoredNode node) {
        if (!node.hasChildNodes() && !node.hasAttributes()) {
            return node;
        }
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(node, true);
            while (reader.hasNext()) {
                reader.next();
            }
            IStoredNode iStoredNode = reader.getPreviousNode();
            return iStoredNode;
        }
        catch (IOException | XMLStreamException | EXistException e) {
            LOG.error("Internal error while reading child nodes: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public NodePath getPath() {
        NodePath path = new NodePath();
        if (this.getNodeType() == 1) {
            path.addComponent(this.getQName());
        }
        for (NodeImpl parent = this.getNodeType() == 2 ? (NodeImpl)((Object)((Attr)((Object)this)).getOwnerElement()) : (NodeImpl)this.getParentNode(); parent != null && parent.getNodeType() != 9; parent = (NodeImpl)parent.getParentNode()) {
            path.addComponentAtStart(parent.getQName());
        }
        return path;
    }

    @Override
    public NodePath getPath(NodePath parentPath) {
        if (this.getNodeType() == 1) {
            parentPath.addComponent(this.getQName());
        }
        return parentPath;
    }

    public String toString() {
        return this.nodeId.toString() + '\t' + this.getQName();
    }

    public String toString(boolean top) {
        return this.toString();
    }

    @Override
    public void release() {
        this.ownerDocument = null;
        this.clear();
        NodePool.getInstance().returnNode(this);
    }

    /*
     * Exception decompiling
     */
    public boolean accept(NodeVisitor visitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean accept(INodeIterator iterator, NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public int compareTo(StoredNode other) {
        if (other.ownerDocument == this.ownerDocument) {
            return this.nodeId.compareTo(other.nodeId);
        }
        if (this.ownerDocument.getDocId() < other.ownerDocument.getDocId()) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean isSameNode(Node other) {
        if (other instanceof IStoredNode) {
            return this.nodeId.equals(((IStoredNode)other).getNodeId()) && this.ownerDocument.getDocId() == ((DocumentImpl)((IStoredNode)other).getOwnerDocument()).getDocId();
        }
        return false;
    }
}

