/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.serializer.DOMSerializer;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;

public final class XMLUtil {
    private static final Logger LOG = LogManager.getLogger((String)XMLUtil.class.getName());

    private XMLUtil() {
    }

    public static final String dump(DocumentFragment fragment) {
        StringWriter writer = new StringWriter();
        DOMSerializer serializer = new DOMSerializer(writer, null);
        try {
            serializer.serialize(fragment);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final String encodeAttrMarkup(String str) {
        StringBuilder buf = new StringBuilder();
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    boolean isEntity = false;
                    for (int j = i + 1; j < str.length(); ++j) {
                        if (str.charAt(j) == ';') {
                            isEntity = true;
                            break;
                        }
                        if (!Character.isLetter(str.charAt(j))) break;
                    }
                    if (isEntity) {
                        buf.append('&');
                        continue block6;
                    }
                    buf.append("&amp;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static final String decodeAttrMarkup(String str) {
        StringBuilder out = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int p;
            char ch = str.charAt(i);
            if (ch == '&' && (p = str.indexOf(59, i)) != -1) {
                String ent = str.substring(i + 1, p);
                if ("amp".equals(ent)) {
                    out.append('&');
                } else if ("lt".equals(ent)) {
                    out.append('<');
                } else if ("gt".equals(ent)) {
                    out.append('>');
                } else if ("quot".equals(ent)) {
                    out.append('\"');
                }
                i = p;
                continue;
            }
            out.append(ch);
        }
        return out.toString();
    }

    public static final Optional<Charset> getEncoding(String xmlDecl) {
        if (xmlDecl == null) {
            return Optional.empty();
        }
        StringBuilder buf = new StringBuilder();
        int p0 = xmlDecl.indexOf("encoding");
        if (p0 == -1) {
            return Optional.empty();
        }
        for (int i = p0 + 8; i < xmlDecl.length(); ++i) {
            if (Character.isWhitespace(xmlDecl.charAt(i)) || xmlDecl.charAt(i) == '=') continue;
            if (xmlDecl.charAt(i) == '\"') {
                while (xmlDecl.charAt(++i) != '\"' && i < xmlDecl.length()) {
                    buf.append(xmlDecl.charAt(i));
                }
                return Optional.of(Charset.forName(buf.toString()));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static final String getXMLDecl(byte[] data) {
        boolean foundTag = false;
        for (int i = 0; i < data.length && !foundTag; ++i) {
            if (data[i] != 60) continue;
            foundTag = true;
            boolean foundQuestionMark = false;
            int placeInDeclString = 0;
            byte[] declString = new byte[4];
            for (int x = i + 1; x < data.length; ++x) {
                if (data[x] == 0) continue;
                if (!foundQuestionMark && data[x] != 63) break;
                foundQuestionMark = true;
                declString[placeInDeclString] = data[x];
                if (++placeInDeclString >= 4) break;
            }
            if (placeInDeclString != 4 || declString[0] != 63 || declString[1] != 120 || declString[2] != 109 || declString[3] != 108) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream(150);
            out.write(60);
            out.write(declString, 0, 4);
            block2: for (int j = x + 1; j < data.length; ++j) {
                if (data[j] != 0) {
                    out.write(data[j]);
                }
                if (data[j] != 63) continue;
                ++j;
                while (j < data.length) {
                    if (data[j] != 0) {
                        out.write(data[j]);
                        if (data[j] != 62) continue block2;
                        return new String(out.toByteArray());
                    }
                    ++j;
                }
            }
        }
        return null;
    }

    @Deprecated
    public static final String readFile(Path file) throws IOException {
        return XMLUtil.readFile(file, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String readFile(Path file, Charset defaultEncoding) throws IOException {
        return XMLUtil.readFile(Files.readAllBytes(file), defaultEncoding);
    }

    @Deprecated
    public static String readFile(InputSource inSrc) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            try (InputStream is = inSrc.getByteStream();){
                byte[] buf = new byte[2048];
                int read = -1;
                while ((read = is.read(buf)) != -1) {
                    os.write(buf, 0, read);
                }
            }
            String string = XMLUtil.readFile(os.toByteArray(), Charset.forName(inSrc.getEncoding()));
            return string;
        }
    }

    @Deprecated
    public static String readFile(byte[] in, Charset defaultEncoding) throws IOException {
        String xmlDecl = XMLUtil.getXMLDecl(in);
        Charset enc = XMLUtil.getEncoding(xmlDecl).orElse(defaultEncoding);
        return new String(in, enc);
    }

    public static String parseValue(String value, String key) {
        int p = value.indexOf(key);
        if (p == -1) {
            return null;
        }
        return XMLUtil.parseValue(value, p);
    }

    public static String parseValue(String value, int p) {
        while (p < value.length() && value.charAt(++p) != '\"') {
        }
        if (p == value.length()) {
            return null;
        }
        int e = ++p;
        while (e < value.length() && value.charAt(++e) != '\"') {
        }
        if (e == value.length()) {
            return null;
        }
        return value.substring(p, e);
    }
}

