/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.xmldb;

import java.nio.file.Paths;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.EXistXQueryService;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XUpdateQueryService;

public class MultipleDatabases {
    protected static final String driver = "org.exist.xmldb.DatabaseImpl";
    protected static final String URI_DB1 = "xmldb:exist:///db";
    protected static final String URI_DB2 = "xmldb:test:///db";
    protected static final String XUPDATE_1 = "<xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\"><xu:insert-after select=\"//SPEECH/LINE[. &amp;= 'loving']\"><TEST>New line inserted</TEST></xu:insert-after></xu:modifications>";

    public static void main(String[] args) throws Exception {
        Class<?> cl = Class.forName(driver);
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
        Database database2 = (Database)cl.newInstance();
        database2.setProperty("create-database", "true");
        database2.setProperty("configuration", "path/to/testConf.xml");
        database2.setProperty("database-id", "test");
        DatabaseManager.registerDatabase((Database)database2);
        Collection collection1 = DatabaseManager.getCollection((String)URI_DB1, (String)"admin", null);
        MultipleDatabases.loadFile(collection1, "samples/shakespeare/hamlet.xml");
        Collection collection2 = DatabaseManager.getCollection((String)URI_DB2, (String)"admin", null);
        MultipleDatabases.loadFile(collection2, "samples/shakespeare/r_and_j.xml");
        MultipleDatabases.doQuery(collection1, "xmldb:document()//SPEECH[LINE &= 'cursed spite']");
        MultipleDatabases.doQuery(collection2, "xmldb:document()//SPEECH[LINE&= 'love' and SPEAKER = 'JULIET']");
        MultipleDatabases.doXUpdate(collection1, XUPDATE_1);
        MultipleDatabases.doXUpdate(collection2, XUPDATE_1);
        MultipleDatabases.shutdown(collection1);
        MultipleDatabases.shutdown(collection2);
    }

    private static void doQuery(Collection collection, String query) throws XMLDBException {
        EXistXQueryService service = (EXistXQueryService)collection.getService("XQueryService", "1.0");
        ResourceSet result = service.query(query);
        System.out.println("Found " + result.getSize() + " results.");
        ResourceIterator i = result.getIterator();
        while (i.hasMoreResources()) {
            System.out.println(i.nextResource().getContent());
        }
    }

    private static void doXUpdate(Collection collection, String xupdate) throws XMLDBException {
        XUpdateQueryService service = (XUpdateQueryService)collection.getService("XUpdateQueryService", "1.0");
        long mods = service.update(xupdate);
        System.out.println(mods + " modifications processed.");
    }

    private static void loadFile(Collection collection, String path) throws XMLDBException {
        XMLResource document = (XMLResource)collection.createResource(path.substring(path.lastIndexOf(47)), "XMLResource");
        document.setContent((Object)Paths.get(path, new String[0]));
        collection.storeResource((Resource)document);
    }

    private static void shutdown(Collection collection) throws XMLDBException {
        DatabaseInstanceManager manager = (DatabaseInstanceManager)collection.getService("DatabaseInstanceManager", "1.0");
        manager.shutdown();
    }
}

