/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.xmldb;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.exist.util.FileUtils;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;

public class Put {
    public static final String URI = "xmldb:exist://localhost:8080/exist/xmlrpc";

    protected static void usage() {
        System.out.println("usage: org.exist.examples.xmldb.Put collection docName");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            Put.usage();
        }
        String collection = args[0];
        String file = args[1];
        String driver = "org.exist.xmldb.DatabaseImpl";
        Class<?> cl = Class.forName(driver);
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
        Collection col = DatabaseManager.getCollection((String)(URI + collection));
        if (col == null) {
            Collection root = DatabaseManager.getCollection((String)"xmldb:exist://localhost:8080/exist/xmlrpc/db");
            CollectionManagementService mgtService = (CollectionManagementService)root.getService("CollectionManagementService", "1.0");
            col = mgtService.createCollection(collection.substring("/db/".length()));
        }
        Path f = Paths.get(file, new String[0]);
        XMLResource document = (XMLResource)col.createResource(FileUtils.fileName(f), "XMLResource");
        document.setContent((Object)f);
        System.out.print("storing document " + document.getId() + "...");
        col.storeResource((Resource)document);
        System.out.println("ok.");
    }
}

