/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.xmlrpc;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.exist.xmldb.XmldbURI;

public class RetrieveChunked {
    public static void main(String[] args) {
        String xmldbUri = "xmldb:exist://localhost:8080/exist/xmlrpc/db/shakespeare/plays/macbeth.xml";
        XmldbURI uri = XmldbURI.create("xmldb:exist://localhost:8080/exist/xmlrpc/db/shakespeare/plays/macbeth.xml");
        String url = "http://" + uri.getAuthority() + uri.getContext();
        String path = uri.getCollectionPath();
        String filename = "macbeth.xml";
        try {
            XmlRpcClient client = new XmlRpcClient();
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(url));
            config.setBasicUserName("guest");
            config.setBasicPassword("guest");
            client.setConfig((XmlRpcClientConfig)config);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("indent", "no");
            options.put("encoding", "UTF-8");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(path);
            params.add(options);
            try (FileOutputStream fos = new FileOutputStream("macbeth.xml");){
                Map ht = (Map)client.execute("getDocumentData", params);
                int offset = (Integer)ht.get("offset");
                byte[] data = (byte[])ht.get("data");
                String handle = (String)ht.get("handle");
                fos.write(data);
                while (offset != 0) {
                    params.clear();
                    params.add(handle);
                    params.add(offset);
                    ht = (Map)client.execute("getNextChunk", params);
                    data = (byte[])ht.get("data");
                    offset = (Integer)ht.get("offset");
                    fos.write(data);
                }
            }
        }
        catch (IOException | XmlRpcException ex) {
            ex.printStackTrace();
        }
    }
}

