/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing;

import java.nio.file.Path;
import org.exist.indexing.Index;
import org.exist.indexing.IndexWorker;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.DBException;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;

public abstract class AbstractIndex
implements Index {
    protected static String ID = "Give me an ID !";
    protected BrokerPool pool;
    private Path dataDir = null;
    protected String name = null;

    public static String getID() {
        return ID;
    }

    @Override
    public void configure(BrokerPool pool, Path dataDir, Element config) throws DatabaseConfigurationException {
        this.pool = pool;
        this.dataDir = dataDir;
        if (config != null && config.hasAttribute("id")) {
            this.name = config.getAttribute("id");
        }
    }

    @Override
    public String getIndexId() {
        return AbstractIndex.getID();
    }

    @Override
    public String getIndexName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    public Path getDataDir() {
        return this.dataDir;
    }

    @Override
    public abstract void open() throws DatabaseConfigurationException;

    @Override
    public abstract void close() throws DBException;

    @Override
    public abstract void sync() throws DBException;

    @Override
    public abstract void remove() throws DBException;

    @Override
    public abstract IndexWorker getWorker(DBBroker var1);

    @Override
    public abstract boolean checkIndex(DBBroker var1);

    @Override
    public BTree getStorage() {
        return null;
    }
}

