/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exist.collections.Collection;
import org.exist.dom.INodeHandle;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.TextImpl;
import org.exist.indexing.IndexUtils;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.StreamListener;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.MetaStorage;
import org.exist.storage.MetaStreamListener;
import org.exist.storage.NodePath;
import org.exist.storage.txn.Txn;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.NodeList;

public class IndexController {
    private final Map<String, IndexWorker> indexWorkers = new HashMap<String, IndexWorker>();
    private final DBBroker broker;
    private StreamListener listener = null;
    private DocumentImpl currentDoc = null;
    private StreamListener.ReindexMode currentMode = StreamListener.ReindexMode.UNKNOWN;
    private boolean reindexing;

    public IndexController(DBBroker broker) {
        this.broker = broker;
        List<IndexWorker> workers = broker.getBrokerPool().getIndexManager().getWorkers(broker);
        for (IndexWorker worker : workers) {
            this.indexWorkers.put(worker.getIndexId(), worker);
        }
    }

    public Map<String, Object> configure(NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (IndexWorker indexWorker : this.indexWorkers.values()) {
            Object conf = indexWorker.configure(this, configNodes, namespaces);
            if (conf == null) continue;
            map.put(indexWorker.getIndexId(), conf);
        }
        return map;
    }

    public IndexWorker getWorkerByIndexId(String indexId) {
        return this.indexWorkers.get(indexId);
    }

    public IndexWorker getWorkerByIndexName(String indexName) {
        for (IndexWorker worker : this.indexWorkers.values()) {
            if (!indexName.equals(worker.getIndexName())) continue;
            return worker;
        }
        return null;
    }

    @Deprecated
    public void setDocument(DocumentImpl doc) {
        if (this.currentDoc != doc) {
            this.listener = null;
        }
        this.currentDoc = doc;
        for (IndexWorker indexWorker : this.indexWorkers.values()) {
            indexWorker.setDocument(this.currentDoc);
        }
    }

    @Deprecated
    public void setMode(StreamListener.ReindexMode mode) {
        if (this.currentMode != mode) {
            this.listener = null;
        }
        this.currentMode = mode;
        for (IndexWorker indexWorker : this.indexWorkers.values()) {
            indexWorker.setMode(this.currentMode);
        }
    }

    public DocumentImpl getDocument() {
        return this.currentDoc;
    }

    public StreamListener.ReindexMode getMode() {
        return this.currentMode;
    }

    @Deprecated
    public void setDocument(DocumentImpl doc, StreamListener.ReindexMode mode) {
        this.setDocument(doc);
        this.setMode(mode);
    }

    public void flush() {
        this.indexWorkers.values().forEach(IndexWorker::flush);
    }

    public void removeCollection(Collection collection, DBBroker broker, boolean reindex) throws PermissionDeniedException {
        for (IndexWorker indexWorker : this.indexWorkers.values()) {
            indexWorker.removeCollection(collection, broker, reindex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(Txn transaction, IStoredNode<? extends IStoredNode> reindexRoot, StreamListener.ReindexMode mode) {
        if (reindexRoot == null) {
            return;
        }
        this.setReindexing(true);
        try {
            IStoredNode node = this.broker.objectWith(new NodeProxy((DocumentImpl)reindexRoot.getOwnerDocument(), reindexRoot.getNodeId()));
            this.listener = this.getStreamListener((DocumentImpl)node.getOwnerDocument(), mode);
            this.listener.startIndexDocument(transaction);
            try {
                IndexUtils.scanNode(this.broker, transaction, node, this.listener);
            }
            finally {
                this.listener.endIndexDocument(transaction);
            }
            this.flush();
        }
        finally {
            this.setReindexing(false);
        }
    }

    public boolean isReindexing() {
        return this.reindexing;
    }

    private void setReindexing(boolean reindexing) {
        this.reindexing = reindexing;
    }

    public IStoredNode getReindexRoot(IStoredNode node, NodePath path, boolean insert) {
        return this.getReindexRoot(node, path, insert, false);
    }

    public IStoredNode getReindexRoot(IStoredNode node, NodePath path, boolean insert, boolean includeSelf) {
        INodeHandle top = null;
        for (IndexWorker indexWorker : this.indexWorkers.values()) {
            IStoredNode next = indexWorker.getReindexRoot(node, path, insert, includeSelf);
            if (next == null || top != null && !top.getNodeId().isDescendantOf(next.getNodeId())) continue;
            top = next;
        }
        if (top != null && top.getNodeId().equals(node.getNodeId())) {
            top = node;
        }
        return top;
    }

    public StreamListener getStreamListener(DocumentImpl doc, StreamListener.ReindexMode mode) {
        this.setDocument(doc);
        this.setMode(mode);
        return this.getStreamListener();
    }

    public StreamListener getStreamListener() {
        if (this.listener != null) {
            for (StreamListener next = this.listener; next != null; next = next.getNextInChain()) {
            }
            return this.listener;
        }
        StreamListener first = null;
        StreamListener previous = null;
        for (IndexWorker worker : this.indexWorkers.values()) {
            StreamListener current = worker.getListener();
            if (first == null) {
                first = current;
            } else if (current != null) {
                previous.setNextInChain(current);
            }
            if (current == null) continue;
            previous = current;
        }
        this.listener = first;
        return this.listener;
    }

    public void indexNode(Txn transaction, IStoredNode node, NodePath path, StreamListener listener) {
        if (listener != null) {
            switch (node.getNodeType()) {
                case 1: {
                    listener.startElement(transaction, (ElementImpl)node, path);
                    break;
                }
                case 3: 
                case 4: {
                    listener.characters(transaction, (AbstractCharacterData)node, path);
                    break;
                }
                case 2: {
                    listener.attribute(transaction, (AttrImpl)node, path);
                }
            }
        }
    }

    public void startIndexDocument(Txn transaction, StreamListener listener) {
        if (listener != null) {
            listener.startIndexDocument(transaction);
        }
    }

    public void startElement(Txn transaction, ElementImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.startElement(transaction, node, path);
        }
    }

    public void endElement(Txn transaction, ElementImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.endElement(transaction, node, path);
        }
    }

    public void attribute(Txn transaction, AttrImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.attribute(transaction, node, path);
        }
    }

    public void characters(Txn transaction, TextImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.characters(transaction, node, path);
        }
    }

    public void endIndexDocument(Txn transaction, StreamListener listener) {
        if (listener != null) {
            listener.endIndexDocument(transaction);
        }
    }

    public MatchListener getMatchListener(NodeProxy proxy) {
        MatchListener first = null;
        MatchListener previous = null;
        for (IndexWorker worker : this.indexWorkers.values()) {
            MatchListener current = worker.getMatchListener(this.broker, proxy);
            if (current == null) continue;
            if (first == null) {
                first = current;
            } else {
                previous.setNextInChain(current);
            }
            previous = current;
        }
        return first;
    }

    public List<QueryRewriter> getQueryRewriters(XQueryContext context) {
        ArrayList<QueryRewriter> rewriters = new ArrayList<QueryRewriter>(5);
        for (IndexWorker indexWorker : this.indexWorkers.values()) {
            QueryRewriter rewriter = indexWorker.getQueryRewriter(context);
            if (rewriter == null) continue;
            rewriters.add(rewriter);
        }
        return rewriters;
    }

    public void streamMetas(MetaStreamListener listener) {
        MetaStorage ms = this.broker.getDatabase().getMetaStorage();
        if (ms != null) {
            ms.streamMetas(this.currentDoc, listener);
        }
    }
}

