/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.RawDataBackup;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.Index;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;

public class IndexManager
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(IndexManager.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "modules";
    public static final String CONFIGURATION_MODULE_ELEMENT_NAME = "module";
    public static final String INDEXER_MODULES_CLASS_ATTRIBUTE = "class";
    public static final String INDEXER_MODULES_ID_ATTRIBUTE = "id";
    public static final String PROPERTY_INDEXER_MODULES = "indexer.modules";
    private final BrokerPool pool;
    private Map<String, Index> indexers = new HashMap<String, Index>();
    private Configuration.IndexModuleConfig[] modConfigs;
    private Path dataDir;

    public IndexManager(BrokerPool pool) {
        this.pool = pool;
    }

    @Override
    public void configure(Configuration configuration) throws BrokerPoolServiceException {
        this.modConfigs = (Configuration.IndexModuleConfig[])configuration.getProperty(PROPERTY_INDEXER_MODULES);
        this.dataDir = (Path)configuration.getProperty("db-connection.data-dir");
    }

    @Override
    public void prepare(BrokerPool brokerPool) throws BrokerPoolServiceException {
        try {
            AbstractIndex structural;
            if (this.modConfigs != null) {
                for (Configuration.IndexModuleConfig modConfig : this.modConfigs) {
                    String className = modConfig.getClassName();
                    this.initIndex(this.pool, modConfig.getId(), modConfig.getConfig(), this.dataDir, className);
                }
            }
            if ((structural = (AbstractIndex)this.indexers.get("structural-index")) == null && (structural = this.initIndex(this.pool, "structural-index", null, this.dataDir, "org.exist.storage.structural.NativeStructuralIndex")) != null) {
                structural.setName("structural-index");
            }
        }
        catch (DatabaseConfigurationException e) {
            throw new BrokerPoolServiceException(e);
        }
    }

    private AbstractIndex initIndex(BrokerPool pool, String id, Element config, Path dataDir, String className) throws DatabaseConfigurationException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!AbstractIndex.class.isAssignableFrom(clazz)) {
                throw new DatabaseConfigurationException("Class " + className + " does not implement " + AbstractIndex.class.getName());
            }
            AbstractIndex index = (AbstractIndex)clazz.newInstance();
            index.configure(pool, dataDir, config);
            index.open();
            this.indexers.put(id, index);
            if (LOG.isInfoEnabled()) {
                LOG.info("Registered index " + className + " as " + id);
            }
            return index;
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Class " + className + " not found. Cannot configure index.");
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Exception while configuring index " + className + ": " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Index registerIndex(Index index) throws DatabaseConfigurationException {
        index.open();
        this.indexers.put(index.getIndexId(), index);
        if (LOG.isInfoEnabled()) {
            LOG.info("Registered index " + index.getClass() + " as " + index.getIndexId());
        }
        return index;
    }

    public void unregisterIndex(Index index) throws DBException {
        this.indexers.remove(index.getIndexId(), index);
        if (LOG.isInfoEnabled()) {
            LOG.info("Unregistered index " + index.getClass() + " as " + index.getIndexId());
        }
    }

    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    protected Iterator<Index> iterator() {
        return this.indexers.values().iterator();
    }

    public synchronized Index getIndexById(String indexId) {
        return this.indexers.values().stream().filter(indexer -> indexer.getIndexId().equals(indexId)).findFirst().orElse(null);
    }

    public synchronized Index getIndexByName(String indexName) {
        return this.indexers.get(indexName);
    }

    synchronized List<IndexWorker> getWorkers(DBBroker broker) {
        return this.indexers.values().stream().map(index -> index.getWorker(broker)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void stop(DBBroker systemBroker) throws BrokerPoolServiceException {
        Iterator<Index> i = this.iterator();
        while (i.hasNext()) {
            Index index = i.next();
            try {
                index.close();
            }
            catch (DBException e) {
                throw new BrokerPoolServiceException(e);
            }
        }
    }

    public void sync() throws DBException {
        Iterator<Index> i = this.iterator();
        while (i.hasNext()) {
            Index index = i.next();
            index.sync();
        }
    }

    public void removeIndexes() throws DBException {
        Iterator<Index> i = this.iterator();
        while (i.hasNext()) {
            Index index = i.next();
            index.remove();
        }
    }

    public void reopenIndexes() throws DatabaseConfigurationException {
        Iterator<Index> i = this.iterator();
        while (i.hasNext()) {
            Index index = i.next();
            index.open();
        }
    }

    public void backupToArchive(RawDataBackup backup) throws IOException {
        Iterator<Index> i = this.iterator();
        while (i.hasNext()) {
            Index index = i.next();
            if (!(index instanceof RawBackupSupport)) continue;
            ((RawBackupSupport)((Object)index)).backupToArchive(backup);
        }
    }
}

