/*
 * Decompiled with CFR 0.152.
 */
package org.exist.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.exist.launcher.LauncherWrapper;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DatabaseConfigurationException;

public class ConfigurationUtility {
    public static boolean isFirstStart() {
        Path propFile = ConfigurationHelper.lookup("vm.properties");
        return !Files.exists(propFile, new LinkOption[0]);
    }

    public static Map<String, Integer> getJettyPorts() throws DatabaseConfigurationException {
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        Path jettyHttpConfig = ConfigurationHelper.lookup("tools/jetty/etc/jetty-http.xml");
        Path jettyHttpsConfig = ConfigurationHelper.lookup("tools/jetty/etc/jetty-ssl.xml");
        ConfigurationUtility.getJettyPorts(ports, jettyHttpConfig);
        ConfigurationUtility.getJettyPorts(ports, jettyHttpsConfig);
        return ports;
    }

    private static void getJettyPorts(Map<String, Integer> ports, Path jettyConfig) throws DatabaseConfigurationException {
        if (Files.exists(jettyConfig, new LinkOption[0])) {
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(Files.newBufferedReader(jettyConfig));
                while (reader.hasNext()) {
                    String defaultValue;
                    String name;
                    int status = reader.next();
                    if (status != 1 || !"SystemProperty".equals(reader.getLocalName()) || (name = reader.getAttributeValue(null, "name")) == null || !name.equals("jetty.port") && !name.equals("jetty.ssl.port") || (defaultValue = reader.getAttributeValue(null, "default")) == null) continue;
                    try {
                        ports.put(name, Integer.parseInt(defaultValue));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException | XMLStreamException e) {
                throw new DatabaseConfigurationException(e.getMessage(), e);
            }
        }
    }

    public static void saveProperties(Properties properties) throws ConfigurationException, IOException {
        Path propFile = ConfigurationHelper.lookup("vm.properties");
        PropertiesConfiguration vmProperties = LauncherWrapper.getVMProperties();
        System.out.println("system properties: " + vmProperties.toString());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            vmProperties.setProperty(entry.getKey().toString(), entry.getValue());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(propFile, new OpenOption[0]);){
            vmProperties.write((Writer)writer);
        }
    }

    public static void saveWrapperProperties(Properties properties) throws ConfigurationException, IOException {
        Path propFile = ConfigurationHelper.lookup("tools/yajsw/conf/wrapper.conf");
        ConfigurationUtility.saveOrig(propFile);
        PropertiesConfiguration wrapperConf = new PropertiesConfiguration();
        try (BufferedReader reader = Files.newBufferedReader(propFile);){
            wrapperConf.read((Reader)reader);
        }
        wrapperConf.setProperty("wrapper.java.maxmemory", (Object)properties.getProperty("memory.max", wrapperConf.getString("wrapper.java.maxmemory")));
        wrapperConf.setProperty("wrapper.java.initmemory", (Object)properties.getProperty("memory.min", wrapperConf.getString("wrapper.java.initmemory")));
        var4_4 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(propFile, new OpenOption[0]);){
            wrapperConf.write((Writer)writer);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private static Path saveOrig(Path propFile) throws IOException {
        Path bakFile = propFile.resolveSibling(propFile.getFileName() + ".orig");
        if (!Files.exists(bakFile, new LinkOption[0])) {
            Files.copy(propFile, bakFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return bakFile;
    }

    public static void saveConfiguration(String path, String xsl, Properties properties) throws IOException, TransformerException {
        Path config = ConfigurationHelper.lookup(path);
        ConfigurationUtility.applyXSL(properties, config, xsl);
    }

    private static void applyXSL(Properties properties, Path config, String xsl) throws IOException, TransformerException {
        Path orig = ConfigurationUtility.saveOrig(config);
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslSource = new StreamSource(ConfigurationUtility.class.getResourceAsStream(xsl));
        Transformer transformer = factory.newTransformer(xslSource);
        StreamSource xmlSource = new StreamSource(orig.toFile());
        StreamResult output = new StreamResult(config.toFile());
        transformer.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException exception) throws TransformerException {
                System.out.println(exception.getMessageAndLocation());
            }

            @Override
            public void error(TransformerException exception) throws TransformerException {
                System.out.println(exception.getMessageAndLocation());
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                System.out.println(exception.getMessageAndLocation());
            }
        });
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            transformer.setParameter(entry.getKey().toString(), entry.getValue());
        }
        transformer.transform(xmlSource, output);
    }
}

