/*
 * Decompiled with CFR 0.152.
 */
package org.exist.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.exist.launcher.ConfigurationDialog;
import org.exist.launcher.ConfigurationUtility;
import org.exist.launcher.Launcher;
import org.exist.launcher.ServiceManager;
import org.exist.util.ConfigurationHelper;

public class LauncherWrapper {
    private static final String LAUNCHER = Launcher.class.getName();
    private static final String OS = System.getProperty("os.name").toLowerCase();
    protected String command;

    public static final void main(String[] args) {
        LauncherWrapper wrapper = new LauncherWrapper(LAUNCHER);
        if (ConfigurationUtility.isFirstStart()) {
            System.out.println("First launch: opening configuration dialog");
            ConfigurationDialog configDialog = new ConfigurationDialog(restart -> wrapper.launch());
            configDialog.open(true);
            configDialog.requestFocus();
        } else {
            wrapper.launch();
        }
    }

    public LauncherWrapper(String command) {
        this.command = command;
    }

    public void launch() {
        String home = System.getProperty("exist.home", ".");
        String debugLauncher = System.getProperty("exist.debug.launcher", "false");
        PropertiesConfiguration vmProperties = LauncherWrapper.getVMProperties();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getJavaCmd());
        this.getJavaOpts(args, home, vmProperties);
        if (Boolean.parseBoolean(debugLauncher)) {
            args.add("-Xdebug");
            args.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=4000");
        }
        args.add("-jar");
        args.add("start.jar");
        args.add(this.command);
        ServiceManager.run(args, null);
    }

    protected String getJavaCmd() {
        File javaHome = SystemUtils.getJavaHome();
        if (SystemUtils.IS_OS_WINDOWS) {
            Path javaBin = Paths.get(javaHome.getAbsolutePath(), "bin", "javaw.exe");
            if (Files.isExecutable(javaBin)) {
                return '\"' + javaBin.toString() + '\"';
            }
            javaBin = Paths.get(javaHome.getAbsolutePath(), "bin", "java.exe");
            if (Files.isExecutable(javaBin)) {
                return '\"' + javaBin.toString() + '\"';
            }
        } else {
            Path javaBin = Paths.get(javaHome.getAbsolutePath(), "bin", "java");
            if (Files.isExecutable(javaBin)) {
                return javaBin.toString();
            }
        }
        return "java";
    }

    protected void getJavaOpts(List<String> args, String home, PropertiesConfiguration vmProperties) {
        this.getVMOpts(args, vmProperties);
        if (this.command.equals(LAUNCHER) && "mac os x".equals(OS)) {
            args.add("-Dapple.awt.UIElement=true");
        }
        args.add("-Dexist.home=\"" + home + '\"');
    }

    protected void getVMOpts(List<String> args, PropertiesConfiguration vmProperties) {
        Iterator i = vmProperties.getKeys();
        while (i.hasNext()) {
            String os;
            String key = (String)i.next();
            if (key.startsWith("memory.")) {
                if ("memory.max".equals(key)) {
                    args.add("-Xmx" + vmProperties.getString(key) + 'm');
                    continue;
                }
                if (!"memory.min".equals(key)) continue;
                args.add("-Xms" + vmProperties.getString(key) + 'm');
                continue;
            }
            if ("vmoptions".equals(key)) {
                args.add(vmProperties.getString(key));
                continue;
            }
            if (!key.startsWith("vmoptions.") || !OS.contains(os = key.substring("vmoptions.".length()).toLowerCase())) continue;
            String value = vmProperties.getString(key);
            Arrays.stream(value.split("\\s+")).forEach(args::add);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertiesConfiguration getVMProperties() {
        PropertiesConfiguration vmProperties = new PropertiesConfiguration();
        Path propFile = ConfigurationHelper.lookup("vm.properties");
        InputStream is = null;
        try {
            if (Files.isReadable(propFile)) {
                is = Files.newInputStream(propFile, new OpenOption[0]);
            }
            if (is == null) {
                is = LauncherWrapper.class.getResourceAsStream("vm.properties");
            }
            if (is != null) {
                vmProperties.read((Reader)new InputStreamReader(is, "UTF-8"));
            }
        }
        catch (IOException e) {
            System.err.println("vm.properties not found");
        }
        catch (ConfigurationException e) {
            System.err.println("exception reading vm.properties: " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return vmProperties;
    }
}

