/*
 * Decompiled with CFR 0.152.
 */
package org.exist.launcher;

import java.awt.TrayIcon;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.launcher.Launcher;
import org.exist.util.ConfigurationHelper;

public class ServiceManager {
    private static final Logger LOG = LogManager.getLogger(ServiceManager.class);
    private static final Pattern STATUS_REGEX = Pattern.compile("Installed\\s*:\\s*(.*)\n\\s*Running\\s*:\\s*(.*)\n", 8);
    private Launcher launcher;
    private final Properties wrapperProperties;
    private final Path wrapperDir;
    private boolean canUseServices;
    private boolean isInstalled = false;
    private boolean isRunning = false;

    ServiceManager(Launcher launcher) {
        this.launcher = launcher;
        if (SystemUtils.IS_OS_WINDOWS) {
            this.canUseServices = true;
        } else {
            this.isRoot(root -> {
                this.canUseServices = root;
            });
        }
        Optional<Path> eXistHome = ConfigurationHelper.getExistHome();
        this.wrapperDir = eXistHome.isPresent() ? eXistHome.get().resolve("tools/yajsw") : Paths.get("tools/yajsw", new String[0]);
        Path wrapperConfig = this.wrapperDir.resolve("conf/wrapper.conf");
        System.setProperty("wrapper.config", wrapperConfig.toString());
        this.wrapperProperties = new Properties();
        this.wrapperProperties.setProperty("wrapper.working.dir", eXistHome.orElse(Paths.get(".", new String[0])).toString());
        this.wrapperProperties.setProperty("wrapper.config", wrapperConfig.toString());
    }

    boolean isInstalled() {
        return this.isInstalled;
    }

    boolean isRunning() {
        return this.isRunning;
    }

    boolean canUseServices() {
        return this.canUseServices;
    }

    void queryState() {
        if (this.canUseServices) {
            this.runWrapperCmd("query", (code, output) -> {
                Matcher m;
                if (code == 0 && (m = STATUS_REGEX.matcher((CharSequence)output)).find()) {
                    this.isInstalled = Boolean.valueOf(m.group(1));
                    this.isRunning = Boolean.valueOf(m.group(2));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("isInstalled: " + this.isInstalled + "; isRunning: " + this.isRunning);
                    }
                }
                this.launcher.setServiceState();
            });
        } else {
            this.launcher.setServiceState();
        }
    }

    void installAsService() {
        this.launcher.showTrayMessage("Installing service and starting eXistdb ...", TrayIcon.MessageType.INFO);
        if (this.canUseServices) {
            this.runWrapperCmd("install", (code, output) -> {
                if (code == 0) {
                    this.isRunning = false;
                    this.isInstalled = true;
                    this.start();
                    this.launcher.showTrayMessage("Service installed and started", TrayIcon.MessageType.INFO);
                } else {
                    LOG.warn("Failed to install service. Exit code: " + code);
                    JOptionPane.showMessageDialog(null, "Failed to install service. ", "Install Service Failed", 0);
                    this.isInstalled = false;
                    this.isRunning = false;
                }
            });
        }
    }

    boolean uninstall() {
        if (this.isInstalled) {
            this.runWrapperCmd("uninstall", (code, output) -> {
                if (code == 0) {
                    this.isInstalled = false;
                    this.isRunning = false;
                    this.launcher.showTrayMessage("Service stopped and uninstalled", TrayIcon.MessageType.INFO);
                } else {
                    LOG.warn("Failed to uninstall service. Exit code: " + code);
                    JOptionPane.showMessageDialog(null, "Failed to uninstall service. ", "Uninstalling Service Failed", 0);
                    this.isInstalled = true;
                    this.isRunning = true;
                }
                this.launcher.setServiceState();
            });
        }
        return false;
    }

    boolean start() {
        if (!this.isRunning) {
            this.runWrapperCmd("start", (code, output) -> {
                if (code == 0) {
                    this.isRunning = true;
                } else {
                    LOG.warn("Failed to start service. Exit code: " + code);
                    JOptionPane.showMessageDialog(null, "Failed to start service. ", "Starting Service Failed", 0);
                    this.isRunning = false;
                }
                this.launcher.setServiceState();
            });
        }
        return this.isRunning;
    }

    boolean stop() {
        if (this.isRunning) {
            this.runWrapperCmd("stop", (code, output) -> {
                if (code == 0) {
                    this.isRunning = false;
                } else {
                    LOG.warn("Failed to stop service. Exit code: " + code);
                    JOptionPane.showMessageDialog(null, "Failed to stop service.", "Stopping Service Failed", 0);
                    this.isRunning = true;
                }
                this.launcher.setServiceState();
            });
        }
        return !this.isRunning;
    }

    private String getShellCmd(String cmd) {
        if (SystemUtils.IS_OS_UNIX) {
            return cmd + "Daemon.sh";
        }
        return cmd + "Service.bat";
    }

    private void isRoot(Consumer<Boolean> consumer) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("id");
        args.add("-u");
        ServiceManager.run(args, (code, output) -> consumer.accept("0".equals(output.trim())));
    }

    void showServicesConsole() {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("cmd");
        args.add("/c");
        args.add("services.msc");
        ServiceManager.run(args, null);
    }

    private void runWrapperCmd(String cmd, BiConsumer<Integer, String> consumer) {
        Path executable = this.wrapperDir.resolve("bin/" + this.getShellCmd(cmd));
        ArrayList<String> args = new ArrayList<String>(1);
        args.add(executable.toString());
        ServiceManager.run(args, (code, output) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug(output);
            }
            consumer.accept((Integer)code, (String)output);
        });
    }

    static void run(List<String> args, BiConsumer<Integer, String> consumer) {
        block16: {
            ProcessBuilder pb = new ProcessBuilder(args);
            Optional<Path> home = ConfigurationHelper.getExistHome();
            pb.directory(home.orElse(Paths.get(".", new String[0])).toFile());
            pb.redirectErrorStream(true);
            if (consumer == null) {
                pb.inheritIO();
            }
            try {
                Process process = pb.start();
                if (consumer == null) break block16;
                StringBuilder output = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        output.append('\n').append(line);
                    }
                }
                int exitValue = process.waitFor();
                consumer.accept(exitValue, output.toString());
            }
            catch (IOException | InterruptedException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error Running Process", 0);
            }
        }
    }
}

