/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.management.client.JMXtoXML;
import org.exist.util.serializer.DOMSerializer;
import org.w3c.dom.Element;

public class JMXServlet
extends HttpServlet {
    protected static final Logger LOG = LogManager.getLogger(JMXServlet.class);
    private static final String TOKEN_KEY = "token";
    private static final String TOKEN_FILE = "jmxservlet.token";
    private static final String WEBINF_DATA_DIR = "WEB-INF/data";
    private static final Properties defaultProperties = new Properties();
    private JMXtoXML client;
    private final Set<String> localhostAddresses = new HashSet<String>();
    private Path dataDir;
    private Path tokenFile;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isFromLocalHost(request)) {
            LOG.debug("Local access granted");
        } else if (this.hasSecretToken(request, this.getToken())) {
            LOG.debug("Correct token provided by " + request.getRemoteHost());
        } else {
            response.sendError(403, "Access allowed for localhost, or when correct token has been provided.");
            return;
        }
        this.writeXmlData(request, response);
    }

    private void writeXmlData(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Element root;
        block16: {
            root = null;
            String operation = request.getParameter("operation");
            if ("ping".equals(operation)) {
                long responseTime;
                long timeout = 5000L;
                String timeoutParam = request.getParameter("t");
                if (StringUtils.isNotBlank((CharSequence)timeoutParam)) {
                    try {
                        timeout = Long.parseLong(timeoutParam);
                    }
                    catch (NumberFormatException e) {
                        throw new ServletException("timeout parameter needs to be a number. Got: " + timeoutParam);
                    }
                }
                root = (responseTime = this.client.ping("exist", timeout)) == -99L ? this.client.generateXMLReport(String.format("no response on ping after %sms", timeout), new String[]{"sanity", "locking", "processes", "instances", "memory"}) : this.client.generateXMLReport(null, new String[]{"sanity"});
            } else {
                if (operation != null && operation.length() > 0) {
                    String mbean = request.getParameter("mbean");
                    if (mbean == null) {
                        throw new ServletException("to call an operation, you also need to specify parameter 'mbean'");
                    }
                    String[] args = request.getParameterValues("args");
                    try {
                        root = this.client.invoke(mbean, operation, args);
                        if (root == null) {
                            throw new ServletException("operation " + operation + " not found on " + mbean);
                        }
                        break block16;
                    }
                    catch (InstanceNotFoundException e) {
                        throw new ServletException("mbean " + mbean + " not found: " + e.getMessage(), (Throwable)e);
                    }
                    catch (IntrospectionException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                        throw new ServletException(e.getMessage(), (Throwable)e);
                    }
                }
                String[] categories = request.getParameterValues("c");
                if (categories == null) {
                    categories = new String[]{"all"};
                }
                root = this.client.generateXMLReport(null, categories);
            }
        }
        response.setContentType("application/xml");
        Object useAttribute = request.getAttribute("jmx.attribute");
        if (useAttribute != null) {
            request.setAttribute(useAttribute.toString(), (Object)root);
        } else {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
            DOMSerializer streamer = new DOMSerializer(writer, defaultProperties);
            try {
                streamer.serialize(root);
            }
            catch (TransformerException e) {
                LOG.error(e.getMessageAndLocation());
                throw new ServletException("Error while serializing result: " + e.getMessage(), (Throwable)e);
            }
            ((Writer)writer).flush();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.client = new JMXtoXML();
        this.client.connect();
        this.registerLocalHostAddresses();
        String jmxDataDir = this.client.getDataDir();
        this.dataDir = jmxDataDir == null ? Paths.get(config.getServletContext().getRealPath(WEBINF_DATA_DIR), new String[0]).normalize() : Paths.get(jmxDataDir, new String[0]).normalize();
        if (!Files.isDirectory(this.dataDir, new LinkOption[0]) || !Files.isWritable(this.dataDir)) {
            LOG.error("Cannot access directory WEB-INF/data");
        }
        this.obtainTokenFileReference();
        LOG.info(String.format("JMXservlet token: %s", this.getToken()));
    }

    void registerLocalHostAddresses() {
        try {
            this.localhostAddresses.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException ex) {
            LOG.warn(String.format("Unable to get HostAddress for localhost: %s", ex.getMessage()));
        }
        try {
            for (InetAddress address : InetAddress.getAllByName("localhost")) {
                this.localhostAddresses.add(address.getHostAddress());
            }
        }
        catch (UnknownHostException ex) {
            LOG.warn(String.format("Unable to retrieve ipaddresses for localhost: %s", ex.getMessage()));
        }
        if (this.localhostAddresses.isEmpty()) {
            LOG.error("Unable to determine addresses for localhost, jmx servlet might be disfunctional.");
        }
    }

    boolean isFromLocalHost(HttpServletRequest request) {
        return this.localhostAddresses.contains(request.getRemoteAddr());
    }

    boolean hasSecretToken(HttpServletRequest request, String token) {
        Object[] tokenValue = request.getParameterValues(TOKEN_KEY);
        return ArrayUtils.contains((Object[])tokenValue, (Object)token);
    }

    private void obtainTokenFileReference() {
        if (this.tokenFile == null) {
            this.tokenFile = this.dataDir.resolve(TOKEN_FILE);
            LOG.info(String.format("Token file:  %s", this.tokenFile.toAbsolutePath().toAbsolutePath()));
        }
    }

    private String getToken() {
        Throwable throwable;
        Properties props = new Properties();
        String token = null;
        if (Files.exists(this.tokenFile, new LinkOption[0])) {
            try {
                throwable = null;
                try (InputStream is = Files.newInputStream(this.tokenFile, new OpenOption[0]);){
                    props.load(is);
                    token = props.getProperty(TOKEN_KEY);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage());
            }
        }
        if (!Files.exists(this.tokenFile, new LinkOption[0]) || token == null) {
            token = UUID.randomUUID().toString();
            props.setProperty(TOKEN_KEY, token);
            try {
                throwable = null;
                try (OutputStream os = Files.newOutputStream(this.tokenFile, new OpenOption[0]);){
                    props.store(os, "JMXservlet token: http://localhost:8080/exist/status?token=......");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage());
            }
            LOG.debug(String.format("Token written to file %s", this.tokenFile.toAbsolutePath().toString()));
        }
        return token;
    }

    static {
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("omit-xml-declaration", "no");
    }
}

