/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.client;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.util.NamedThreadFactory;
import org.exist.util.serializer.DOMSerializer;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JMXtoXML {
    private static final Logger LOG = LogManager.getLogger(JMXtoXML.class);
    private static final Map<String, ObjectName[]> CATEGORIES = new TreeMap<String, ObjectName[]>();
    private static final Properties defaultProperties;
    public static final String JMX_NAMESPACE = "http://exist-db.org/jmx";
    public static final String JMX_PREFIX = "jmx";
    private static final QName ROW_ELEMENT;
    public static final QName JMX_ELEMENT;
    public static final QName JMX_RESULT;
    private static final QName JMX_RESULT_TYPE_ATTR;
    private static final QName JMX_CONNECTION_ATTR;
    private static final QName JMX_ERROR;
    private static final QName VERSION_ATTR;
    public static final long PING_TIMEOUT = -99L;
    public static final int VERSION = 1;
    private final MBeanServerConnection platformConnection = ManagementFactory.getPlatformMBeanServer();
    private MBeanServerConnection connection;
    private JMXServiceURL url;
    private final ThreadFactory jmxPingFactory = new NamedThreadFactory("jmx-ping");

    public void connect() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.size() > 0) {
            this.connection = servers.get(0);
        }
    }

    public void connect(String address, int port) throws MalformedURLException, IOException {
        this.url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + address + ":" + port + "/jmxrmi");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{"guest", "guest"};
        env.put("jmx.remote.credentials", creds);
        JMXConnector jmxc = JMXConnectorFactory.connect(this.url, env);
        this.connection = jmxc.getMBeanServerConnection();
        LOG.debug("Connected to JMX server at " + this.url.toString());
    }

    public String generateReport(String[] categories) throws TransformerException {
        Element root = this.generateXMLReport(null, categories);
        StringWriter writer = new StringWriter();
        DOMSerializer streamer = new DOMSerializer(writer, defaultProperties);
        streamer.serialize(root);
        return writer.toString();
    }

    public long ping(String instance, long timeout) {
        long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newSingleThreadExecutor(this.jmxPingFactory);
        Future<Long> futurePing = executorService.submit(new Ping(instance, this.connection));
        while (true) {
            try {
                return futurePing.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                LOG.error((Object)e);
                return -99L;
            }
            catch (TimeoutException e) {
                return -99L;
            }
            catch (InterruptedException e) {
                if (System.currentTimeMillis() - start < timeout) continue;
                return -99L;
            }
            break;
        }
    }

    public Element generateXMLReport(String errcode, String[] categories) {
        MemTreeBuilder builder = new MemTreeBuilder();
        try {
            builder.startDocument();
            builder.startElement(JMX_ELEMENT, null);
            builder.addAttribute(VERSION_ATTR, Integer.toString(1));
            if (this.url != null) {
                builder.addAttribute(JMX_CONNECTION_ATTR, this.url.toString());
            }
            if (errcode != null) {
                builder.startElement(JMX_ERROR, null);
                builder.characters(errcode);
                builder.endElement();
            }
            for (String category : categories) {
                ObjectName[] names;
                for (ObjectName name : names = CATEGORIES.get(category)) {
                    this.queryMBeans(builder, name);
                }
            }
            builder.endElement();
            builder.endDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.warn("Could not generate XML report from JMX: " + e.getMessage());
        }
        return (Element)((Object)builder.getDocument().getNode(1));
    }

    public String getDataDir() {
        try {
            Object dir = this.connection.getAttribute(new ObjectName("org.exist.management.exist:type=DiskUsage"), "DataDirectory");
            return dir == null ? null : dir.toString();
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            return null;
        }
    }

    public Element invoke(String objectName, String operation, String[] args) throws InstanceNotFoundException, MalformedObjectNameException, MBeanException, IOException, ReflectionException, IntrospectionException {
        MBeanOperationInfo[] operations;
        MBeanInfo info;
        ObjectName name = new ObjectName(objectName);
        MBeanServerConnection conn = this.connection;
        try {
            info = conn.getMBeanInfo(name);
        }
        catch (InstanceNotFoundException e) {
            conn = this.platformConnection;
            info = conn.getMBeanInfo(name);
        }
        for (MBeanOperationInfo op : operations = info.getOperations()) {
            if (!operation.equals(op.getName())) continue;
            MBeanParameterInfo[] sig = op.getSignature();
            Object[] params = new Object[sig.length];
            String[] types = new String[sig.length];
            for (int i = 0; i < sig.length; ++i) {
                String type;
                types[i] = type = sig[i].getType();
                params[i] = this.mapParameter(type, args[i]);
            }
            Object result = conn.invoke(name, operation, params, types);
            MemTreeBuilder builder = new MemTreeBuilder();
            try {
                builder.startDocument();
                builder.startElement(JMX_ELEMENT, null);
                builder.addAttribute(VERSION_ATTR, Integer.toString(1));
                if (this.url != null) {
                    builder.addAttribute(JMX_CONNECTION_ATTR, this.url.toString());
                }
                builder.startElement(JMX_RESULT, null);
                builder.addAttribute(JMX_RESULT_TYPE_ATTR, op.getReturnType());
                this.serializeObject(builder, result);
                builder.endElement();
                builder.endElement();
                builder.endDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.warn("Could not generate XML report from JMX: " + e.getMessage());
            }
            return (Element)((Object)builder.getDocument().getNode(1));
        }
        return null;
    }

    private void queryMBeans(MemTreeBuilder builder, ObjectName query) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException, SAXException, AttributeNotFoundException, MBeanException, MalformedObjectNameException, NullPointerException {
        MBeanServerConnection conn = this.connection;
        Set<ObjectName> beans = conn.queryNames(query, null);
        if (beans.isEmpty()) {
            beans = this.platformConnection.queryNames(query, null);
            conn = this.platformConnection;
        }
        for (ObjectName name : beans) {
            MBeanInfo info = conn.getMBeanInfo(name);
            String className = info.getClassName();
            int p = className.lastIndexOf(46);
            if (p > -1 && p + 1 < className.length()) {
                className = className.substring(p + 1);
            }
            QName qname = new QName(className, JMX_NAMESPACE, JMX_PREFIX);
            builder.startElement(qname, null);
            builder.addAttribute(new QName("name", ""), name.toString());
            MBeanAttributeInfo[] beanAttribs = info.getAttributes();
            for (int i = 0; i < beanAttribs.length; ++i) {
                if (!beanAttribs[i].isReadable()) continue;
                try {
                    QName attrQName = new QName(beanAttribs[i].getName(), JMX_NAMESPACE, JMX_PREFIX);
                    Object attrib = conn.getAttribute(name, beanAttribs[i].getName());
                    builder.startElement(attrQName, null);
                    this.serializeObject(builder, attrib);
                    builder.endElement();
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("exception caught: " + e.getMessage(), (Throwable)e);
                }
            }
            builder.endElement();
        }
    }

    private void serializeObject(MemTreeBuilder builder, Object object) throws SAXException {
        if (object == null) {
            return;
        }
        if (object instanceof TabularData) {
            this.serialize(builder, (TabularData)object);
        } else if (object instanceof CompositeData[]) {
            this.serialize(builder, (CompositeData[])object);
        } else if (object instanceof CompositeData) {
            this.serialize(builder, (CompositeData)object);
        } else if (object instanceof Object[]) {
            this.serialize(builder, (Object[])object);
        } else {
            builder.characters(object.toString());
        }
    }

    private void serialize(MemTreeBuilder builder, Object[] data) throws SAXException {
        for (Object o : data) {
            this.serializeObject(builder, o);
        }
    }

    private void serialize(MemTreeBuilder builder, CompositeData data) throws SAXException {
        CompositeType type = data.getCompositeType();
        for (String key : type.keySet()) {
            QName qname = new QName(key, JMX_NAMESPACE, JMX_PREFIX);
            builder.startElement(qname, null);
            this.serializeObject(builder, data.get(key));
            builder.endElement();
        }
    }

    private void serialize(MemTreeBuilder builder, TabularData data) throws SAXException {
        CompositeType rowType = data.getTabularType().getRowType();
        for (Object rowObj : data.values()) {
            CompositeData row = (CompositeData)rowObj;
            builder.startElement(ROW_ELEMENT, null);
            for (String key : rowType.keySet()) {
                Object columnData = row.get(key);
                QName columnQName = new QName(key, JMX_NAMESPACE, JMX_PREFIX);
                builder.startElement(columnQName, null);
                this.serializeObject(builder, columnData);
                builder.endElement();
            }
            builder.endElement();
        }
    }

    private void serialize(MemTreeBuilder builder, CompositeData[] array) throws SAXException {
        for (CompositeData data : array) {
            builder.startElement(ROW_ELEMENT, null);
            this.serialize(builder, data);
            builder.endElement();
        }
    }

    private Object mapParameter(String type, String value) {
        if (type.equals("int") || type.equals(Integer.class.getName())) {
            return Integer.parseInt(value);
        }
        if (type.equals("long") || type.equals(Long.class.getName())) {
            return Long.parseLong(value);
        }
        if (type.equals("float") || type.equals(Float.class.getName())) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals("double") || type.equals(Double.class.getName())) {
            return Double.parseDouble(value);
        }
        if (type.equals("boolean") || type.equals(Boolean.class.getName())) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    public static void main(String[] args) {
        JMXtoXML client = new JMXtoXML();
        try {
            client.connect("localhost", 1099);
            System.out.println(client.generateReport(args));
        }
        catch (IOException | TransformerException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            CATEGORIES.put("memory", new ObjectName[]{new ObjectName("java.lang:type=Memory")});
            CATEGORIES.put("runtime", new ObjectName[]{new ObjectName("java.lang:type=Runtime")});
            CATEGORIES.put("operatingsystem", new ObjectName[]{new ObjectName("java.lang:type=OperatingSystem")});
            CATEGORIES.put("thread", new ObjectName[]{new ObjectName("java.lang:type=Threading")});
            CATEGORIES.put("classloading", new ObjectName[]{new ObjectName("java.lang:type=ClassLoading")});
            CATEGORIES.put("instances", new ObjectName[]{new ObjectName("org.exist.management.*:type=Database")});
            CATEGORIES.put("disk", new ObjectName[]{new ObjectName("org.exist.management.*:type=DiskUsage")});
            CATEGORIES.put("system", new ObjectName[]{new ObjectName("org.exist.management:type=SystemInfo")});
            CATEGORIES.put("caches", new ObjectName[]{new ObjectName("org.exist.management.exist:type=CacheManager"), new ObjectName("org.exist.management.exist:type=CollectionCacheManager"), new ObjectName("org.exist.management.exist:type=CacheManager.Cache,*")});
            CATEGORIES.put("locking", new ObjectName[]{new ObjectName("org.exist.management:type=LockManager")});
            CATEGORIES.put("processes", new ObjectName[]{new ObjectName("org.exist.management.*:type=ProcessReport")});
            CATEGORIES.put("sanity", new ObjectName[]{new ObjectName("org.exist.management.*.tasks:type=SanityReport")});
            CATEGORIES.put("jetty.threads", new ObjectName[]{new ObjectName("org.eclipse.jetty.util.thread:type=queuedthreadpool,id=0")});
            CATEGORIES.put("jetty.nio", new ObjectName[]{new ObjectName("org.eclipse.jetty.server.nio:type=selectchannelconnector,id=0")});
            CATEGORIES.put("all", new ObjectName[]{new ObjectName("org.exist.*:*"), new ObjectName("java.lang:*")});
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            LOG.warn("Error in initialization: " + e.getMessage(), (Throwable)e);
        }
        defaultProperties = new Properties();
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("omit-xml-declaration", "no");
        ROW_ELEMENT = new QName("row", JMX_NAMESPACE, JMX_PREFIX);
        JMX_ELEMENT = new QName(JMX_PREFIX, JMX_NAMESPACE, JMX_PREFIX);
        JMX_RESULT = new QName("result", JMX_NAMESPACE, JMX_PREFIX);
        JMX_RESULT_TYPE_ATTR = new QName("class", JMX_NAMESPACE, JMX_PREFIX);
        JMX_CONNECTION_ATTR = new QName("connection", "");
        JMX_ERROR = new QName("error", JMX_NAMESPACE, JMX_PREFIX);
        VERSION_ATTR = new QName("version", "");
    }

    private static class Ping
    implements Callable<Long> {
        private final String instance;
        private final MBeanServerConnection connection;

        public Ping(String instance, MBeanServerConnection connection) {
            this.instance = instance;
            this.connection = connection;
        }

        @Override
        public Long call() {
            try {
                ObjectName name = new ObjectName("org.exist.management." + this.instance + ".tasks:type=SanityReport");
                return (Long)this.connection.invoke(name, "ping", new Object[]{Boolean.TRUE}, new String[]{Boolean.TYPE.getName()});
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                return -2L;
            }
        }
    }
}

