/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;

public class BinaryInputStreamCacheInfo {
    private final long created;
    private final CacheType cacheType;
    private final Optional<Path> file;
    private final long size;

    public BinaryInputStreamCacheInfo(CacheType cacheType, long created, Optional<Path> file, long size) {
        this.created = created;
        this.cacheType = cacheType;
        this.file = file;
        this.size = size;
    }

    public Date getCreated() {
        return new Date(this.created);
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    @Nullable
    public String getFile() {
        return this.file.map(Path::toAbsolutePath).map(Path::toString).orElse(null);
    }

    public long getSize() {
        return this.size;
    }

    static enum CacheType {
        FILE,
        MEMORY_MAPPED_FILE,
        MEMORY;

    }
}

