/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exist.management.impl.ActiveBroker;
import org.exist.management.impl.DatabaseMXBean;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;

public class Database
implements DatabaseMXBean {
    private final BrokerPool pool;

    public Database(BrokerPool pool) {
        this.pool = pool;
    }

    @Override
    public String getInstanceId() {
        return this.pool.getId();
    }

    @Override
    public int getMaxBrokers() {
        return this.pool.getMax();
    }

    @Override
    public int getAvailableBrokers() {
        return this.pool.available();
    }

    @Override
    public int getActiveBrokers() {
        return this.pool.countActiveBrokers();
    }

    @Override
    public int getTotalBrokers() {
        return this.pool.total();
    }

    @Override
    public List<ActiveBroker> getActiveBrokersMap() {
        ArrayList<ActiveBroker> brokersList = new ArrayList<ActiveBroker>();
        for (Map.Entry<Thread, DBBroker> entry : this.pool.getActiveBrokers().entrySet()) {
            Thread thread = entry.getKey();
            DBBroker broker = entry.getValue();
            String trace = this.printStackTrace(thread);
            String watchdogTrace = this.pool.getWatchdog().map(wd -> wd.get(broker)).orElse(null);
            brokersList.add(new ActiveBroker(thread.getName(), broker.getReferenceCount(), trace, watchdogTrace));
        }
        return brokersList;
    }

    @Override
    public long getReservedMem() {
        return this.pool.getReservedMem();
    }

    @Override
    public long getCacheMem() {
        return this.pool.getCacheManager().getTotalMem();
    }

    @Override
    public long getCollectionCacheMem() {
        return this.pool.getCollectionCacheMgr().getMaxTotal();
    }

    @Override
    public long getUptime() {
        return System.currentTimeMillis() - this.pool.getStartupTime().getTimeInMillis();
    }

    @Override
    public String getExistHome() {
        return this.pool.getConfiguration().getExistHome().map(p -> p.toAbsolutePath().toString()).orElse(null);
    }

    public String printStackTrace(Thread thread) {
        StackTraceElement[] stackElements = thread.getStackTrace();
        StringWriter writer = new StringWriter();
        int showItems = stackElements.length > 20 ? 20 : stackElements.length;
        for (int i = 0; i < showItems; ++i) {
            writer.append(stackElements[i].toString()).append('\n');
        }
        return writer.toString();
    }
}

