/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.management.impl.DiskUsageMXBean;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.FileUtils;

public class DiskUsage
implements DiskUsageMXBean {
    private static final Logger LOG = LogManager.getLogger(DiskUsage.class);
    private Optional<Path> journalDir;
    private Optional<Path> dataDir;

    public DiskUsage(BrokerPool pool) {
        Configuration config = pool.getConfiguration();
        this.journalDir = Optional.ofNullable((Path)config.getProperty("db-connection.recovery.journal-dir")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        this.dataDir = Optional.ofNullable((Path)config.getProperty("db-connection.data-dir")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
    }

    @Override
    public String getDataDirectory() {
        return this.dataDir.map(d -> d.toAbsolutePath().toString()).orElse("NOT_CONFIGURED");
    }

    @Override
    public String getJournalDirectory() {
        return this.journalDir.map(d -> d.toAbsolutePath().toString()).orElse("NOT_CONFIGURED");
    }

    private long measureFileStore(Optional<Path> path, FunctionE<FileStore, Long, IOException> measurer) {
        return path.map(p -> FileUtils.measureFileStore(p, measurer)).orElse(-1L);
    }

    @Override
    public long getDataDirectoryTotalSpace() {
        return this.measureFileStore(this.dataDir, (FunctionE<FileStore, Long, IOException>)((FunctionE)FileStore::getTotalSpace));
    }

    @Override
    public long getDataDirectoryUsableSpace() {
        return this.measureFileStore(this.dataDir, (FunctionE<FileStore, Long, IOException>)((FunctionE)FileStore::getUsableSpace));
    }

    @Override
    public long getJournalDirectoryTotalSpace() {
        return this.measureFileStore(this.journalDir, (FunctionE<FileStore, Long, IOException>)((FunctionE)FileStore::getTotalSpace));
    }

    @Override
    public long getJournalDirectoryUsableSpace() {
        return this.measureFileStore(this.journalDir, (FunctionE<FileStore, Long, IOException>)((FunctionE)FileStore::getUsableSpace));
    }

    @Override
    public long getDataDirectoryUsedSpace() {
        return this.dataDir.map(d -> {
            try (Stream<Path> files = Files.list(d);){
                Long l = files.filter(this::isDbxFile).mapToLong(p -> {
                    long size = FileUtils.sizeQuietly(p);
                    return size == -1L ? 0L : size;
                }).sum();
                return l;
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return -1L;
            }
        }).orElse(-1L);
    }

    @Override
    public long getJournalDirectoryUsedSpace() {
        return this.dataDir.map(d -> {
            try (Stream<Path> files = Files.list(d);){
                Long l = files.filter(this::isJournalFile).mapToLong(p -> {
                    long size = FileUtils.sizeQuietly(p);
                    return size == -1L ? 0L : size;
                }).sum();
                return l;
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return -1L;
            }
        }).orElse(-1L);
    }

    @Override
    public long getJournalDirectoryNumberOfFiles() {
        return this.journalDir.map(j -> {
            try (Stream<Path> files = Files.list(j);){
                Long l = files.filter(this::isJournalFile).count();
                return l;
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return -1L;
            }
        }).orElse(-1L);
    }

    private boolean isJournalFile(Path path) {
        return FileUtils.fileName(path).endsWith(".log");
    }

    private boolean isDbxFile(Path path) {
        return FileUtils.fileName(path).endsWith(".dbx");
    }
}

