/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.management.Agent;
import org.exist.management.TaskStatus;
import org.exist.management.impl.BinaryValues;
import org.exist.management.impl.Database;
import org.exist.management.impl.DiskUsage;
import org.exist.management.impl.LockManager;
import org.exist.management.impl.ProcessReport;
import org.exist.management.impl.SanityReport;
import org.exist.management.impl.SystemInfo;
import org.exist.storage.BrokerPool;
import org.exist.util.DatabaseConfigurationException;

public class JMXAgent
implements Agent {
    private static final Logger LOG = LogManager.getLogger(JMXAgent.class);
    private static volatile Agent agent = null;
    private MBeanServer server;
    private Map<String, Stack<ObjectName>> registeredMBeans = new HashMap<String, Stack<ObjectName>>();
    private Map<ObjectName, Object> beanInstances = new HashMap<ObjectName, Object>();

    public static Agent getInstance() {
        if (agent == null) {
            agent = new JMXAgent();
        }
        return agent;
    }

    public JMXAgent() {
        ArrayList<MBeanServer> servers;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating the JMX MBeanServer.");
        }
        this.server = (servers = MBeanServerFactory.findMBeanServer(null)).size() > 0 ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        this.registerSystemMBeans();
    }

    public synchronized void registerSystemMBeans() {
        try {
            ObjectName name = new ObjectName("org.exist.management:type=LockManager");
            this.addMBean(name, new LockManager());
            name = new ObjectName("org.exist.management:type=SystemInfo");
            this.addMBean(name, new SystemInfo());
        }
        catch (MalformedObjectNameException | DatabaseConfigurationException e) {
            LOG.warn("Exception while registering cache mbean.", (Throwable)e);
        }
    }

    @Override
    public void initDBInstance(BrokerPool instance) {
        try {
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ":type=Database", new Database(instance));
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ".tasks:type=SanityReport", new SanityReport(instance));
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ":type=DiskUsage", new DiskUsage(instance));
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ":type=ProcessReport", new ProcessReport(instance));
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ":type=BinaryValues", new BinaryValues());
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn("Exception while registering database mbean.", (Throwable)e);
        }
    }

    @Override
    public synchronized void closeDBInstance(BrokerPool instance) {
        try {
            Stack<ObjectName> stack = this.registeredMBeans.get(instance.getId());
            while (!stack.isEmpty()) {
                ObjectName on = stack.pop();
                LOG.debug("deregistering JMX MBean: " + on);
                if (!this.server.isRegistered(on)) continue;
                this.server.unregisterMBean(on);
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            LOG.warn("Problem found while unregistering JMX", (Throwable)e);
        }
    }

    @Override
    public synchronized void addMBean(String dbInstance, String name, Object mbean) throws DatabaseConfigurationException {
        try {
            ObjectName on = new ObjectName(name);
            this.addMBean(on, mbean);
            if (dbInstance != null) {
                Stack<ObjectName> stack = this.registeredMBeans.get(dbInstance);
                if (stack == null) {
                    stack = new Stack();
                    this.registeredMBeans.put(dbInstance, stack);
                }
                stack.push(on);
            }
            this.beanInstances.put(on, mbean);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Problem registering mbean: " + e.getMessage(), (Throwable)e);
            throw new DatabaseConfigurationException("Exception while registering JMX mbean: " + e.getMessage());
        }
    }

    private void addMBean(ObjectName name, Object mbean) throws DatabaseConfigurationException {
        try {
            if (!this.server.isRegistered(name)) {
                this.server.registerMBean(mbean, name);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            LOG.warn("Problem registering mbean: " + e.getMessage(), (Throwable)e);
            throw new DatabaseConfigurationException("Exception while registering JMX mbean: " + e.getMessage());
        }
    }

    @Override
    public synchronized void changeStatus(BrokerPool instance, TaskStatus actualStatus) {
        try {
            ObjectName name = new ObjectName("org.exist.management." + instance.getId() + ".tasks:type=SanityReport");
            SanityReport report = (SanityReport)this.beanInstances.get(name);
            if (report != null) {
                report.changeStatus(actualStatus);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Problem calling mbean: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized void updateStatus(BrokerPool instance, int percentage) {
        try {
            ObjectName name = new ObjectName("org.exist.management." + instance.getId() + ".tasks:type=SanityReport");
            SanityReport report = (SanityReport)this.beanInstances.get(name);
            if (report != null) {
                report.updateStatus(percentage);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Problem calling mbean: " + e.getMessage(), (Throwable)e);
        }
    }
}

