/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import org.exist.SystemProperties;
import org.exist.management.impl.SystemInfoMXBean;

public class SystemInfo
implements SystemInfoMXBean {
    @Override
    public String getExistVersion() {
        return SystemProperties.getInstance().getSystemProperty("product-version", "unknown");
    }

    @Override
    public String getExistBuild() {
        return SystemProperties.getInstance().getSystemProperty("product-build", "unknown");
    }

    @Override
    public String getSvnRevision() {
        return this.getGitCommit();
    }

    @Override
    public String getGitCommit() {
        return SystemProperties.getInstance().getSystemProperty("git-commit", "unknown Git commit ID");
    }

    @Override
    public String getDefaultLocale() {
        return Locale.getDefault().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getDefaultEncoding() {
        try (InputStreamReader isr = new InputStreamReader(System.in);){
            String string = isr.getEncoding();
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    @Override
    public String getOperatingSystem() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
    }
}

