/*
 * Decompiled with CFR 0.152.
 */
package org.exist.numbering;

import java.io.IOException;
import java.util.Arrays;
import org.exist.storage.io.VariableByteInput;

public class DLNBase {
    public static final int BITS_PER_UNIT = 4;
    public static final int[] BIT_MASK = new int[8];
    protected static final int[] PER_COMPONENT_SIZE;
    protected static final int UNIT_SHIFT = 3;
    protected static final int LEVEL_SEPARATOR = 0;
    protected static final int SUBLEVEL_SEPARATOR = 1;
    protected byte[] bits;
    protected int bitIndex = -1;
    private static final char[] digits;

    private static int[] initComponents() {
        int[] size = new int[10];
        size[0] = 7;
        for (int i = 1; i < size.length; ++i) {
            int components = i + 1;
            int numBits = components * 4 - components;
            size[i] = (int)Math.pow(2.0, numBits) + size[i - 1];
        }
        return size;
    }

    public DLNBase() {
        this.bits = new byte[1];
    }

    public DLNBase(DLNBase dln) {
        this.bits = new byte[dln.bits.length];
        System.arraycopy(dln.bits, 0, this.bits, 0, dln.bits.length);
        this.bitIndex = dln.bitIndex;
    }

    public DLNBase(int units, byte[] data, int startOffset) {
        if (units < 0) {
            throw new IllegalArgumentException("Negative size for DLN: " + units);
        }
        int blen = units / 8;
        if (units % 8 > 0) {
            ++blen;
        }
        this.bits = new byte[blen];
        System.arraycopy(data, startOffset, this.bits, 0, blen);
        this.bitIndex = units - 1;
    }

    protected DLNBase(byte[] data, int nbits) {
        int remainder = nbits % 8;
        int len = nbits / 8;
        this.bits = new byte[len + (remainder > 0 ? 1 : 0)];
        if (len > 0) {
            System.arraycopy(data, 0, this.bits, 0, len);
        }
        if (remainder > 0) {
            byte b = 0;
            for (int i = 0; i < remainder; ++i) {
                if ((data[len] & 1 << (7 - i & 7)) == 0) continue;
                b = (byte)(b | 1 << 7 - i);
            }
            this.bits[len] = b;
        }
        this.bitIndex = nbits - 1;
    }

    public DLNBase(short bitCnt, VariableByteInput is) throws IOException {
        int blen = bitCnt / 8;
        if (bitCnt % 8 > 0) {
            ++blen;
        }
        this.bits = new byte[blen];
        is.read(this.bits);
        this.bitIndex = bitCnt - 1;
    }

    public DLNBase(byte prefixLen, DLNBase previous, short bitCnt, VariableByteInput is) throws IOException {
        int blen = bitCnt / 8;
        if (bitCnt % 8 > 0) {
            ++blen;
        }
        this.bits = new byte[blen];
        if (previous.bits.length < prefixLen) {
            throw new IOException("Found wrong prefix len: " + prefixLen + ". Previous: " + previous.toString());
        }
        System.arraycopy(previous.bits, 0, this.bits, 0, prefixLen);
        is.read(this.bits, prefixLen, blen - prefixLen);
        this.bitIndex = bitCnt - 1;
    }

    public void setLevelId(int offset, int levelId) {
        this.bitIndex = offset - 1;
        this.setCurrentLevelId(levelId);
    }

    public void addLevelId(int levelId, boolean isSubLevel) {
        if (this.bitIndex > -1) {
            this.setNextBit(isSubLevel);
        }
        this.setCurrentLevelId(levelId);
    }

    public void incrementLevelId() {
        int last = this.lastFieldPosition();
        this.bitIndex = last - 1;
        this.setCurrentLevelId(this.getLevelId(last) + 1);
    }

    public void decrementLevelId() {
        int last = this.lastFieldPosition();
        this.bitIndex = last - 1;
        int levelId = this.getLevelId(last) - 1;
        if (levelId < 1) {
            levelId = 0;
        }
        this.setCurrentLevelId(levelId);
        int len = this.bitIndex + 1;
        int blen = len / 8;
        if (len % 8 > 0) {
            ++blen;
        }
        if (blen < this.bits.length) {
            byte[] nbits = new byte[blen];
            System.arraycopy(this.bits, 0, nbits, 0, blen);
            this.bits = nbits;
        }
    }

    protected void setCurrentLevelId(int levelId) {
        int i;
        int units = DLNBase.getUnitsRequired(levelId);
        int numBits = DLNBase.bitWidth(units);
        if (units > 1) {
            levelId -= PER_COMPONENT_SIZE[units - 2];
        }
        for (i = 1; i < units; ++i) {
            this.setNextBit(true);
        }
        this.setNextBit(false);
        for (i = numBits - 1; i >= 0; --i) {
            this.setNextBit((levelId >>> i & 1) != 0);
        }
    }

    public int getLevelId(int startBit) {
        int units = DLNBase.unitsUsed(startBit, this.bits);
        startBit += units;
        int numBits = DLNBase.bitWidth(units);
        int id = 0;
        for (int i = numBits - 1; i >= 0; --i) {
            if ((this.bits[startBit >> 3] & 1 << (7 - startBit++ & 7)) == 0) continue;
            id |= 1 << i;
        }
        if (units > 1) {
            id += PER_COMPONENT_SIZE[units - 2];
        }
        return id;
    }

    public int units() {
        return this.bitIndex + 1;
    }

    public int size() {
        return this.bits.length;
    }

    private static int unitsUsed(int startBit, byte[] bits) {
        int units = 1;
        while ((bits[startBit >> 3] & 1 << (7 - startBit++ & 7)) != 0) {
            ++units;
        }
        return units;
    }

    public boolean isLevelSeparator(int index) {
        return (this.bits[index >> 3] & 1 << (7 - index & 7)) == 0;
    }

    public int getLevelCount(int startOffset) {
        int bit = startOffset;
        int count = 0;
        while (bit > -1 && bit <= this.bitIndex) {
            int units = DLNBase.unitsUsed(bit, this.bits);
            bit += units;
            if ((bit += DLNBase.bitWidth(units)) < this.bitIndex) {
                if ((this.bits[bit >> 3] & 1 << (7 - bit++ & 7)) != 0) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public int getSubLevelCount(int startOffset) {
        int bit = startOffset;
        int count = 0;
        while (bit > -1 && bit <= this.bitIndex) {
            int units = DLNBase.unitsUsed(bit, this.bits);
            bit += units;
            if ((bit += DLNBase.bitWidth(units)) < this.bitIndex) {
                ++count;
                if ((this.bits[bit >> 3] & 1 << (7 - bit++ & 7)) != 0) continue;
                break;
            }
            ++count;
        }
        return count;
    }

    public int[] getLevelIds() {
        int count = this.getLevelCount(0);
        int[] ids = new int[count];
        int offset = 0;
        for (int i = 0; i < count; ++i) {
            ids[i] = this.getLevelId(offset);
            offset += DLNBase.getUnitsRequired(ids[i]) * 4;
        }
        return ids;
    }

    public int lastLevelOffset() {
        int units;
        int lastOffset = 0;
        for (int bit = 0; bit <= this.bitIndex; bit += DLNBase.bitWidth(units)) {
            if (bit > 0) {
                if ((this.bits[bit >> 3] & 1 << (7 - bit & 7)) == 0) {
                    lastOffset = bit + 1;
                }
                ++bit;
            }
            units = DLNBase.unitsUsed(bit, this.bits);
            bit += units;
        }
        return lastOffset;
    }

    protected int lastFieldPosition() {
        int units;
        int lastOffset = 0;
        for (int bit = 0; bit <= this.bitIndex; bit += DLNBase.bitWidth(units)) {
            if (bit > 0) {
                lastOffset = ++bit;
            }
            units = DLNBase.unitsUsed(bit, this.bits);
            bit += units;
        }
        return lastOffset;
    }

    private void setNextBit(boolean value) {
        ++this.bitIndex;
        if (this.bitIndex >> 3 >= this.bits.length) {
            byte[] new_bits = new byte[this.bits.length + 1];
            System.arraycopy(this.bits, 0, new_bits, 0, this.bits.length);
            this.bits = new_bits;
        }
        if (value) {
            int n = this.bitIndex >> 3;
            this.bits[n] = (byte)(this.bits[n] | 1 << (7 - this.bitIndex & 7));
        } else {
            int n = this.bitIndex >> 3;
            this.bits[n] = (byte)(this.bits[n] & ~(1 << (7 - this.bitIndex & 7)));
        }
    }

    protected static int bitWidth(int units) {
        return units * 4 - units;
    }

    protected static int getUnitsRequired(int levelId) {
        for (int i = 0; i < PER_COMPONENT_SIZE.length; ++i) {
            if (levelId >= PER_COMPONENT_SIZE[i]) continue;
            return i + 1;
        }
        throw new IllegalStateException("Number of nodes exceeds the internal limit");
    }

    protected void compact() {
        int units = this.bitIndex + 1;
        int blen = units / 8;
        if (units % 8 > 0) {
            ++blen;
        }
        byte[] nbits = new byte[blen];
        System.arraycopy(this.bits, 0, nbits, 0, blen);
        this.bits = nbits;
    }

    public void serialize(byte[] data, int offset) {
        System.arraycopy(this.bits, 0, data, offset, this.bits.length);
    }

    public static int getLengthInBytes(int units, byte[] data, int startOffset) {
        return (int)Math.ceil((double)units / 8.0);
    }

    public boolean equals(DLNBase other) {
        if (this.bitIndex != other.bitIndex) {
            return false;
        }
        return Arrays.equals(this.bits, other.bits);
    }

    public int compareBits(DLNBase other, int bitCount) {
        int bytes = bitCount / 8;
        int remaining = bitCount % 8;
        for (int i = 0; i < bytes; ++i) {
            if (this.bits[i] == other.bits[i]) continue;
            return (this.bits[i] & 0xFF) - (other.bits[i] & 0xFF);
        }
        return (this.bits[bytes] & BIT_MASK[remaining]) - (other.bits[bytes] & BIT_MASK[remaining]);
    }

    public boolean startsWith(DLNBase other) {
        if (other.bitIndex > this.bitIndex) {
            return false;
        }
        int bytes = other.bitIndex / 8;
        int remaining = other.bitIndex % 8;
        for (int i = 0; i < bytes; ++i) {
            if (this.bits[i] == other.bits[i]) continue;
            return false;
        }
        return (this.bits[bytes] & BIT_MASK[remaining]) == (other.bits[bytes] & BIT_MASK[remaining]);
    }

    public String debug() {
        return this.toString() + " = " + this.toBitString() + " [" + (this.bitIndex + 1) + ']';
    }

    public String toString() {
        int id;
        StringBuilder buf = new StringBuilder();
        for (int offset = 0; offset <= this.bitIndex; offset += DLNBase.getUnitsRequired(id) * 4) {
            if (offset > 0) {
                if ((this.bits[offset >> 3] & 1 << (7 - offset++ & 7)) == 0) {
                    buf.append('.');
                } else {
                    buf.append('/');
                }
            }
            id = this.getLevelId(offset);
            buf.append(id);
        }
        return buf.toString();
    }

    public String toBitString() {
        StringBuilder buf = new StringBuilder();
        int len = this.bits.length;
        for (byte bit : this.bits) {
            buf.append(DLNBase.toBitString(bit));
        }
        return buf.toString();
    }

    public static String toBitString(byte b) {
        char[] buf = new char[8];
        int charPos = 8;
        int radix = 2;
        boolean mask = true;
        for (int i = 0; i < 8; ++i) {
            buf[--charPos] = digits[b & 1];
            b = (byte)(b >>> 1);
        }
        return new String(buf);
    }

    static {
        DLNBase.BIT_MASK[0] = 128;
        for (int i = 1; i < 8; ++i) {
            int mask = 1 << 7 - i;
            DLNBase.BIT_MASK[i] = mask + BIT_MASK[i - 1];
        }
        PER_COMPONENT_SIZE = DLNBase.initComponents();
        digits = new char[]{'0', '1'};
    }
}

