/*
 * Decompiled with CFR 0.152.
 */
package org.exist.plugin;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.LifeCycle;
import org.exist.backup.BackupHandler;
import org.exist.backup.RestoreHandler;
import org.exist.collections.Collection;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.plugin.Plug;
import org.exist.plugin.PluginsManager;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@ConfigurationClass(value="plugin-manager")
public class PluginsManagerImpl
implements Configurable,
BrokerPoolService,
PluginsManager,
LifeCycle {
    private static final Logger LOG = LogManager.getLogger(PluginsManagerImpl.class);
    public static final XmldbURI COLLETION_URI = XmldbURI.SYSTEM.append("plugins");
    public static final XmldbURI CONFIG_FILE_URI = XmldbURI.create("config.xml");
    @ConfigurationFieldAsAttribute(value="version")
    private String version = "1.0";
    @ConfigurationFieldAsElement(value="plugin")
    private List<String> runPlugins = new ArrayList<String>();
    private Map<String, Plug> jacks = new HashMap<String, Plug>();
    private Configuration configuration = null;
    private Collection collection;
    private Database db;
    private RestoreHandler rh = new RH();

    @Override
    public void prepare(BrokerPool brokerPool) {
        this.db = brokerPool;
        this.addPlugin("org.exist.scheduler.SchedulerManager");
        this.addPlugin("org.exist.storage.md.MDStorageManager");
        this.addPlugin("org.exist.monitoring.MonitoringManager");
    }

    @Override
    public void startSystem(DBBroker systemBroker) throws BrokerPoolServiceException {
        try {
            this.start(systemBroker);
        }
        catch (EXistException e) {
            throw new BrokerPoolServiceException(e);
        }
    }

    @Override
    public void start(DBBroker broker) throws EXistException {
        TransactionManager transaction = broker.getBrokerPool().getTransactionManager();
        try {
            Txn txn = transaction.beginTransaction();
            Iterator<Plug> iterator = null;
            try {
                this.collection = broker.getCollection(COLLETION_URI);
                if (this.collection == null) {
                    this.collection = broker.getOrCreateCollection(txn, COLLETION_URI);
                    if (this.collection == null) {
                        return;
                    }
                    this.collection.setPermissions(504);
                    broker.saveCollection(txn, this.collection);
                }
                transaction.commit(txn);
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (txn != null) {
                    if (iterator != null) {
                        try {
                            txn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        txn.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.debug("loading configuration failed: " + e.getMessage());
        }
        Configuration _config_ = Configurator.parse(this, broker, this.collection, CONFIG_FILE_URI);
        this.configuration = Configurator.configure(this, _config_);
        try {
            for (Class clazz : this.listServices(Plug.class)) {
                try {
                    Constructor ctor = clazz.getConstructor(PluginsManager.class);
                    Plug plgn = (Plug)ctor.newInstance(this);
                    this.jacks.put(clazz.getName(), plgn);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (Plug plug : this.jacks.values()) {
            if (!(plug instanceof LifeCycle)) continue;
            plug.start(broker);
        }
    }

    @Override
    public void sync(DBBroker broker) {
        for (Plug plugin : this.jacks.values()) {
            try {
                plugin.sync(broker);
            }
            catch (Throwable e) {
                LOG.error((Object)e);
            }
        }
    }

    @Override
    public void stop(DBBroker broker) {
        for (Plug plugin : this.jacks.values()) {
            try {
                plugin.stop(broker);
            }
            catch (Throwable e) {
                LOG.error((Object)e);
            }
        }
    }

    public String version() {
        return this.version;
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public void addPlugin(String className) {
        if (this.jacks.containsKey(className)) {
            return;
        }
        try {
            Class<?> plugin = Class.forName(className);
            Constructor<?> ctor = plugin.getConstructor(PluginsManager.class);
            Plug plgn = (Plug)ctor.newInstance(this);
            this.jacks.put(plugin.getName(), plgn);
            this.runPlugins.add(className);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private <S> Iterable<Class<? extends S>> listServices(Class<S> ifc) throws Exception {
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = ldr.getResources("META-INF/services/" + ifc.getName());
        HashSet<Class<S>> services = new HashSet<Class<S>>();
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            InputStream is = url.openStream();
            Throwable throwable = null;
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                Throwable throwable2 = null;
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        String name;
                        int comment = line.indexOf(35);
                        if (comment >= 0) {
                            line = line.substring(0, comment);
                        }
                        if ((name = line.trim()).length() == 0) continue;
                        Class<?> clz = Class.forName(name, true, ldr);
                        Class<S> impl = clz.asSubclass(ifc);
                        services.add(impl);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (r == null) continue;
                    if (throwable2 != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    r.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
        return services;
    }

    @Override
    public boolean isConfigured() {
        return this.configuration != null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public BackupHandler getBackupHandler(Logger logger) {
        return new BH(logger);
    }

    @Override
    public RestoreHandler getRestoreHandler() {
        return this.rh;
    }

    class RH
    implements RestoreHandler {
        RH() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).setDocumentLocator(locator);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).startDocument();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).endDocument();
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).startPrefixMapping(prefix, uri);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).endPrefixMapping(prefix);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).startElement(uri, localName, qName, atts);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).endElement(uri, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).ignorableWhitespace(ch, start, length);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).processingInstruction(target, data);
            }
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).skippedEntity(name);
            }
        }

        @Override
        public void startCollectionRestore(Collection colection, Attributes atts) {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).startCollectionRestore(colection, atts);
            }
        }

        @Override
        public void endCollectionRestore(Collection colection) {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).endCollectionRestore(colection);
            }
        }

        @Override
        public void startDocumentRestore(Document document, Attributes atts) {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).startDocumentRestore(document, atts);
            }
        }

        @Override
        public void endDocumentRestore(Document document) {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof RestoreHandler)) continue;
                ((RestoreHandler)((Object)plugin)).endDocumentRestore(document);
            }
        }
    }

    class BH
    implements BackupHandler {
        Logger LOG;

        public BH(Logger logger) {
            this.LOG = logger;
        }

        @Override
        public void backup(Collection colection, AttributesImpl attrs) {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof BackupHandler)) continue;
                try {
                    ((BackupHandler)((Object)plugin)).backup(colection, attrs);
                }
                catch (Exception e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void backup(Collection colection, SAXSerializer serializer) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof BackupHandler)) continue;
                try {
                    ((BackupHandler)((Object)plugin)).backup(colection, serializer);
                }
                catch (Exception e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void backup(Document document, AttributesImpl attrs) {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof BackupHandler)) continue;
                try {
                    ((BackupHandler)((Object)plugin)).backup(document, attrs);
                }
                catch (Exception e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void backup(Document document, SAXSerializer serializer) throws SAXException {
            for (Plug plugin : PluginsManagerImpl.this.jacks.values()) {
                if (!(plugin instanceof BackupHandler)) continue;
                try {
                    ((BackupHandler)((Object)plugin)).backup(document, serializer);
                }
                catch (Exception e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

