/*
 * Decompiled with CFR 0.152.
 */
package org.exist.plugin.command;

import java.util.HashMap;
import java.util.Map;
import org.exist.plugin.command.Command;
import org.exist.plugin.command.CommandException;
import org.exist.plugin.command.CommandNotFoundException;
import org.exist.plugin.command.CommandResolver;
import org.exist.xmldb.XmldbURI;

public abstract class AbstractCommandResolver
implements CommandResolver {
    protected Map<String, Command> commands = new HashMap<String, Command>();

    public void plug(Class<? extends Command> commandClass) {
        Command cmd;
        try {
            cmd = commandClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String[] names = cmd.getNames();
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            this.commands.put(names[i], cmd);
        }
    }

    public Command getCommand(String name) throws CommandNotFoundException {
        Command cmd = this.commands.get(name);
        if (cmd == null) {
            throw new CommandNotFoundException("Command '" + name + "' not found.");
        }
        return cmd;
    }

    @Override
    public void execute(XmldbURI collection, String[] params) throws CommandException {
        Command cmd = this.getCommand(params[0]);
        String[] commandData = new String[params.length - 1];
        System.arraycopy(params, 1, commandData, 0, params.length - 1);
        cmd.process(collection, commandData);
    }
}

