/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedDownload;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;

public class EmbeddedDownloadThread
extends Thread {
    private static final Logger LOG = LogManager.getLogger(EmbeddedDownloadThread.class);
    private final XmldbURL xmldbURL;
    private final OutputStream bos;
    private Subject subject;
    private BrokerPool brokerPool;
    private static final AtomicInteger threadInitNumber = new AtomicInteger();

    public EmbeddedDownloadThread(XmldbURL url, OutputStream bos) {
        super("exist-embeddedDownloadThread-" + threadInitNumber.getAndIncrement());
        this.xmldbURL = url;
        this.bos = bos;
        try {
            BrokerPool pool = BrokerPool.getInstance(url.getInstanceName());
            this.subject = pool.getActiveBroker().getCurrentSubject();
        }
        catch (Throwable e) {
            LOG.error((Object)e);
        }
    }

    public EmbeddedDownloadThread(BrokerPool brokerPool, XmldbURL url, OutputStream bos) {
        super("EmbeddedDownloadThread-" + threadInitNumber.getAndIncrement());
        this.xmldbURL = url;
        this.bos = bos;
        try {
            this.brokerPool = brokerPool == null ? BrokerPool.getInstance(url.getInstanceName()) : brokerPool;
            this.subject = this.brokerPool.getActiveBroker().getCurrentSubject();
        }
        catch (Throwable e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread started.");
        }
        try {
            EmbeddedDownload ed = new EmbeddedDownload();
            ed.setBrokerPool(this.brokerPool);
            ed.stream(this.xmldbURL, this.bos, this.subject);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
        }
        finally {
            try {
                this.bos.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Thread stopped.");
            }
        }
    }
}

