/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedUploadThread;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.io.BlockingInputStream;

public class EmbeddedOutputStream
extends OutputStream {
    private static final Logger logger = LogManager.getLogger(EmbeddedOutputStream.class);
    private BlockingInputStream bis;
    private OutputStream bos;
    private EmbeddedUploadThread rt;

    public EmbeddedOutputStream(XmldbURL xmldbURL) {
        logger.debug("Initializing EmbeddedUploadThread");
        this.bis = new BlockingInputStream();
        this.bos = this.bis.getOutputStream();
        this.rt = new EmbeddedUploadThread(xmldbURL, this.bis);
        this.rt.start();
        logger.debug("Initializing EmbeddedUploadThread done");
    }

    @Override
    public void write(int b) throws IOException {
        this.bos.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.bos.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.bos.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.bos.close();
    }

    @Override
    public void flush() throws IOException {
        this.bos.flush();
    }
}

