/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedUpload;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.io.BlockingInputStream;

public class EmbeddedUploadThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(EmbeddedUploadThread.class);
    private XmldbURL xmldbURL;
    private BlockingInputStream bis;
    private Subject subject = null;
    private static final AtomicInteger threadInitNumber = new AtomicInteger();

    public EmbeddedUploadThread(XmldbURL url, BlockingInputStream bis) {
        super("exist-embeddedDownloadThread-" + threadInitNumber.getAndIncrement());
        this.xmldbURL = url;
        this.bis = bis;
        try {
            BrokerPool pool = BrokerPool.getInstance(url.getInstanceName());
            this.subject = pool.getActiveBroker().getCurrentSubject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        logger.debug("Thread started.");
        IOException exception = null;
        try {
            EmbeddedUpload uploader = new EmbeddedUpload();
            uploader.stream(this.xmldbURL, this.bis, this.subject);
            this.bis.close(exception);
        }
        catch (IOException ex) {
            try {
                logger.error((Object)ex);
                exception = ex;
                this.bis.close(exception);
            }
            catch (Throwable throwable) {
                this.bis.close(exception);
                logger.debug("Thread stopped.");
                throw throwable;
            }
            logger.debug("Thread stopped.");
        }
        logger.debug("Thread stopped.");
    }
}

