/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.protocols.xmldb;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.Mode;
import org.exist.protocolhandler.protocols.xmldb.EmbeddedURLConnection;
import org.exist.protocolhandler.protocols.xmldb.InMemoryURLConnection;

public class Handler
extends URLStreamHandler {
    private static final Logger LOG = LogManager.getLogger(Handler.class);
    public static final String XMLDB_EXIST = "xmldb:exist:";
    public static final String XMLDB = "xmldb:";
    public static final String PATTERN = "xmldb:[\\w]+:\\/\\/.*";
    Mode mode;

    public Handler(Mode mode) {
        LOG.debug("Setup \"xmldb:\" handler");
        this.mode = mode;
    }

    @Override
    protected void parseURL(URL url, String spec, int start, int limit) {
        LOG.debug(spec);
        if (spec.startsWith("xmldb:exist://")) {
            LOG.debug("Parsing xmldb:exist:// URL.");
            super.parseURL(url, spec, XMLDB_EXIST.length(), limit);
        } else if (spec.startsWith("xmldb://")) {
            LOG.debug("Parsing xmldb:// URL.");
            super.parseURL(url, spec, XMLDB.length(), limit);
        } else if (spec.startsWith("xmldb:/")) {
            LOG.debug("Parsing xmldb:/ URL.");
            super.parseURL(url, spec, XMLDB.length(), limit);
        } else if (spec.matches(PATTERN)) {
            LOG.debug("Parsing URL with custom exist instance");
            int separator = spec.indexOf("//");
            super.parseURL(url, spec, separator, limit);
        } else if (spec.startsWith("xmldb:://")) {
            int separator = spec.indexOf("//");
            super.parseURL(url, spec, separator, limit);
        } else if (spec.startsWith("xmldb:/")) {
            super.parseURL(url, spec, start, limit);
        } else {
            LOG.error("Expected 'xmldb:'-like URL, found " + spec);
            super.parseURL(url, spec, start, limit);
        }
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        switch (this.mode) {
            case THREADS: {
                return new EmbeddedURLConnection(u);
            }
            case MEMORY: {
                return new InMemoryURLConnection(u);
            }
        }
        throw new IOException("unsupported mode " + (Object)((Object)this.mode));
    }
}

