/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.protocols.xmldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.embedded.InMemoryInputStream;
import org.exist.protocolhandler.embedded.InMemoryOutputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcInputStream;
import org.exist.protocolhandler.xmlrpc.XmlrpcOutputStream;

public class InMemoryURLConnection
extends URLConnection {
    private static final Logger LOG = LogManager.getLogger(InMemoryURLConnection.class);

    protected InMemoryURLConnection(URL url) {
        super(url);
        this.setDoInput(true);
        this.setDoOutput(true);
    }

    @Override
    public void connect() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect: " + this.url);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        XmldbURL xmldbURL = new XmldbURL(this.url);
        if (xmldbURL.isEmbedded()) {
            return InMemoryInputStream.stream(xmldbURL);
        }
        return new XmlrpcInputStream(xmldbURL);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        XmldbURL xmldbURL = new XmldbURL(this.url);
        if (xmldbURL.isEmbedded()) {
            return new InMemoryOutputStream(xmldbURL);
        }
        return new XmlrpcOutputStream(xmldbURL);
    }
}

