/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmlrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.exist.protocolhandler.xmldb.XmldbURL;

public class XmlrpcDownload {
    private static final Logger LOG = LogManager.getLogger(XmlrpcDownload.class);

    public void stream(XmldbURL xmldbURL, OutputStream os) throws IOException {
        LOG.debug("Begin document download");
        try {
            XmlRpcClient client = new XmlRpcClient();
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setEncoding("UTF-8");
            config.setEnabledForExtensions(true);
            config.setServerURL(new URL(xmldbURL.getXmlRpcURL()));
            if (xmldbURL.hasUserInfo()) {
                config.setBasicUserName(xmldbURL.getUsername());
                config.setBasicPassword(xmldbURL.getPassword());
            }
            client.setConfig((XmlRpcClientConfig)config);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("indent", "no");
            options.put("encoding", "UTF-8");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(xmldbURL.getCollectionPath());
            params.add(options);
            Map ht = (Map)client.execute("getDocumentData", params);
            int offset = (Integer)ht.get("offset");
            byte[] data = (byte[])ht.get("data");
            String handle = (String)ht.get("handle");
            os.write(data);
            while (offset != 0) {
                params.clear();
                params.add(handle);
                params.add(offset);
                ht = (Map)client.execute("getNextChunk", params);
                data = (byte[])ht.get("data");
                offset = (Integer)ht.get("offset");
                os.write(data);
            }
        }
        catch (XmlRpcException ex) {
            LOG.error((Object)ex);
            throw new IOException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw ex;
        }
        finally {
            LOG.debug("Finished document download");
        }
    }
}

