/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmlrpc;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcUpload;
import org.exist.storage.io.BlockingInputStream;

public class XmlrpcUploadThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(XmlrpcUploadThread.class);
    private XmldbURL xmldbURL;
    private BlockingInputStream bis;
    private static final AtomicInteger threadInitNumber = new AtomicInteger();

    public XmlrpcUploadThread(XmldbURL url, BlockingInputStream bis) {
        super("exist-xmlrpcUploadThread-" + threadInitNumber.getAndIncrement());
        this.xmldbURL = url;
        this.bis = bis;
    }

    @Override
    public void run() {
        logger.debug("Thread started.");
        IOException exception = null;
        try {
            XmlrpcUpload uploader = new XmlrpcUpload();
            uploader.stream(this.xmldbURL, this.bis);
            this.bis.close(exception);
        }
        catch (IOException ex) {
            try {
                logger.error((Object)ex);
                exception = ex;
                this.bis.close(exception);
            }
            catch (Throwable throwable) {
                this.bis.close(exception);
                logger.debug("Thread stopped.");
                throw throwable;
            }
            logger.debug("Thread stopped.");
        }
        logger.debug("Thread stopped.");
    }
}

