/*
 * Decompiled with CFR 0.152.
 */
package org.exist.repo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.exist.repo.ExistPkgInfo;
import org.expath.pkg.repo.DescriptorExtension;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.PackageInfo;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.parser.XMLStreamHelper;

public class ExistPkgExtension
extends DescriptorExtension {
    public static final String EXIST_PKG_NS = "http://exist-db.org/ns/expath-pkg";
    private XMLStreamHelper myXSHelper = new XMLStreamHelper("http://exist-db.org/ns/expath-pkg");

    public ExistPkgExtension() {
        super("exist", "exist.xml");
    }

    protected void parseDescriptor(XMLStreamReader parser, Package pkg) throws PackageException {
        this.myXSHelper.ensureNextElement(parser, "package");
        ExistPkgInfo info = new ExistPkgInfo(pkg);
        try {
            parser.next();
            while (parser.getEventType() == 1) {
                if (!EXIST_PKG_NS.equals(parser.getNamespaceURI())) {
                    throw new PackageException("TODO: Ignore elements in other namespace");
                }
                this.handleElement(parser, pkg, info);
                parser.next();
            }
            parser.next();
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error reading the exist descriptor", (Throwable)ex);
        }
        pkg.addInfo(this.getName(), (PackageInfo)info);
        if (!info.getJars().isEmpty()) {
            try {
                pkg.getResolver().resolveResource(".exist/classpath.txt");
            }
            catch (Storage.NotExistException ex) {
                this.setupPackage(pkg, info);
            }
        }
    }

    private void handleElement(XMLStreamReader parser, Package pkg, ExistPkgInfo info) throws PackageException, XMLStreamException {
        String local = parser.getLocalName();
        if ("jar".equals(local)) {
            String jar = this.myXSHelper.getElementValue(parser);
            info.addJar(jar);
        } else if ("java".equals(local)) {
            this.handleJava(parser, info);
        } else if ("xquery".equals(local)) {
            this.handleXQuery(parser, pkg, info);
        } else {
            throw new PackageException("Unknown eXist component type: " + local);
        }
    }

    private void handleJava(XMLStreamReader parser, ExistPkgInfo info) throws PackageException, XMLStreamException {
        this.myXSHelper.ensureNextElement(parser, "namespace");
        String href = this.myXSHelper.getElementValue(parser);
        this.myXSHelper.ensureNextElement(parser, "class");
        String clazz = this.myXSHelper.getElementValue(parser);
        parser.next();
        try {
            info.addJava(new URI(href), clazz);
        }
        catch (URISyntaxException ex) {
            throw new PackageException("Invalid URI: " + href, (Throwable)ex);
        }
    }

    private void handleXQuery(XMLStreamReader parser, Package pkg, ExistPkgInfo info) throws PackageException, XMLStreamException {
        if (!this.myXSHelper.isNextElement(parser, "import-uri")) {
            this.myXSHelper.ensureElement(parser, "namespace");
        }
        String href = this.myXSHelper.getElementValue(parser);
        this.myXSHelper.ensureNextElement(parser, "file");
        String file = this.myXSHelper.getElementValue(parser);
        parser.next();
        try {
            info.addXQuery(new URI(href), file);
        }
        catch (URISyntaxException ex) {
            throw new PackageException("Invalid URI: " + href, (Throwable)ex);
        }
    }

    private void setupPackage(Package pkg, ExistPkgInfo info) throws PackageException {
        FileSystemStorage.FileSystemResolver res = (FileSystemStorage.FileSystemResolver)pkg.getResolver();
        Path classpath = res.resolveResourceAsFile(".exist/classpath.txt").toPath();
        Path exist = classpath.getParent();
        if (!Files.exists(exist, new LinkOption[0])) {
            try {
                Files.createDirectories(exist, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PackageException("Impossible to create directory: " + exist);
            }
        }
        Set<String> jars = info.getJars();
        try (BufferedWriter out = Files.newBufferedWriter(classpath, new OpenOption[0]);){
            for (String jar : jars) {
                StreamSource jar_src;
                try {
                    jar_src = res.resolveComponent(jar);
                }
                catch (Storage.NotExistException ex) {
                    String msg = "Inconsistent package descriptor, the JAR file is not in the package: ";
                    throw new PackageException("Inconsistent package descriptor, the JAR file is not in the package: " + jar, (Throwable)ex);
                }
                URI uri = URI.create(jar_src.getSystemId());
                Path file = Paths.get(uri);
                out.write(file.normalize().toString());
                out.write("\n");
            }
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the eXist classpath file: " + classpath, (Throwable)ex);
        }
    }

    public void install(Repository repository, Package pkg) throws PackageException {
        this.init(repository, pkg);
    }
}

