/*
 * Decompiled with CFR 0.152.
 */
package org.exist.repo;

import java.io.IOException;
import java.nio.file.Path;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.deps.DependencyVersion;

public interface PackageLoader {
    public Path load(String var1, Version var2) throws IOException;

    public static class Version {
        String min = null;
        String max = null;
        String semVer = null;
        String version = null;

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public String getSemVer() {
            return this.semVer;
        }

        public String getVersion() {
            return this.version;
        }

        public DependencyVersion getDependencyVersion() throws PackageException {
            return DependencyVersion.makeVersion((String)this.version, (String)this.semVer, (String)this.min, (String)this.max);
        }

        public String toString() {
            StringBuilder v = new StringBuilder();
            if (this.min != null) {
                v.append("> ").append(this.min);
            }
            if (this.max != null) {
                v.append(" < ").append(this.max);
            }
            if (this.semVer != null) {
                v.append(this.semVer);
            }
            if (this.version != null) {
                v.append(this.version);
            }
            return v.toString();
        }

        public Version(String version, boolean semver) {
            if (semver) {
                this.semVer = version;
            } else {
                this.version = version;
            }
        }

        public Version(String min, String max) {
            this.min = min;
            this.max = max;
        }
    }
}

