/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import org.quartz.JobExecutionException;

public class JobException
extends Exception {
    private static final long serialVersionUID = 1567438994821964637L;
    private final JobExceptionAction jobExceptionAction;

    public JobException(JobExceptionAction jobExceptionAction, String message) {
        super(message);
        this.jobExceptionAction = jobExceptionAction;
    }

    public void cleanupJob() throws JobExecutionException {
        switch (this.jobExceptionAction) {
            case JOB_REFIRE: {
                throw new JobExecutionException(this.getMessage(), true);
            }
            case JOB_ABORT_THIS: {
                JobExecutionException jat = new JobExecutionException(this.getMessage(), false);
                jat.setUnscheduleFiringTrigger(true);
                throw jat;
            }
            case JOB_ABORT_ALL: {
                JobExecutionException jaa = new JobExecutionException(this.getMessage(), false);
                jaa.setUnscheduleAllTriggers(true);
                throw jaa;
            }
        }
        throw new JobExecutionException(this.getMessage(), false);
    }

    public static enum JobExceptionAction {
        JOB_ABORT,
        JOB_ABORT_THIS,
        JOB_ABORT_ALL,
        JOB_REFIRE;

    }
}

