/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.scheduler.JobConfig;
import org.exist.scheduler.JobDescription;
import org.exist.scheduler.JobType;
import org.exist.scheduler.ScheduledJobInfo;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.UserXQueryJob;
import org.exist.scheduler.impl.SystemTaskJobImpl;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzSchedulerImpl
implements Scheduler,
BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(QuartzSchedulerImpl.class);
    private org.quartz.Scheduler scheduler;
    private final BrokerPool brokerPool;
    private Configuration config;
    private static final Properties defaultQuartzProperties = new Properties();

    public QuartzSchedulerImpl(BrokerPool brokerpool) {
        this.brokerPool = brokerpool;
    }

    @Override
    public void configure(Configuration configuration) throws BrokerPoolServiceException {
        this.config = configuration;
    }

    @Override
    public void prepare(BrokerPool brokerPool) throws BrokerPoolServiceException {
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(this.getQuartzProperties());
            this.scheduler = schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            throw new BrokerPoolServiceException("Unable to create Scheduler: " + e.getMessage(), e);
        }
    }

    @Override
    public void startMultiUser(BrokerPool brokerPool) throws BrokerPoolServiceException {
        this.run();
    }

    private Properties getQuartzProperties() {
        Properties properties = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream("quartz.properties");){
            if (is != null) {
                properties.load(is);
                LOG.info("Successfully loaded quartz.properties");
            } else {
                LOG.warn("Could not load quartz.properties, will use defaults.");
            }
        }
        catch (IOException ioe) {
            LOG.warn("Could not load quartz.properties, will defaults. " + ioe.getMessage(), (Throwable)ioe);
        }
        if (properties == null || properties.size() == 0) {
            LOG.warn("Using default properties for Quartz scheduler");
            properties.putAll((Map<?, ?>)defaultQuartzProperties);
        }
        if (!properties.containsKey("org.quartz.scheduler.instanceName")) {
            properties.setProperty("org.quartz.scheduler.instanceName", this.brokerPool.getId() + "_QuartzScheduler");
        }
        return properties;
    }

    protected org.quartz.Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void run() {
        try {
            this.setupConfiguredJobs();
            this.getScheduler().start();
        }
        catch (SchedulerException se) {
            LOG.error("Unable to start the Scheduler: " + se.getMessage(), (Throwable)se);
        }
    }

    @Override
    public void shutdown(boolean waitForJobsToComplete) {
        try {
            this.getScheduler().shutdown(waitForJobsToComplete);
        }
        catch (SchedulerException se) {
            LOG.warn("Unable to shutdown the Scheduler:" + se.getMessage(), (Throwable)se);
        }
    }

    @Override
    public boolean isShutdown() {
        try {
            return this.getScheduler().isShutdown();
        }
        catch (SchedulerException se) {
            LOG.warn("Unable to determine the status of the Scheduler: " + se.getMessage(), (Throwable)se);
            return false;
        }
    }

    @Override
    public boolean createPeriodicJob(long period, JobDescription job, long delay) {
        return this.createPeriodicJob(period, job, delay, null, -1);
    }

    @Override
    public boolean createPeriodicJob(long period, JobDescription job, long delay, Properties params) {
        return this.createPeriodicJob(period, job, delay, params, -1);
    }

    @Override
    public boolean createPeriodicJob(long period, JobDescription job, long delay, Properties params, int repeatCount) {
        return this.createPeriodicJob(period, job, delay, params, repeatCount, true);
    }

    @Override
    public boolean createPeriodicJob(long period, JobDescription job, long delay, Properties params, int repeatCount, boolean unschedule) {
        Trigger trigger;
        JobDetail jobDetail = JobBuilder.newJob(job.getClass()).withIdentity(job.getName(), job.getGroup()).build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        this.setupJobDataMap(job, jobDataMap, params, unschedule);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(job.getName() + " Trigger", job.getGroup()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(period).withRepeatCount(repeatCount));
        if (delay <= 0L) {
            trigger = triggerBuilder.startNow().build();
        } else {
            Calendar start = Calendar.getInstance();
            start.add(14, (int)delay);
            Date triggerStart = start.getTime();
            trigger = triggerBuilder.startAt(triggerStart).build();
        }
        try {
            this.getScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            LOG.error("Failed to schedule periodic job '" + job.getName() + "': " + se.getMessage(), (Throwable)se);
            return false;
        }
        return true;
    }

    @Override
    public boolean createCronJob(String cronExpression, JobDescription job) {
        return this.createCronJob(cronExpression, job, null);
    }

    @Override
    public boolean createCronJob(String cronExpression, JobDescription job, Properties params) {
        return this.createCronJob(cronExpression, job, params, true);
    }

    @Override
    public boolean createCronJob(String cronExpression, JobDescription job, Properties params, boolean unschedule) {
        JobDetail jobDetail = JobBuilder.newJob(job.getClass()).withIdentity(job.getName(), job.getGroup()).build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        this.setupJobDataMap(job, jobDataMap, params, unschedule);
        try {
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(job.getName() + " Trigger", job.getGroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            this.getScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            LOG.error("Failed to schedule cron job '" + job.getName() + "': " + se.getMessage(), (Throwable)se);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteJob(String jobName, String jobGroup) {
        boolean deletedJob = false;
        try {
            deletedJob = this.getScheduler().deleteJob(new JobKey(jobName, jobGroup));
        }
        catch (SchedulerException se) {
            LOG.error("Failed to delete job '" + jobName + "': " + se.getMessage(), (Throwable)se);
        }
        return deletedJob;
    }

    @Override
    public boolean pauseJob(String jobName, String jobGroup) {
        try {
            this.getScheduler().pauseJob(new JobKey(jobName, jobGroup));
            return true;
        }
        catch (SchedulerException se) {
            LOG.error("Failed to pause job '" + jobName + "': " + se.getMessage(), (Throwable)se);
            return false;
        }
    }

    @Override
    public boolean resumeJob(String jobName, String jobGroup) {
        try {
            this.getScheduler().resumeJob(new JobKey(jobName, jobGroup));
            return true;
        }
        catch (SchedulerException se) {
            LOG.error("Failed to resume job '" + jobName + "': " + se.getMessage(), (Throwable)se);
            return false;
        }
    }

    @Override
    public List<String> getJobGroupNames() {
        ArrayList<String> jobNames = new ArrayList<String>();
        try {
            jobNames.addAll(this.getScheduler().getJobGroupNames());
        }
        catch (SchedulerException se) {
            LOG.error("Failed to get job group names: " + se.getMessage(), (Throwable)se);
        }
        return jobNames;
    }

    @Override
    public List<ScheduledJobInfo> getScheduledJobs() {
        ArrayList<ScheduledJobInfo> scheduledJobs = new ArrayList<ScheduledJobInfo>();
        try {
            for (String triggerGroupName : this.getScheduler().getTriggerGroupNames()) {
                for (TriggerKey triggerKey : this.getScheduler().getTriggerKeys(GroupMatcher.triggerGroupEquals((String)triggerGroupName))) {
                    scheduledJobs.add(new ScheduledJobInfo(this.getScheduler(), this.getScheduler().getTrigger(triggerKey)));
                }
            }
        }
        catch (SchedulerException se) {
            LOG.error("Failed to get scheduled jobs: " + se.getMessage(), (Throwable)se);
        }
        return scheduledJobs;
    }

    @Override
    public ScheduledJobInfo[] getExecutingJobs() {
        ScheduledJobInfo[] result = null;
        try {
            List<ScheduledJobInfo> jobs = this.getScheduler().getCurrentlyExecutingJobs().stream().map(jobExecutionCtx -> new ScheduledJobInfo(this.getScheduler(), jobExecutionCtx.getTrigger())).collect(Collectors.toList());
            result = new ScheduledJobInfo[jobs.size()];
            jobs.toArray(result);
        }
        catch (SchedulerException se) {
            LOG.error("Failed to get executing jobs: " + se.getMessage(), (Throwable)se);
        }
        return result;
    }

    @Override
    public void setupConfiguredJobs() {
        JobConfig[] jobList = (JobConfig[])this.config.getProperty("scheduler.jobs");
        if (jobList == null) {
            return;
        }
        for (JobConfig jobConfig : jobList) {
            JobDescription job = null;
            if (jobConfig.getResourceName().startsWith("/db/") || jobConfig.getResourceName().indexOf(58) > 0) {
                if (jobConfig.getType().equals((Object)JobType.SYSTEM)) {
                    LOG.error("System jobs may only be written in Java");
                } else {
                    Subject guestUser = this.brokerPool.getSecurityManager().getGuestSubject();
                    job = new UserXQueryJob(jobConfig.getJobName(), jobConfig.getResourceName(), guestUser);
                    try {
                        if (this.getScheduler().getJobDetail(new JobKey(job.getName(), "eXist.User")) != null) {
                            job.setName(job.getName() + job.hashCode());
                        }
                    }
                    catch (SchedulerException e) {
                        LOG.error("Unable to set job name: " + e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                try {
                    Class<?> jobClass = Class.forName(jobConfig.getResourceName());
                    Object jobObject = jobClass.newInstance();
                    if (jobConfig.getType().equals((Object)JobType.SYSTEM)) {
                        if (jobObject instanceof SystemTask) {
                            SystemTask task = (SystemTask)jobObject;
                            task.configure(this.config, jobConfig.getParameters());
                            job = new SystemTaskJobImpl(jobConfig.getJobName(), task);
                        } else {
                            LOG.error("System jobs must extend SystemTask");
                        }
                    } else if (jobObject instanceof JobDescription) {
                        job = (JobDescription)jobObject;
                        if (jobConfig.getJobName() != null) {
                            job.setName(jobConfig.getJobName());
                        }
                    } else {
                        LOG.error("Startup job " + jobConfig.getJobName() + "  must extend org.exist.scheduler.StartupJob");
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to schedule '" + (Object)((Object)jobConfig.getType()) + "' job " + jobConfig.getResourceName() + ": " + e.getMessage(), (Throwable)e);
                }
            }
            if (job == null) continue;
            if (jobConfig.getSchedule().indexOf(32) > -1) {
                this.createCronJob(jobConfig.getSchedule(), job, jobConfig.getParameters());
                continue;
            }
            this.createPeriodicJob(Long.parseLong(jobConfig.getSchedule()), job, jobConfig.getDelay(), jobConfig.getParameters(), jobConfig.getRepeat(), jobConfig.unscheduleOnException());
        }
    }

    private void setupJobDataMap(JobDescription job, JobDataMap jobDataMap, Properties params, boolean unschedule) {
        jobDataMap.put("database", (Object)this.brokerPool);
        if (job instanceof SystemTaskJobImpl) {
            jobDataMap.put("systemtask", (Object)((SystemTaskJobImpl)job).getSystemTask());
        }
        if (job instanceof UserXQueryJob) {
            jobDataMap.put("xqueryresource", ((UserXQueryJob)job).getXQueryResource());
            jobDataMap.put("account", (Object)((UserXQueryJob)job).getUser());
        }
        if (params != null) {
            jobDataMap.put("params", (Object)params);
        }
        jobDataMap.put("unschedule", (Object)unschedule);
    }

    static {
        defaultQuartzProperties.setProperty("org.quartz.scheduler.instanceName", "DefaultQuartzScheduler");
        defaultQuartzProperties.setProperty("org.quartz.scheduler.rmi.export", "false");
        defaultQuartzProperties.setProperty("org.quartz.scheduler.rmi.proxy", "false");
        defaultQuartzProperties.setProperty("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        defaultQuartzProperties.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
        defaultQuartzProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        defaultQuartzProperties.setProperty("org.quartz.threadPool.threadCount", "4");
        defaultQuartzProperties.setProperty("org.quartz.threadPool.threadPriority", "5");
        defaultQuartzProperties.setProperty("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", "true");
        defaultQuartzProperties.setProperty("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        defaultQuartzProperties.setProperty("org.quartz.jobStore.misfireThreshold", "60000");
    }
}

