/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler.impl;

import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;
import org.exist.util.NamedThreadFactory;

public class ShutdownTask
implements SystemTask {
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();

    @Override
    public String getName() {
        return "Database Shutdown";
    }

    @Override
    public void configure(Configuration config, Properties properties) throws EXistException {
    }

    @Override
    public void execute(DBBroker broker) throws EXistException {
        AsyncShutdown shutdownCallable = new AsyncShutdown(broker.getBrokerPool());
        Executors.newSingleThreadExecutor(new NamedThreadFactory("shutdownTask-asyncShutdown")).submit(shutdownCallable);
    }

    @Override
    public boolean afterCheckpoint() {
        return true;
    }

    private static class AsyncShutdown
    implements Callable<Void> {
        private final BrokerPool brokerPool;

        public AsyncShutdown(BrokerPool brokerPool) {
            this.brokerPool = brokerPool;
        }

        @Override
        public Void call() {
            this.brokerPool.shutdown();
            return null;
        }
    }
}

