/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import org.exist.Database;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.security.AbstractRealm;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Principal;
import org.exist.security.realm.Realm;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

@ConfigurationClass(value="")
public abstract class AbstractPrincipal
implements Principal {
    private Realm realm;
    @ConfigurationFieldAsElement(value="name")
    protected final String name;
    @ConfigurationFieldAsAttribute(value="id")
    protected final int id;
    public boolean removed = false;
    protected Configuration configuration = null;

    protected AbstractPrincipal(DBBroker broker, Realm realm, Collection collection, int id, String name) throws ConfigurationException {
        this.realm = realm;
        this.id = id;
        this.name = name;
        if (collection != null) {
            try {
                Configuration _config_ = Configurator.parse(this, broker, collection, XmldbURI.create(name + ".xml"));
                this.configuration = Configurator.configure(this, _config_);
            }
            catch (EXistException e) {
                throw new ConfigurationException(e);
            }
        }
    }

    public AbstractPrincipal(AbstractRealm realm, Configuration _config_) throws ConfigurationException {
        this.realm = realm;
        this.configuration = Configurator.configure(this, _config_);
        if (this.configuration == null) {
            throw new ConfigurationException("Configuration can't be NULL [" + _config_ + "]");
        }
        this.id = this.configuration.getPropertyInteger("id");
        this.name = this.configuration.getProperty("name");
    }

    @Override
    public void save() throws ConfigurationException, PermissionDeniedException {
        if (this.configuration != null) {
            this.configuration.save();
        }
    }

    @Override
    public void save(DBBroker broker) throws ConfigurationException, PermissionDeniedException {
        if (this.configuration != null) {
            this.configuration.save(broker);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public String getRealmId() {
        return this.realm.getId();
    }

    @Override
    public final boolean isConfigured() {
        return this.configuration != null;
    }

    @Override
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final void setCollection(DBBroker broker, Collection collection) throws ConfigurationException {
        if (collection != null) {
            Configurator.unregister(this.configuration);
            Configuration _config_ = Configurator.parse(this, broker, collection, XmldbURI.create(this.name + ".xml"));
            this.configuration = Configurator.configure(this, _config_);
        }
    }

    public final void setCollection(DBBroker broker, Collection collection, XmldbURI uri) throws ConfigurationException {
        if (collection != null) {
            Configurator.unregister(this.configuration);
            Configuration _config_ = Configurator.parse(this, broker, collection, uri);
            this.configuration = Configurator.configure(this, _config_);
        }
    }

    protected Database getDatabase() {
        return this.realm.getDatabase();
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }
}

