/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import com.evolvedbinary.j8fu.function.Consumer2E;
import com.evolvedbinary.j8fu.function.ConsumerE;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.AbstractPrincipal;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Principal;
import org.exist.security.SchemaType;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.AccountImpl;
import org.exist.security.internal.GroupImpl;
import org.exist.security.internal.SecurityManagerImpl;
import org.exist.security.realm.Realm;
import org.exist.security.utils.Utils;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public abstract class AbstractRealm
implements Realm,
Configurable {
    protected final PrincipalDbByName<Account> usersByName = new PrincipalDbByName();
    protected final PrincipalDbByName<Group> groupsByName = new PrincipalDbByName();
    private SecurityManager sm;
    protected Configuration configuration;
    protected org.exist.collections.Collection collectionRealm = null;
    protected org.exist.collections.Collection collectionAccounts = null;
    protected org.exist.collections.Collection collectionGroups = null;
    protected org.exist.collections.Collection collectionRemovedAccounts = null;
    protected org.exist.collections.Collection collectionRemovedGroups = null;

    public AbstractRealm(SecurityManager sm, Configuration config) {
        this.sm = sm;
        this.configuration = Configurator.configure(this, config);
    }

    @Override
    public Database getDatabase() {
        return this.getSecurityManager().getDatabase();
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.sm;
    }

    protected void initialiseRealmStorage(DBBroker broker) throws EXistException {
        XmldbURI realmCollectionURL = SecurityManager.SECURITY_COLLECTION_URI.append(this.getId());
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        try (Txn txn = transact.beginTransaction();){
            this.collectionRealm = Utils.getOrCreateCollection(broker, txn, realmCollectionURL);
            this.collectionAccounts = Utils.getOrCreateCollection(broker, txn, realmCollectionURL.append("accounts"));
            this.collectionGroups = Utils.getOrCreateCollection(broker, txn, realmCollectionURL.append("groups"));
            this.collectionRemovedAccounts = Utils.getOrCreateCollection(broker, txn, realmCollectionURL.append("accounts").append("removed"));
            this.collectionRemovedGroups = Utils.getOrCreateCollection(broker, txn, realmCollectionURL.append("groups").append("removed"));
            transact.commit(txn);
        }
        catch (IOException | TriggerException | PermissionDeniedException | LockException e) {
            throw new EXistException(e);
        }
    }

    private void loadGroupsFromRealmStorage(DBBroker broker) throws ConfigurationException, PermissionDeniedException, LockException {
        if (this.collectionGroups != null && this.collectionGroups.getDocumentCount(broker) > 0) {
            AbstractRealm r = this;
            Iterator<DocumentImpl> i = this.collectionGroups.iterator(broker);
            while (i.hasNext()) {
                Configuration conf = Configurator.parse(broker.getBrokerPool(), i.next());
                String name = conf.getProperty("name");
                this.groupsByName.modifyE(principalDb -> {
                    if (name != null && !principalDb.containsKey(name)) {
                        GroupImpl group = new GroupImpl(r, conf);
                        this.getSecurityManager().addGroup(group.getId(), (Group)group);
                        principalDb.put(group.getName(), group);
                        if (group.getId() > 0) {
                            group.setCollection(broker, this.collectionGroups);
                        }
                    }
                });
            }
        }
    }

    private void loadRemovedGroupsFromRealmStorage(DBBroker broker) throws ConfigurationException, PermissionDeniedException, LockException {
        if (this.collectionRemovedGroups != null && this.collectionRemovedGroups.getDocumentCount(broker) > 0) {
            Iterator<DocumentImpl> i = this.collectionRemovedGroups.iterator(broker);
            while (i.hasNext()) {
                Configuration conf = Configurator.parse(broker.getBrokerPool(), i.next());
                Integer id = conf.getPropertyInteger("id");
                if (id == null || this.getSecurityManager().hasGroup(id)) continue;
                GroupImpl group = new GroupImpl(this, conf);
                group.removed = true;
                this.getSecurityManager().addGroup(group.getId(), (Group)group);
            }
        }
    }

    private void loadAccountsFromRealmStorage(DBBroker broker) throws ConfigurationException, PermissionDeniedException, LockException {
        if (this.collectionAccounts != null && this.collectionAccounts.getDocumentCount(broker) > 0) {
            AbstractRealm r = this;
            Iterator<DocumentImpl> i = this.collectionAccounts.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = i.next();
                Configuration conf = Configurator.parse(broker.getBrokerPool(), doc);
                String name = conf.getProperty("name");
                this.usersByName.modifyE(principalDb -> {
                    if (name != null && !principalDb.containsKey(name)) {
                        AccountImpl account;
                        try {
                            account = new AccountImpl(r, conf);
                        }
                        catch (Throwable e) {
                            SecurityManagerImpl.LOG.error("Account object can't build up from '" + doc.getFileURI() + "'", e);
                            return;
                        }
                        this.getSecurityManager().addUser(account.getId(), account);
                        principalDb.put(account.getName(), account);
                        if (account.getId() > 0) {
                            ((AbstractPrincipal)account).setCollection(broker, this.collectionAccounts);
                        }
                    }
                });
            }
        }
    }

    private void loadRemovedAccountsFromRealmStorage(DBBroker broker) throws ConfigurationException, PermissionDeniedException, LockException {
        if (this.collectionRemovedAccounts != null && this.collectionRemovedAccounts.getDocumentCount(broker) > 0) {
            Iterator<DocumentImpl> i = this.collectionRemovedAccounts.iterator(broker);
            while (i.hasNext()) {
                Configuration conf = Configurator.parse(broker.getBrokerPool(), i.next());
                Integer id = conf.getPropertyInteger("id");
                if (id == null || this.getSecurityManager().hasUser(id)) continue;
                AccountImpl account = new AccountImpl(this, conf);
                account.removed = true;
                this.getSecurityManager().addUser(account.getId(), account);
            }
        }
    }

    @Override
    public void start(DBBroker broker) throws EXistException {
        this.initialiseRealmStorage(broker);
        try {
            this.loadGroupsFromRealmStorage(broker);
            this.loadRemovedGroupsFromRealmStorage(broker);
            this.loadAccountsFromRealmStorage(broker);
            this.loadRemovedAccountsFromRealmStorage(broker);
        }
        catch (PermissionDeniedException | LockException pde) {
            throw new EXistException(pde);
        }
    }

    @Override
    public void sync(DBBroker broker) throws EXistException {
    }

    @Override
    public void stop(DBBroker broker) throws EXistException {
    }

    public void save() throws PermissionDeniedException, EXistException, IOException {
        this.configuration.save();
    }

    public final Account registerAccount(Account account) {
        this.usersByName.modify(principalDb -> {
            if (principalDb.containsKey(account.getName())) {
                throw new IllegalArgumentException("Account " + account.getName() + " exist.");
            }
            principalDb.put(account.getName(), account);
        });
        return account;
    }

    public final Group registerGroup(Group group) {
        this.groupsByName.modify(principalDb -> {
            if (principalDb.containsKey(group.getName())) {
                throw new IllegalArgumentException("Group " + group.getName() + " already exists.");
            }
            principalDb.put(group.getName(), group);
        });
        return group;
    }

    @Override
    public Account getAccount(String name) {
        return this.usersByName.read(principalDb -> (Account)principalDb.get(name));
    }

    @Override
    public final boolean hasAccount(String accountName) {
        return this.usersByName.read(principalDb -> principalDb.containsKey(accountName));
    }

    @Override
    public final boolean hasAccount(Account account) {
        return this.hasAccount(account.getName());
    }

    @Override
    public final Collection<Account> getAccounts() {
        return this.usersByName.read(principalDb -> principalDb.values());
    }

    @Override
    public final boolean hasGroup(String groupName) {
        return this.groupsByName.read(principalDb -> principalDb.containsKey(groupName));
    }

    @Override
    public final boolean hasGroup(Group role) {
        return this.hasGroup(role.getName());
    }

    @Override
    public Group getGroup(String name) {
        return this.groupsByName.read(principalDb -> (Group)principalDb.get(name));
    }

    @Override
    public final Collection<Group> getRoles() {
        return this.getGroups();
    }

    @Override
    public final Collection<Group> getGroups() {
        return this.groupsByName.read(principalDb -> principalDb.values());
    }

    protected org.exist.collections.Collection getCollection() {
        return this.collectionRealm;
    }

    @Override
    public Group addGroup(DBBroker broker, Group group) throws PermissionDeniedException, EXistException {
        if (group.getRealmId() == null) {
            throw new ConfigurationException("Group's realmId is null.");
        }
        if (!this.getId().equals(group.getRealmId())) {
            throw new ConfigurationException("Group from different realm");
        }
        return this.getSecurityManager().addGroup(broker, group);
    }

    @Override
    public Account addAccount(Account account) throws PermissionDeniedException, EXistException, ConfigurationException {
        if (account.getRealmId() == null) {
            throw new ConfigurationException("Account's realmId is null.");
        }
        if (!this.getId().equals(account.getRealmId())) {
            throw new ConfigurationException("Account from different realm");
        }
        return this.getSecurityManager().addAccount(account);
    }

    @Override
    public boolean updateAccount(Account account) throws PermissionDeniedException, EXistException {
        int i;
        Subject user = this.getDatabase().getActiveBroker().getCurrentSubject();
        account.assertCanModifyAccount(user);
        Account updatingAccount = this.getAccount(account.getName());
        if (updatingAccount == null) {
            throw new PermissionDeniedException("account " + account.getName() + " does not exist");
        }
        String[] groups = account.getGroups();
        for (i = 0; i < groups.length; ++i) {
            if (updatingAccount.hasGroup(groups[i])) continue;
            updatingAccount.addGroup(groups[i]);
        }
        groups = updatingAccount.getGroups();
        for (i = 0; i < groups.length; ++i) {
            if (account.hasGroup(groups[i])) continue;
            updatingAccount.remGroup(groups[i]);
        }
        String passwd = account.getPassword();
        if (passwd != null) {
            updatingAccount.setPassword(account.getPassword());
        }
        updatingAccount.setUserMask(account.getUserMask());
        if (account.hashCode() != updatingAccount.hashCode()) {
            updatingAccount.clearMetadata();
            for (SchemaType key : account.getMetadataKeys()) {
                updatingAccount.setMetadataValue(key, account.getMetadataValue(key));
            }
        }
        ((AbstractPrincipal)((Object)updatingAccount)).save();
        return true;
    }

    @Override
    public boolean updateGroup(Group group) throws PermissionDeniedException, EXistException {
        Subject user = this.getDatabase().getActiveBroker().getCurrentSubject();
        group.assertCanModifyGroup(user);
        Group updatingGroup = this.getGroup(group.getName());
        if (updatingGroup == null) {
            throw new PermissionDeniedException("group " + group.getName() + " does not exist");
        }
        for (Account manager : group.getManagers()) {
            if (updatingGroup.isManager(manager)) continue;
            updatingGroup.addManager(manager);
        }
        for (Account manager : updatingGroup.getManagers()) {
            if (group.isManager(manager)) continue;
            updatingGroup.removeManager(manager);
        }
        if (group.hashCode() != updatingGroup.hashCode()) {
            updatingGroup.clearMetadata();
            for (SchemaType key : group.getMetadataKeys()) {
                updatingGroup.setMetadataValue(key, group.getMetadataValue(key));
            }
        }
        updatingGroup.save();
        return true;
    }

    @Override
    public Group getExternalGroup(String name) {
        return this.getSecurityManager().getGroup(name);
    }

    @Override
    public boolean isConfigured() {
        return this.configuration != null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public List<String> findUsernamesWhereNameStarts(String startsWith) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> findUsernamesWhereUsernameStarts(String startsWith) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> findAllGroupNames() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> findAllUserNames() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> findAllGroupMembers(String groupName) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> findUsernamesWhereNamePartStarts(String startsWith) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection<? extends String> findGroupnamesWhereGroupnameStarts(String startsWith) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection<? extends String> findGroupnamesWhereGroupnameContains(String fragment) {
        return Collections.EMPTY_LIST;
    }

    protected static class PrincipalDbByName<V extends Principal> {
        private final Map<String, V> db = new HashMap<String, V>(65);
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

        protected PrincipalDbByName() {
        }

        public <R> R read(Function<Map<String, V>, R> readOp) {
            this.readLock.lock();
            try {
                R r = readOp.apply(this.db);
                return r;
            }
            finally {
                this.readLock.unlock();
            }
        }

        public final void modify(Consumer<Map<String, V>> writeOp) {
            this.writeLock.lock();
            try {
                writeOp.accept(this.db);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public final <E extends Throwable> void modifyE(ConsumerE<Map<String, V>, E> writeOp) throws E {
            this.writeLock.lock();
            try {
                writeOp.accept(this.db);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public final <E1 extends Exception, E2 extends Exception> void modify2E(Consumer2E<Map<String, V>, E1, E2> writeOp) throws E1, E2 {
            this.writeLock.lock();
            try {
                writeOp.accept(this.db);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

