/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.security.Account;
import org.exist.security.Credential;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.Session;
import org.exist.security.Subject;
import org.exist.security.realm.Realm;
import org.exist.storage.DBBroker;

public class EffectiveSubject
implements Subject {
    private final Account account;
    private final Group group;

    public EffectiveSubject(Account account) {
        this(account, null);
    }

    public EffectiveSubject(Account account, Group group) {
        this.account = account;
        this.group = group;
    }

    @Override
    public String getRealmId() {
        return this.account.getRealmId();
    }

    @Override
    public Realm getRealm() {
        return this.account.getRealm();
    }

    @Override
    public int getId() {
        return this.account.getId();
    }

    @Override
    public String getUsername() {
        return this.account.getUsername();
    }

    @Override
    public String getName() {
        return this.account.getName();
    }

    @Override
    public boolean authenticate(Object credentials) {
        return false;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isExternallyAuthenticated() {
        return false;
    }

    @Override
    public boolean isAccountNonExpired() {
        return this.account.isAccountNonExpired();
    }

    @Override
    public boolean isAccountNonLocked() {
        return this.account.isAccountNonLocked();
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return this.account.isCredentialsNonExpired();
    }

    @Override
    public boolean isEnabled() {
        return this.account.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException("You cannot change the Enabled status of the Effective User.");
    }

    @Override
    public String getSessionId() {
        throw new UnsupportedOperationException("The Effective User has no session!");
    }

    @Override
    public Session getSession() {
        throw new UnsupportedOperationException("The Effective User has no session!");
    }

    @Override
    public String[] getGroups() {
        if (this.group != null) {
            HashSet<String> groups = new HashSet<String>(Arrays.asList(this.account.getGroups()));
            groups.add(this.group.getName());
            return groups.toArray(new String[groups.size()]);
        }
        return this.account.getGroups();
    }

    @Override
    public int[] getGroupIds() {
        if (this.group != null) {
            HashSet<Integer> groupIds = new HashSet<Integer>(Arrays.asList(ArrayUtils.toObject((int[])this.account.getGroupIds())));
            groupIds.add(this.group.getId());
            return ArrayUtils.toPrimitive((Integer[])groupIds.toArray(new Integer[groupIds.size()]));
        }
        return this.account.getGroupIds();
    }

    @Override
    public boolean hasDbaRole() {
        if (this.group != null) {
            return this.account.hasDbaRole() || this.group.getId() == 1048575;
        }
        return this.account.hasDbaRole();
    }

    @Override
    public String getPrimaryGroup() {
        return this.account.getPrimaryGroup();
    }

    @Override
    public Group getDefaultGroup() {
        return this.account.getDefaultGroup();
    }

    @Override
    public boolean hasGroup(String group) {
        if (this.group != null) {
            return this.group.getName().equals(group);
        }
        return this.account.hasGroup(group);
    }

    @Override
    public Group addGroup(String name) throws PermissionDeniedException {
        throw new UnsupportedOperationException("You cannot add a group to the Effective User");
    }

    @Override
    public Group addGroup(Group group) throws PermissionDeniedException {
        throw new UnsupportedOperationException("You cannot add a group to the Effective User");
    }

    @Override
    public void setPrimaryGroup(Group group) throws PermissionDeniedException {
        throw new UnsupportedOperationException("You cannot add a group to the Effective User");
    }

    @Override
    public void setGroups(String[] groups) {
        throw new UnsupportedOperationException("You cannot set the groups of the Effective User");
    }

    @Override
    public void remGroup(String group) throws PermissionDeniedException {
        throw new UnsupportedOperationException("You cannot remove a group from the Effective User");
    }

    @Override
    public void setPassword(String passwd) {
        throw new UnsupportedOperationException("The Effective User has no password!");
    }

    @Override
    public void setCredential(Credential credential) {
        throw new UnsupportedOperationException("The Effective User has no credential!");
    }

    @Override
    public String getPassword() {
        throw new UnsupportedOperationException("The Effective User has no password!");
    }

    @Override
    public String getDigestPassword() {
        throw new UnsupportedOperationException("The Effective User has no password!");
    }

    @Override
    public void assertCanModifyAccount(Account user) throws PermissionDeniedException {
        throw new PermissionDeniedException("The Effective User account cannot be modified");
    }

    @Override
    public int getUserMask() {
        return this.account.getUserMask();
    }

    @Override
    public void setUserMask(int umask) {
        throw new UnsupportedOperationException("You cannot set the UserMask of the Effective User");
    }

    @Override
    public String getMetadataValue(SchemaType schemaType) {
        return this.account.getMetadataValue(schemaType);
    }

    @Override
    public Set<SchemaType> getMetadataKeys() {
        return this.account.getMetadataKeys();
    }

    @Override
    public void setMetadataValue(SchemaType schemaType, String value) {
        throw new UnsupportedOperationException("You cannot modify the metadata of the Effective User");
    }

    @Override
    public void clearMetadata() {
        throw new UnsupportedOperationException("You cannot modify the metadata of the Effective User");
    }

    @Override
    public void save() throws ConfigurationException, PermissionDeniedException {
        throw new UnsupportedOperationException("You cannot perist the Effective User.");
    }

    @Override
    public void save(DBBroker broker) throws ConfigurationException, PermissionDeniedException {
        throw new UnsupportedOperationException("You cannot perist the Effective User.");
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }
}

