/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.HashMap;
import java.util.Map;
import org.exist.EXistException;
import org.exist.security.Subject;
import org.exist.security.UUIDGenerator;
import org.exist.storage.BrokerPool;

public class Session {
    private String id;
    private Subject subject;
    private long lastUse;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Session(Subject subject) {
        this.id = UUIDGenerator.getUUID();
        this.subject = subject;
        this.used();
        try {
            BrokerPool.getInstance().getSecurityManager().registerSession(this);
        }
        catch (EXistException eXistException) {
            // empty catch block
        }
    }

    private void used() {
        this.lastUse = System.currentTimeMillis();
    }

    public String getId() {
        this.used();
        return this.id;
    }

    public void setProperty(String name, Object value) {
        this.used();
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        this.used();
        return this.properties.get(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Subject getSubject() {
        this.used();
        return this.subject;
    }

    public boolean isValid() {
        return System.currentTimeMillis() - this.lastUse <= 30000L;
    }
}

