/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.io.IOException;
import java.util.Arrays;
import org.exist.security.ACLPermission;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionRequired;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.UnixStylePermission;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class SimpleACLPermission
extends UnixStylePermission
implements ACLPermission {
    public static final short VERSION = 1;
    private static final int MAX_ACL_LENGTH = 255;
    private int[] acl = new int[0];

    public SimpleACLPermission(SecurityManager sm) {
        super(sm);
    }

    public SimpleACLPermission(SecurityManager sm, long vector) {
        super(sm, vector);
    }

    public SimpleACLPermission(SecurityManager sm, int ownerId, int groupId, int mode) {
        super(sm, ownerId, groupId, mode);
    }

    public void addUserACE(ACLPermission.ACE_ACCESS_TYPE access_type, int userId, int mode) throws PermissionDeniedException {
        this.addACE(access_type, ACLPermission.ACE_TARGET.USER, userId, mode);
    }

    public void addGroupACE(ACLPermission.ACE_ACCESS_TYPE access_type, int groupId, int mode) throws PermissionDeniedException {
        this.addACE(access_type, ACLPermission.ACE_TARGET.GROUP, groupId, mode);
    }

    public void addACE(ACLPermission.ACE_ACCESS_TYPE access_type, ACLPermission.ACE_TARGET target, String name, String modeStr) throws PermissionDeniedException {
        this.addACE(access_type, target, this.lookupTargetId(target, name), this.modeStrToMode(modeStr));
    }

    @Override
    public void addACE(ACLPermission.ACE_ACCESS_TYPE access_type, ACLPermission.ACE_TARGET target, String name, int mode) throws PermissionDeniedException {
        this.addACE(access_type, target, this.lookupTargetId(target, name), mode);
    }

    @PermissionRequired(user=6, mode=4)
    private void addACE(ACLPermission.ACE_ACCESS_TYPE access_type, ACLPermission.ACE_TARGET target, int id, int mode) throws PermissionDeniedException {
        if (this.acl.length >= 255) {
            throw new PermissionDeniedException("Maximum of 255 ACEs has been reached.");
        }
        int[] newAcl = new int[this.acl.length + 1];
        System.arraycopy(this.acl, 0, newAcl, 0, this.acl.length);
        newAcl[newAcl.length - 1] = this.encodeAsACE(access_type, target, id, mode);
        this.acl = newAcl;
    }

    public void insertUserACE(int index, ACLPermission.ACE_ACCESS_TYPE access_type, int userId, int mode) throws PermissionDeniedException {
        this.insertACE(index, access_type, ACLPermission.ACE_TARGET.USER, userId, mode);
    }

    public void insertGroupACE(int index, ACLPermission.ACE_ACCESS_TYPE access_type, int groupId, int mode) throws PermissionDeniedException {
        this.insertACE(index, access_type, ACLPermission.ACE_TARGET.GROUP, groupId, mode);
    }

    public void insertACE(int index, ACLPermission.ACE_ACCESS_TYPE access_type, ACLPermission.ACE_TARGET target, String name, String modeStr) throws PermissionDeniedException {
        this.insertACE(index, access_type, target, this.lookupTargetId(target, name), this.modeStrToMode(modeStr));
    }

    @PermissionRequired(user=6, mode=4)
    private void insertACE(int index, ACLPermission.ACE_ACCESS_TYPE access_type, ACLPermission.ACE_TARGET target, int id, int mode) throws PermissionDeniedException {
        if (this.acl.length >= 255) {
            throw new PermissionDeniedException("Maximum of 255 ACEs has been reached.");
        }
        if (index < 0 || this.acl.length > 0 && this.acl.length <= index) {
            throw new PermissionDeniedException("No Such ACE index " + index + " in ACL.");
        }
        int[] newAcl = new int[this.acl.length + 1];
        System.arraycopy(this.acl, 0, newAcl, 0, index);
        newAcl[index] = this.encodeAsACE(access_type, target, id, mode);
        if (this.acl.length > 0) {
            System.arraycopy(this.acl, index, newAcl, index + 1, newAcl.length - index - 1);
        }
        this.acl = newAcl;
    }

    private int modeStrToMode(String modeStr) throws PermissionDeniedException {
        if (modeStr == null || modeStr.length() == 0 || modeStr.length() > 3) {
            throw new PermissionDeniedException("Invalid mode string '" + modeStr + "'");
        }
        int mode = 0;
        block6: for (char c : modeStr.toCharArray()) {
            switch (c) {
                case 'r': {
                    mode |= 4;
                    continue block6;
                }
                case 'w': {
                    mode |= 2;
                    continue block6;
                }
                case 'x': {
                    mode |= 1;
                    continue block6;
                }
                case '-': {
                    continue block6;
                }
                default: {
                    throw new PermissionDeniedException("Unknown char '" + c + "' in mode string '" + modeStr + "'");
                }
            }
        }
        return mode;
    }

    private int lookupTargetId(ACLPermission.ACE_TARGET target, String targetName) throws PermissionDeniedException {
        int id;
        if (target == ACLPermission.ACE_TARGET.USER) {
            Account account = this.sm.getAccount(targetName);
            if (account == null) {
                throw new PermissionDeniedException("User Account for username '" + targetName + "' is unknown.");
            }
            id = account.getId();
        } else if (target == ACLPermission.ACE_TARGET.GROUP) {
            Group group = this.sm.getGroup(targetName);
            if (group == null) {
                throw new PermissionDeniedException("User Group for groupname '" + targetName + "' is unknown.");
            }
            id = group.getId();
        } else {
            throw new PermissionDeniedException("Unknown ACE_TARGET type");
        }
        return id;
    }

    private int encodeAsACE(ACLPermission.ACE_ACCESS_TYPE access_type, ACLPermission.ACE_TARGET target, int id, int mode) {
        return target.getVal() << 26 | (id &= 0xFFFFF) << 6 | (mode &= 7) << 3 | access_type.getVal();
    }

    @PermissionRequired(user=6, mode=4)
    public void removeACE(int index) throws PermissionDeniedException {
        if (index < 0 || index >= this.acl.length) {
            throw new PermissionDeniedException("ACL Entry does not exist");
        }
        int[] newAcl = new int[this.acl.length - 1];
        System.arraycopy(this.acl, 0, newAcl, 0, index);
        System.arraycopy(this.acl, index + 1, newAcl, index, newAcl.length - index);
        this.acl = newAcl;
    }

    public void modifyACE(int index, ACLPermission.ACE_ACCESS_TYPE access_type, String modeStr) throws PermissionDeniedException {
        this.modifyACE(index, access_type, this.modeStrToMode(modeStr));
    }

    @PermissionRequired(user=6, mode=4)
    public void modifyACE(int index, ACLPermission.ACE_ACCESS_TYPE access_type, int mode) throws PermissionDeniedException {
        if (index < 0 || index >= this.acl.length) {
            throw new PermissionDeniedException("ACL Entry does not exist");
        }
        int ace = this.acl[index];
        this.acl[index] = ace >>> 6 << 6 | mode << 3 | access_type.getVal();
    }

    @Override
    @PermissionRequired(user=6, mode=4)
    public void clear() throws PermissionDeniedException {
        this.acl = new int[0];
    }

    public int getACEId(int index) {
        return this.acl[index] >>> 6 & 0xFFFFF;
    }

    @Override
    public String getACEWho(int index) {
        switch (this.getACETarget(index)) {
            case USER: {
                return this.sm.getAccount(this.getACEId(index)).getName();
            }
            case GROUP: {
                return this.sm.getGroup(this.getACEId(index)).getName();
            }
        }
        return null;
    }

    @Override
    public int getACEMode(int index) {
        return this.acl[index] >>> 3 & 7;
    }

    public String getACEModeString(int index) {
        int aceMode = this.getACEMode(index);
        char[] ch = new char[]{(aceMode & 4) != 4 ? (char)'-' : 'r', (aceMode & 2) != 2 ? (char)'-' : 'w', (aceMode & 1) != 1 ? (char)'-' : 'x'};
        return String.valueOf(ch);
    }

    @Override
    public ACLPermission.ACE_TARGET getACETarget(int index) {
        return ACLPermission.ACE_TARGET.fromVal(this.acl[index] >>> 26);
    }

    @Override
    public ACLPermission.ACE_ACCESS_TYPE getACEAccessType(int index) {
        return ACLPermission.ACE_ACCESS_TYPE.fromVal(this.acl[index] & 7);
    }

    @Override
    public int getACECount() {
        return this.acl.length;
    }

    @Override
    public void read(VariableByteInput istream) throws IOException {
        super.read(istream);
        int aclLength = istream.read();
        this.acl = new int[aclLength];
        for (int i = 0; i < aclLength; ++i) {
            this.acl[i] = istream.readInt();
        }
    }

    @Override
    public void write(VariableByteOutputStream ostream) throws IOException {
        super.write(ostream);
        ostream.write(this.acl.length);
        for (int i = 0; i < this.acl.length; ++i) {
            ostream.writeInt(this.acl[i]);
        }
    }

    @Override
    public boolean validate(Subject user, int mode) {
        if (user.hasDbaRole()) {
            return true;
        }
        int userId = user.getId();
        int[] userGroupIds = user.getGroupIds();
        for (int ace : this.acl) {
            int aceTarget = ace >>> 26;
            int id = ace >>> 6 & 0xFFFFF;
            int aceMode = ace >>> 3 & 7;
            int accessType = ace & 7;
            if ((aceTarget & ACLPermission.ACE_TARGET.USER.getVal()) == ACLPermission.ACE_TARGET.USER.getVal()) {
                if (id != userId || (aceMode & mode) != mode) continue;
                return accessType == ACLPermission.ACE_ACCESS_TYPE.ALLOWED.getVal();
            }
            if ((aceTarget & ACLPermission.ACE_TARGET.GROUP.getVal()) != ACLPermission.ACE_TARGET.GROUP.getVal()) continue;
            for (int userGroupId : userGroupIds) {
                if (userGroupId != id || (aceMode & mode) != mode) continue;
                return accessType == ACLPermission.ACE_ACCESS_TYPE.ALLOWED.getVal();
            }
        }
        if ((long)userId == this.vector >>> 32) {
            return ((long)mode & (this.vector >>> 28 & 7L)) == (long)mode;
        }
        int groupId = (int)(this.vector >>> 8 & 0xFFFFFL);
        for (int userGroupId : userGroupIds) {
            if (userGroupId != groupId) continue;
            return ((long)mode & (this.vector >>> 4 & 7L)) == (long)mode;
        }
        return ((long)mode & (this.vector & 7L)) == (long)mode;
    }

    @Override
    public short getVersion() {
        return 1;
    }

    @Override
    public boolean isCurrentSubjectCanWriteACL() {
        return this.validate(this.getCurrentSubject(), 2);
    }

    @Override
    public SimpleACLPermission copy() {
        SimpleACLPermission prm = new SimpleACLPermission(this.sm, this.vector);
        prm.acl = new int[this.acl.length];
        System.arraycopy(this.acl, 0, prm.acl, 0, this.acl.length);
        return prm;
    }

    @PermissionRequired(user=6, mode=4)
    public void copyAclOf(SimpleACLPermission simpleACLPermission) {
        this.acl = Arrays.copyOf(simpleACLPermission.acl, simpleACLPermission.acl.length);
    }
}

