/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.security.AbstractAccount;
import org.exist.security.AbstractRealm;
import org.exist.security.Account;
import org.exist.security.Credential;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.Subject;
import org.exist.security.internal.Password;
import org.exist.security.internal.aider.UserAider;
import org.exist.storage.DBBroker;

@ConfigurationClass(value="account")
public class AccountImpl
extends AbstractAccount {
    private static final Logger LOG = LogManager.getLogger(AccountImpl.class);
    public static boolean CHECK_PASSWORDS = true;
    private static final SecurityProperties securityProperties = new SecurityProperties();
    @ConfigurationFieldAsElement(value="password")
    private String password = null;
    @ConfigurationFieldAsElement(value="digestPassword")
    private String digestPassword = null;

    public static SecurityProperties getSecurityProperties() {
        return securityProperties;
    }

    public AccountImpl(DBBroker broker, AbstractRealm realm, int id, String name, String password) throws ConfigurationException {
        super(broker, realm, id, name);
        this.setPassword(password);
    }

    public AccountImpl(DBBroker broker, AbstractRealm realm, int id, String name, String password, Group group, boolean hasDbaRole) throws ConfigurationException {
        super(broker, realm, id, name);
        this.setPassword(password);
        this.groups.add(group);
        this.hasDbaRole = hasDbaRole;
    }

    public AccountImpl(DBBroker broker, AbstractRealm realm, int id, String name, String password, Group group) throws ConfigurationException {
        super(broker, realm, id, name);
        this.setPassword(password);
        this.groups.add(group);
    }

    public AccountImpl(DBBroker broker, AbstractRealm realm, String name) throws ConfigurationException {
        super(broker, realm, -1, name);
    }

    public AccountImpl(DBBroker broker, AbstractRealm realm, int id, Account from_user) throws ConfigurationException, PermissionDeniedException {
        super(broker, realm, id, from_user.getName());
        this.instantiate(from_user);
    }

    private void instantiate(Account from_user) throws PermissionDeniedException {
        Account user;
        for (SchemaType metadataKey : from_user.getMetadataKeys()) {
            String metadataValue = from_user.getMetadataValue(metadataKey);
            this.setMetadataValue(metadataKey, metadataValue);
        }
        this.setUserMask(from_user.getUserMask());
        if (from_user instanceof AccountImpl) {
            user = (AccountImpl)from_user;
            this.groups = new ArrayList(((AccountImpl)user).groups);
            this.password = ((AccountImpl)user).password;
            this.digestPassword = ((AccountImpl)user).digestPassword;
            this.hasDbaRole = ((AccountImpl)user).hasDbaRole;
            this._cred = ((AccountImpl)user)._cred;
        } else if (from_user instanceof UserAider) {
            String[] groups;
            user = (UserAider)from_user;
            for (String group : groups = ((UserAider)user).getGroups()) {
                this.addGroup(group);
            }
            this.setPassword(((UserAider)user).getPassword());
            this.digestPassword = ((UserAider)user).getDigestPassword();
        } else {
            this.addGroup(from_user.getDefaultGroup());
        }
    }

    public AccountImpl(DBBroker broker, AbstractRealm realm, AccountImpl from_user) throws ConfigurationException {
        super(broker, realm, from_user.id, from_user.name);
        for (SchemaType metadataKey : from_user.getMetadataKeys()) {
            String metadataValue = from_user.getMetadataValue(metadataKey);
            this.setMetadataValue(metadataKey, metadataValue);
        }
        this.groups = from_user.groups;
        this.password = from_user.password;
        this.digestPassword = from_user.digestPassword;
        this.hasDbaRole = from_user.hasDbaRole;
        this._cred = from_user._cred;
    }

    public AccountImpl(AbstractRealm realm, Configuration configuration) throws ConfigurationException {
        super(realm, configuration);
        if (this.configuration != null) {
            this.configuration = Configurator.configure(this, this.configuration);
        }
        this.hasDbaRole = this.hasGroup("dba");
    }

    public AccountImpl(AbstractRealm realm, Configuration configuration, boolean removed) throws ConfigurationException {
        this(realm, configuration);
        this.removed = removed;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    @Override
    public final String getDigestPassword() {
        return this.digestPassword;
    }

    @Override
    public final void setPassword(String passwd) {
        this._cred = new Password(this, passwd);
        if (passwd == null) {
            this.password = null;
            this.digestPassword = null;
        } else {
            this.password = this._cred.toString();
            this.digestPassword = this._cred.getDigest();
        }
    }

    @Override
    public void setCredential(Credential credential) {
        this._cred = credential;
        this.password = this._cred.toString();
        this.digestPassword = this._cred.getDigest();
    }

    public final Group insertGroup(int index, String name) throws PermissionDeniedException {
        Group group = Optional.ofNullable(this.getRealm().getGroup(name)).orElse(this.getRealm().getSecurityManager().getGroup(name));
        return this.insertGroup(index, group);
    }

    private Group insertGroup(int index, Group group) throws PermissionDeniedException {
        if (group == null) {
            return null;
        }
        Subject user = this.getDatabase().getActiveBroker().getCurrentSubject();
        group.assertCanModifyGroup(user);
        if (!this.groups.contains(group)) {
            this.groups.add(index, group);
            if ("dba".equals(group.getName())) {
                this.hasDbaRole = true;
            }
        }
        return group;
    }

    public static final class SecurityProperties {
        private static final boolean DEFAULT_CHECK_PASSWORDS = true;
        private static final String PROP_CHECK_PASSWORDS = "passwords.check";
        private Properties loadedSecurityProperties = null;
        private Boolean checkPasswords = null;

        public synchronized boolean isCheckPasswords() {
            if (this.checkPasswords == null) {
                String property = this.getProperty(PROP_CHECK_PASSWORDS);
                this.checkPasswords = property == null || property.length() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(property.equalsIgnoreCase("yes") || property.equalsIgnoreCase("true"));
            }
            return this.checkPasswords;
        }

        public synchronized void enableCheckPasswords(boolean enable) {
            this.checkPasswords = enable;
        }

        private synchronized String getProperty(String propertyName) {
            if (this.loadedSecurityProperties == null) {
                this.loadedSecurityProperties = new Properties();
                try (InputStream is = AccountImpl.class.getResourceAsStream("security.properties");){
                    if (is != null) {
                        this.loadedSecurityProperties.load(is);
                    }
                }
                catch (IOException ioe) {
                    LOG.error("Unable to load security.properties, using defaults. " + ioe.getMessage(), (Throwable)ioe);
                }
            }
            return this.loadedSecurityProperties.getProperty(propertyName);
        }
    }
}

