/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.exist.EXistException;
import org.exist.security.AuthenticationException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;

public class EXistDBLoginModule
implements LoginModule {
    private javax.security.auth.Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private Subject userPrincipal = null;

    @Override
    public void initialize(javax.security.auth.Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        char[] password;
        String username;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("user name: "), new PasswordCallback("password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information from the user");
        }
        if (this.debug) {
            System.out.println("\t\t[eXistLoginModule] user entered user name: " + username);
        }
        try {
            this.userPrincipal = BrokerPool.getInstance().getSecurityManager().authenticate(username, password);
        }
        catch (AuthenticationException e) {
            if (this.debug) {
                System.out.println("\t\t[eXistLoginModule] authentication failed");
            }
            throw new FailedLoginException(e.getMessage());
        }
        catch (EXistException e) {
            throw new FailedLoginException(e.getMessage());
        }
        this.succeeded = this.userPrincipal.isAuthenticated();
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[eXistLoginModule] added User to Subject");
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = this.commitSucceeded;
        this.userPrincipal = null;
        return true;
    }
}

