/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal;

import gnu.crypto.hash.MD5;
import gnu.crypto.hash.RipeMD160;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.exist.security.Account;
import org.exist.security.Credential;
import org.exist.security.MessageDigester;

public class Password
implements Credential {
    private final String pw;
    private final String digestPw;
    public static final Hash DEFAULT_ALGORITHM = Hash.RIPEMD160;
    private final Hash algorithm;
    final Pattern ptnHash = Pattern.compile("\\{([A-Z0-9]+)\\}(.*)");

    public Password(Account account, String password) {
        if (password == null) {
            this.algorithm = DEFAULT_ALGORITHM;
            this.pw = null;
            this.digestPw = null;
        } else {
            Matcher mtcHash = this.ptnHash.matcher(password);
            if (mtcHash.matches()) {
                this.algorithm = Hash.valueOf(mtcHash.group(1));
                this.pw = mtcHash.group(2);
            } else {
                this.algorithm = DEFAULT_ALGORITHM;
                this.pw = this.hashAndEncode(password);
            }
            this.digestPw = this.digest(account.getName(), account.getRealmId(), this.pw);
        }
    }

    public Password(Account account, Hash algorithm, String encodedHash) {
        this.algorithm = algorithm;
        this.pw = encodedHash;
        this.digestPw = this.digest(account.getName(), account.getRealmId(), this.pw);
    }

    @Override
    public String getDigest() {
        return this.digestPw;
    }

    final String digest(String username, String realmId, String p) {
        return MessageDigester.byteArrayToHex(this.hash(username + ":" + realmId + ":" + p));
    }

    final String hashAndEncode(String p) {
        return Base64.encodeBase64String((byte[])this.hash(p));
    }

    final byte[] hash(String p) {
        switch (this.algorithm) {
            case RIPEMD160: {
                return this.ripemd160Hash(p);
            }
            case MD5: {
                return this.md5Hash(p);
            }
        }
        return null;
    }

    final byte[] ripemd160Hash(String p) {
        RipeMD160 ripemd160 = new RipeMD160();
        byte[] data = p.getBytes();
        ripemd160.update(data, 0, data.length);
        byte[] hash = ripemd160.digest();
        return hash;
    }

    final byte[] md5Hash(String p) {
        MD5 md5 = new MD5();
        byte[] data = p.getBytes();
        md5.update(data, 0, data.length);
        byte[] hash = md5.digest();
        return hash;
    }

    @Override
    public boolean check(Object credentials) {
        if (credentials == this) {
            return true;
        }
        if (credentials == null) {
            credentials = "";
        }
        if (credentials instanceof Password || credentials instanceof String) {
            return this.equals(credentials);
        }
        if (credentials instanceof char[]) {
            return this.equals(String.valueOf((char[])credentials));
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Password) {
            Password p = (Password)obj;
            if (this.algorithm != p.algorithm) {
                throw new RuntimeException("Cannot compare passwords with different algorithms i.e. " + (Object)((Object)this.algorithm) + " and " + (Object)((Object)p.algorithm));
            }
            return this.pw == p.pw || this.pw != null && this.pw.equals(p.pw);
        }
        if (obj instanceof String) {
            return this.hashAndEncode((String)obj).equals(this.pw);
        }
        return false;
    }

    public String toString() {
        return "{" + (Object)((Object)this.algorithm) + "}" + this.pw;
    }

    public static enum Hash {
        MD5,
        RIPEMD160;

    }
}

