/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal;

import java.util.List;
import java.util.Optional;
import org.exist.Database;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeSet;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.EventAuthentication;
import org.exist.security.internal.SecurityManagerImpl;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.ProcessMonitor;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.ContextItemDeclaration;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

@ConfigurationClass(value="events")
public class SMEvents
implements Configurable {
    public static final String NAMESPACE_URI = "http://exist-db.org/security/events";
    public static final String PREFIX = "sec-ev";
    @ConfigurationFieldAsAttribute(value="script-uri")
    protected String scriptURI = "";
    @ConfigurationFieldAsElement(value="authentication")
    protected EventAuthentication authentication = null;
    protected SecurityManager sm;
    private Configuration configuration = null;

    public SMEvents(SecurityManagerImpl sm, Configuration config) {
        this.sm = sm;
        this.configuration = Configurator.configure(this, config);
    }

    public Database getDatabase() {
        return this.sm.getDatabase();
    }

    public SecurityManager getSecurityManager() {
        return this.sm;
    }

    protected void authenticated(Subject subject) {
        if (this.authentication == null) {
            this.runScript(subject, this.scriptURI, null, EventAuthentication.functionName, null);
        } else {
            this.authentication.onEvent(subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runScript(Subject subject, String scriptURI, String script, QName functionName, List<Expression> args) {
        Database db = this.getDatabase();
        try (DBBroker broker = db.get(Optional.ofNullable(subject));){
            Source source = this.getQuerySource(broker, scriptURI, script);
            if (source == null) {
                return;
            }
            XQuery xquery = broker.getBrokerPool().getXQueryService();
            XQueryContext context = new XQueryContext(broker.getBrokerPool());
            CompiledXQuery compiled = xquery.compile(broker, context, source);
            ProcessMonitor pm = db.getProcessMonitor();
            try {
                UserDefinedFunction function = context.resolveFunction(functionName, 0);
                if (function != null) {
                    ContextItemDeclaration cid;
                    context.getProfiler().traceQueryStart();
                    pm.queryStarted(context.getWatchDog());
                    FunctionCall call = new FunctionCall(context, function);
                    if (args != null) {
                        call.setArguments(args);
                    }
                    Sequence contextSequence = (cid = context.getContextItemDeclartion()) != null ? cid.eval(null) : NodeSet.EMPTY_SET;
                    call.analyze(new AnalyzeContextInfo());
                    call.eval(contextSequence);
                }
            }
            catch (XPathException e) {
                e.printStackTrace();
            }
            finally {
                if (pm != null) {
                    context.getProfiler().traceQueryEnd(context);
                    pm.queryCompleted(context.getWatchDog());
                }
                compiled.reset();
                context.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Source getQuerySource(DBBroker broker, String scriptURI, String script) {
        if (scriptURI != null) {
            DocumentImpl resource = null;
            try {
                XmldbURI pathUri = XmldbURI.create(scriptURI);
                resource = broker.getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
                if (resource == null) return null;
                DBSource dBSource = new DBSource(broker, (BinaryDocument)resource, true);
                return dBSource;
            }
            catch (PermissionDeniedException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        } else {
            if (script == null || script.isEmpty()) return null;
            return new StringSource(script);
        }
    }

    @Override
    public boolean isConfigured() {
        return this.configuration != null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

